#version 120
#pragma optionNV unroll all
#define MAX_LIGHTS 14
#define MAX_BONES 78

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];

varying vec3 alightVec[MAX_LIGHTS];
//varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];

uniform vec4 glColor;
uniform vec3 camPos;

    varying vec3 v;
    varying vec3 vcam;
    varying vec4 vcam4;
    varying vec3 N;
    varying vec3 T;
    varying vec3 B;

//varying vec3 vNormal;
//uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
//attribute vec3 vTangent;
vec3 tmpVec;


void main(void)
{
vec4 vP;
vec4 vN;
vec4 vT;
	//gl_Position = ftransform();
	//gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	//texCoord = gl_MultiTexCoord0.xy;
	vP=vec4(vertexPosition.xyz, 1.0);
	vN=vec4(vertexNormal.xyz, 1.0);
	vT=vec4(vertexTangent.xyz, 1.0);
    //vertexBones.x+=1;vertexBones.y+=1;vertexBones.z+=1;vertexBones.w+=1;

    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0); //there's a risk w wouldn't always be 1, so just to be sure

    texCoord = textureCoord;

	//vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
	vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
	//vec4 n4 = normalize(gl_ModelViewProjectionMatrix * vec4(vN.x,vN.y,vN.z,1.0));
	//vec4 t4 = normalize(gl_ModelViewProjectionMatrix * vec4(vT.x,vT.y,vT.z,1.0));
	//vec3 n=vec3(n4.x,n4.y,n4.z);
	//vec3 t=vec3(t4.x,t4.y,t4.z);

//bitangent = cross(normal, tangent.xyz)*tangent.w; // from http://www.gamedev.net/topic/320413-calculating-tangent-vectors-for-normal-bump-mappinghelp-again/
	vec3 b = cross(n, t) * vertexTangentHandedness;
    //b = b * vertexTangentHandedness;
	//vec3 b = cross(n, t);// * vertexTangentHandedness;
	//vec3 b = cross(t, n);

	//vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vertexPosition.xyz, 1.0));
	vec3 vVertex = (gl_ModelViewMatrix * vec4(vP.xyz, 1.0)).xyz;

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	//tmpVec = gl_LightSource[i].position.xyz - vVertex;
    tmpVec = vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;
//	aeyeVec[i].x = dot(tmpVec, t);
//	aeyeVec[i].y = dot(tmpVec, b);
//	aeyeVec[i].z = dot(tmpVec, n);
	}
   }

   //vNormal = vertexTangent;
   //vNormal = vertexNormal;
    v=vVertex;
    vcam=(gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0)).xyz;
    vcam4=(gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0));
    N=normalize(n);
    T=normalize(t);
    B=normalize(b);
    }
