varying vec2 texCoord;
uniform sampler2D colorMap;
uniform sampler2D displaceMap;
uniform sampler2D shadowMap;
uniform sampler2D colorAbber;
uniform float flagAnim;

void main (void)
{
    float s=texture2D(displaceMap, texCoord).r;
    float sc=s/2.5f+flagAnim;

    float xss=sin(sc*5.0f+texCoord.y*8.0f)/30.0f;
    float yss=cos(sc*4.0f+texCoord.x*8.0f)/30.0f;
    float xs=texCoord.x+xss;
    float ys=texCoord.y+yss;

    xs=clamp(xs,0.02f,0.999f); ys=clamp(ys,0.02f,0.999f);
    //if (xs>0.999f||xs<0.0f||ys<0.0f||ys>0.999f) gl_FragColor = vec4(0.0f); else
	vec4 pixel = texture2D(colorMap, vec2(xs,ys)) * (texture2D(shadowMap, vec2(xs,ys))*2.0f) + xss;//*2.0f + yss*2.0f;
	float xc=(clamp(pixel.r,0.0f,1.0f)+clamp(pixel.g,0.0f,1.0f)+clamp(pixel.b,0.0f,1.0f))/3.0f;
    //gl_FragColor = texture2D(colorAbber,vec2(clamp(xc,0.0f,0.9f),0.1f));
	//gl_FragColor = pixel;
	gl_FragColor = texture2D(colorAbber,vec2(clamp(xc,0.0f,0.9f),texCoord.y));
	//gl_FragColor = vec4(clamp(pixel.r,0.0f,1.0f),clamp(pixel.g,0.0f,1.0f),clamp(pixel.b,0.0f,1.0f),1.0f);
}
