#version 120
uniform sampler2D colorMap;
uniform sampler2D palette;
uniform int centerx;
uniform int centery;
//uniform float verticalpalettepos;
varying vec2 texCoord;

float brightness(vec4 pixel){
return pixel.r+pixel.g+pixel.b;
}

void main (void)
{
/*
    float x=texture2D(colorMap, texCoord).b;//+noise1(texCoord.x);
    x=clamp(x,0.01f,0.99f);
    gl_FragColor = texture2D(palette, vec2(x,verticalpalettepos));
*/
//gl_FragColor = texture2D(colorMap, texCoord);
float x=texCoord.x;
float y=texCoord.y;
float cx=centerx/1920.0f;
float cy=centery/1080.0f;

vec4 currpix=vec4(0.0f);
const int steps=200;
    for (int i=0;i<steps;i++){
        float x1r=x+((cx-x)/float(steps)/1.3f)*float(i);
        float y1r=y+((cy-y)/float(steps)/1.3f)*float(i);
        float x1g=x+((cx-x)/float(steps)/1.2f)*float(i);
        float y1g=y+((cy-y)/float(steps)/1.2f)*float(i);
        float x1b=x+((cx-x)/float(steps)/1.0f)*float(i);
        float y1b=y+((cy-y)/float(steps)/1.0f)*float(i);
        currpix+=vec4(
            texture2D(colorMap, vec2(x1r,y1r)).r,
            texture2D(colorMap, vec2(x1g,y1g)).g,
            texture2D(colorMap, vec2(x1b,y1b)).b,
        1.0f);
    }
    currpix=currpix/steps*1.4f;
    //currpix.r=pow(currpix.r,0.9f); currpix.g=pow(currpix.g,0.9f); currpix.b=pow(currpix.b,0.9f);
    vec4 oldpix= texture2D(colorMap, texCoord);
    if (brightness(currpix)>brightness(oldpix))
        gl_FragColor = currpix;
    else
        gl_FragColor = oldpix;
}
