#version 130
//#version 120
//#pragma optionNV unroll all
#define MAX_LIGHTS 14
#define MAX_BONES 64

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;
in vec4 vertexBones;
in vec4 vertexWeights;

uniform mat4 depthBiasMVP[1];
varying vec4 ShadowCoord;

uniform vec4 Light;
varying float ShadowAngle;

varying float ycoo;

uniform int hasAnim[1];
uniform mat4 bonePos[MAX_BONES];
uniform mat4 boneRPos[MAX_BONES];
uniform mat4 boneRot[MAX_BONES];
uniform mat4 boneScl[MAX_BONES];

varying vec3 alightVec[MAX_LIGHTS];
varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];

uniform vec4 glColor;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



//varying vec3 vNormal;
//uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
//attribute vec3 vTangent;
vec3 tmpVec;

void main(void)
{
vec3 vertexT=vertexTangent;
float vertexTangentH=vertexTangentHandedness;
vertexT=vec3(0.0f,0.0f,1.0f);
vertexTangentH=1.0f;

    vec4 vP;
    vec4 vN;
    vec4 vT;
    vec4 vPa[4];
    vec4 vNa[4];
    vec4 vTa[4];
    //gl_Position = ftransform();
    //gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
    //texCoord = gl_MultiTexCoord0.xy;
    vP=vec4(vertexPosition.xyz, 1.0);
    vN=vec4(vertexNormal.xyz, 1.0);
    vT=vec4(vertexT.xyz, 1.0);//vT=vec4(vertexTangent.xyz, 1.0);
    //vertexBones.x+=1;vertexBones.y+=1;vertexBones.z+=1;vertexBones.w+=1;





    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0f); //there's a risk w wouldn't always be 1, so just to be sure

    ShadowCoord = depthBiasMVP[0] * vec4(vP.xyz, 1.0f);

    texCoord = textureCoord;

    //vec3 n = normalize(gl_NormalMatrix * gl_Normal);
    vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
    vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
    //vec4 n4 = normalize(gl_ModelViewProjectionMatrix * vec4(vN.x,vN.y,vN.z,1.0));
    //vec4 t4 = normalize(gl_ModelViewProjectionMatrix * vec4(vT.x,vT.y,vT.z,1.0));
    //vec3 n=vec3(n4.x,n4.y,n4.z);
    //vec3 t=vec3(t4.x,t4.y,t4.z);

//bitangent = cross(normal, tangent.xyz)*tangent.w; // from http://www.gamedev.net/topic/320413-calculating-tangent-vectors-for-normal-bump-mappinghelp-again/

    //vec3 b = cross(n, t) * vertexTangentHandedness;
    vec3 b = cross(n, t) * vertexTangentH;

    //b = b * vertexTangentHandedness;
    //vec3 b = cross(n, t);// * vertexTangentHandedness;
    //vec3 b = cross(t, n);

    //vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vertexPosition.xyz, 1.0));
    vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vP.xyz, 1.0));

    ////ShadowAngle = acos(dot(ShadowCoord.xyz,n)); //dot needs vec4?
    //ShadowAngle = acos(dot(vec4(1.0f),depthBiasMVP[0] * vec4(n, 1.0f)));
    //ShadowAngle = acos(dot(Light,vec4(n, 1.0f)))/3.141592f;

    //vec4 Light2=gl_ModelViewMatrix * vec4(Light.xyz,1.0f);
    ShadowAngle = dot(normalize(vec3(Light.xyz)),n);

    //if (ShadowAngle>0.99f) ShadowAngle=0.99f;
    //if (ShadowAngle<0.01f) ShadowAngle=0.01f;

    for (int i=0; i<MAX_LIGHTS; i++)
    {
        if (lightsEnabled[i]>0.0)
        {
            //tmpVec = gl_LightSource[i].position.xyz - vVertex;
            tmpVec = vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - vVertex;

            alightVec[i].x = dot(tmpVec, t);
            alightVec[i].y = dot(tmpVec, b);
            alightVec[i].z = dot(tmpVec, n);

            tmpVec = -vVertex;
            aeyeVec[i].x = dot(tmpVec, t);
            aeyeVec[i].y = dot(tmpVec, b);
            aeyeVec[i].z = dot(tmpVec, n);
        }
    }

    ycoo=vVertex.y;
    //vNormal = vertexTangent;
    //vNormal = vertexNormal;
}
