varying vec2 texCoord;
uniform sampler2D colorMap;

#define  offset_x  1. / 1920.0
#define  offset_y  1. / 1080.0

vec4 gaussianBlur(sampler2D tex, vec2 uv){
 vec2 offsets[9] = vec2[](
        vec2(-offset_x,  offset_y), // top-left
        vec2( 0.0,    offset_y), // top-center
        vec2( offset_x,  offset_y), // top-right
        vec2(-offset_x,  0.0),   // center-left
        vec2( 0.0,    0.0),   // center-center
        vec2( offset_x,  0.0),   // center-right
        vec2(-offset_x, -offset_y), // bottom-left
        vec2( 0.0,   -offset_y), // bottom-center
        vec2( offset_x, -offset_y)  // bottom-right    
    );

	float kernel[9] = float[](
		1.0 / 16, 2.0 / 16, 1.0 / 16,
		2.0 / 16, 4.0 / 16, 2.0 / 16,
		1.0 / 16, 2.0 / 16, 1.0 / 16  
	);
    
    vec4 sampleTex[9];

    for(int i = 0; i < 9; i++)
    {	
		vec4 pixel = texture(tex, uv.st + offsets[i]);
        sampleTex[i] = pixel;
    }
    vec4 col = vec4(0.0);
    for(int i = 0; i < 9; i++)
        col += sampleTex[i] * kernel[i];
    
    return col;
}

void main(){
	gl_FragColor = gaussianBlur(colorMap, texCoord); 
}