const float slowdown=0.5*2.5*0.5;

uniform float testvalue;
uniform float iTime;
uniform sampler2D iChannel0; //noise
uniform sampler2D logo; //logo text
uniform sampler2D palette; //color texture
uniform sampler2D palette2; //colourful texture

vec2 iResolution=vec2(1920.0/4.0,1080.0/4.0);


//
// Description : Array and textureless GLSL 2D/3D/4D simplex 
//               noise functions.
//      Author : Ian McEwan, Ashima Arts.
//  Maintainer : stegu
//     Lastmod : 20110822 (ijm)
//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
//               Distributed under the MIT License. See LICENSE file.
//               https://github.com/ashima/webgl-noise
//               https://github.com/stegu/webgl-noise
// 


vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0; }

float mod289(float x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0; }

vec4 permute(vec4 x) {
     return mod289(((x*34.0)+10.0)*x);
}

float permute(float x) {
     return mod289(((x*34.0)+10.0)*x);
}

vec4 taylorInvSqrt(vec4 r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

float taylorInvSqrt(float r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec4 grad4(float j, vec4 ip)
  {
  const vec4 ones = vec4(1.0, 1.0, 1.0, -1.0);
  vec4 p,s;

  p.xyz = floor( fract (vec3(j) * ip.xyz) * 7.0) * ip.z - 1.0;
  p.w = 1.5 - dot(abs(p.xyz), ones.xyz);
  s = vec4(lessThan(p, vec4(0.0)));
  p.xyz = p.xyz + (s.xyz*2.0 - 1.0) * s.www; 

  return p;
  }
						
// (sqrt(5) - 1)/4 = F4, used once below
#define F4 0.309016994374947451

float snoise(vec4 v)
  {
  const vec4  C = vec4( 0.138196601125011,  // (5 - sqrt(5))/20  G4
                        0.276393202250021,  // 2 * G4
                        0.414589803375032,  // 3 * G4
                       -0.447213595499958); // -1 + 4 * G4

// First corner
  vec4 i  = floor(v + dot(v, vec4(F4)) );
  vec4 x0 = v -   i + dot(i, C.xxxx);

// Other corners

// Rank sorting originally contributed by Bill Licea-Kane, AMD (formerly ATI)
  vec4 i0;
  vec3 isX = step( x0.yzw, x0.xxx );
  vec3 isYZ = step( x0.zww, x0.yyz );
//  i0.x = dot( isX, vec3( 1.0 ) );
  i0.x = isX.x + isX.y + isX.z;
  i0.yzw = 1.0 - isX;
//  i0.y += dot( isYZ.xy, vec2( 1.0 ) );
  i0.y += isYZ.x + isYZ.y;
  i0.zw += 1.0 - isYZ.xy;
  i0.z += isYZ.z;
  i0.w += 1.0 - isYZ.z;

  // i0 now contains the unique values 0,1,2,3 in each channel
  vec4 i3 = clamp( i0, 0.0, 1.0 );
  vec4 i2 = clamp( i0-1.0, 0.0, 1.0 );
  vec4 i1 = clamp( i0-2.0, 0.0, 1.0 );

  //  x0 = x0 - 0.0 + 0.0 * C.xxxx
  //  x1 = x0 - i1  + 1.0 * C.xxxx
  //  x2 = x0 - i2  + 2.0 * C.xxxx
  //  x3 = x0 - i3  + 3.0 * C.xxxx
  //  x4 = x0 - 1.0 + 4.0 * C.xxxx
  vec4 x1 = x0 - i1 + C.xxxx;
  vec4 x2 = x0 - i2 + C.yyyy;
  vec4 x3 = x0 - i3 + C.zzzz;
  vec4 x4 = x0 + C.wwww;

// Permutations
  i = mod289(i); 
  float j0 = permute( permute( permute( permute(i.w) + i.z) + i.y) + i.x);
  vec4 j1 = permute( permute( permute( permute (
             i.w + vec4(i1.w, i2.w, i3.w, 1.0 ))
           + i.z + vec4(i1.z, i2.z, i3.z, 1.0 ))
           + i.y + vec4(i1.y, i2.y, i3.y, 1.0 ))
           + i.x + vec4(i1.x, i2.x, i3.x, 1.0 ));

// Gradients: 7x7x6 points over a cube, mapped onto a 4-cross polytope
// 7*7*6 = 294, which is close to the ring size 17*17 = 289.
  vec4 ip = vec4(1.0/294.0, 1.0/49.0, 1.0/7.0, 0.0) ;

  vec4 p0 = grad4(j0,   ip);
  vec4 p1 = grad4(j1.x, ip);
  vec4 p2 = grad4(j1.y, ip);
  vec4 p3 = grad4(j1.z, ip);
  vec4 p4 = grad4(j1.w, ip);

// Normalise gradients
  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;
  p4 *= taylorInvSqrt(dot(p4,p4));

// Mix contributions from the five corners
  vec3 m0 = max(0.6 - vec3(dot(x0,x0), dot(x1,x1), dot(x2,x2)), 0.0);
  vec2 m1 = max(0.6 - vec2(dot(x3,x3), dot(x4,x4)            ), 0.0);
  m0 = m0 * m0;
  m1 = m1 * m1;
  return 49.0 * ( dot(m0*m0, vec3( dot( p0, x0 ), dot( p1, x1 ), dot( p2, x2 )))
               + dot(m1*m1, vec2( dot( p3, x3 ), dot( p4, x4 ) ) ) ) ;

  }

//clouds 21 3d 0.4 lighting 0.96

bool animate=false;
#define AA 0

/*
//Revised 2018 version.
vec2 Hash(vec2 P)
{
vec2 val1=texture(iChannel0,P/1000.0+iTime/100.0).xy;
vec2 val2=texture(iChannel0,P/1000.0).xy;
vec2 val=vec2(val1.x,val2.x);
val-=0.5;
val/=0.4;
return val;
 	return fract(cos(P*mat2(-64.2,71.3,81.4,-29.8))*8321.3); 
}
float Worley(vec2 P)
{
    float Dist = 3.0;
    vec2 I = floor(P);
    vec2 F = fract(P);
    
    for(int X = -1;X<=1;X++)
    for(int Y = -1;Y<=1;Y++)
    {
        float D = distance(Hash(I+vec2(X,Y))+vec2(X,Y),F);
        Dist = min(Dist,D);
    }
    return Dist;
	
}
void mainImage( out vec4 Color, in vec2 Coord)
{
float val=Worley(Coord.xy/32.0+iTime);
val=pow(val,1.2);
	Color = vec4(vec3(1.0)-vec3(val),1.0);
}
*/

//Original 2015 version.

vec2 Hash(vec2 P)
{
vec2 val1=texture(iChannel0,P/1000.0+iTime/500.0).xy;
vec2 val2=texture(iChannel0,P/1000.0).xy;
vec2 val=vec2(val1.x,val2.x);
val-=0.5;
val/=1.1;
return val;
 	return fract(cos(P*mat2(-64.2,71.3,81.4,-29.8))*8321.3); 
}


float Hash3d(vec3 uv)
{

    if (uv.x<0.0) uv.x=1.0+uv.x;
    if (uv.y<0.0) uv.y=1.0+uv.y;
    if (uv.z<0.0) uv.z=1.0+uv.z;
    if (uv.x>1.0) uv.x=uv.x-1.0;
    if (uv.y>1.0) uv.y=uv.y-1.0;
    if (uv.z>1.0) uv.z=uv.z-1.0;
    
    //uv=clamp(uv,0.0,1.0);

    float f = uv.x + uv.y * 37.0 + uv.z * 521.0;
    //return fract(sin(f)*110003.9);
    return fract(cos(f)*110003.9);
}

const vec2 zeroOne = vec2(0.0, 1.0);
float mixP(float f0, float f1, float a)
{
    return mix(f0, f1, a);
    return mix(f0, f1, a*a*(3.0-2.0*a));
}
float noiseValue(vec3 uv)
{
    vec3 fr = fract(uv.xyz);
    vec3 fl = floor(uv.xyz);
    float h000 = Hash3d(fl);
    float h100 = Hash3d(fl + zeroOne.yxx);
    float h010 = Hash3d(fl + zeroOne.xyx);
    float h110 = Hash3d(fl + zeroOne.yyx);
    float h001 = Hash3d(fl + zeroOne.xxy);
    float h101 = Hash3d(fl + zeroOne.yxy);
    float h011 = Hash3d(fl + zeroOne.xyy);
    float h111 = Hash3d(fl + zeroOne.yyy);
    return mixP(
        mixP(mixP(h000, h100, fr.x),
             mixP(h010, h110, fr.x), fr.y),
        mixP(mixP(h001, h101, fr.x),
             mixP(h011, h111, fr.x), fr.y)
        , fr.z);
}

float r(float n)
{
 	return fract(cos(n*89.42)*343.42);
}

vec2 r(vec2 n)
{
 	vec2 result=vec2(r(n.x*23.62-300.0+n.y*34.35),r(n.x*45.13+256.0+n.y*38.89)); 
    ///return result;
    return vec2(noiseValue(vec3(n,iTime/4.0)));//+result;
}

float fade(vec2 n){
    return fract(noiseValue(vec3(n,0.0)));
}

float worley(vec2 n,float s) 
{
    float dis = 1.0;
    for(int x = -1;x<=1;x++)
    {
        for(int y = -1;y<=1;y++)
        {
            vec2 p = floor(n/s)+vec2(x,y);
            float d = length(r(p)+vec2(x,y)-fract(n/s));
            if (dis>d)
            {
             	dis = d;
            }
        }
    }
    return dis;
	
}


vec3 gammaCorrect(vec3 color, float gamma){
    return pow(color, vec3(1.0/gamma));
}

vec3 levelRange(vec3 color, float minInput, float maxInput){
    return min(max(color - vec3(minInput), vec3(0.0)) / (vec3(maxInput) - vec3(minInput)), vec3(1.0));
}

float flevelRange(float color, float minInput, float maxInput){
    return min(max(color - minInput, 0.0) / (maxInput - minInput), 1.0);
}

vec3 finalLevels(vec3 color, float minInput, float gamma, float maxInput){
    return gammaCorrect(levelRange(color, minInput, maxInput), gamma);
}

//use like: vec3 col = finalLevels(someTex.rgb, 34.0/255.0, 1.5, 235.0/255.0);

// The MIT License
// Copyright  2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


// Simplex Noise (http://en.wikipedia.org/wiki/Simplex_noise), a type of gradient noise
// that uses N+1 vertices for random gradient interpolation instead of 2^N as in regular
// latice based Gradient Noise.


// Value    Noise 2D, Derivatives: https://www.shadertoy.com/view/4dXBRH
// Gradient Noise 2D, Derivatives: https://www.shadertoy.com/view/XdXBRH
// Value    Noise 3D, Derivatives: https://www.shadertoy.com/view/XsXfRH
// Gradient Noise 3D, Derivatives: https://www.shadertoy.com/view/4dffRH
// Value    Noise 2D             : https://www.shadertoy.com/view/lsf3WH
// Value    Noise 3D             : https://www.shadertoy.com/view/4sfGzS
// Gradient Noise 2D             : https://www.shadertoy.com/view/XdXGW8
// Gradient Noise 3D             : https://www.shadertoy.com/view/Xsl3Dl
// Simplex  Noise 2D             : https://www.shadertoy.com/view/Msf3WH
// Wave     Noise 2D             : https://www.shadertoy.com/view/tldSRj


vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2  i = floor( p + (p.x+p.y)*K1 );
    vec2  a = p - i + (i.x+i.y)*K2;
    float m = step(a.y,a.x); 
    vec2  o = vec2(m,1.0-m);
    vec2  b = a - o + K2;
	vec2  c = a - 1.0 + 2.0*K2;
    vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );
	vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));
    return dot( n, vec3(70.0) );
}

// -----------------------------------------------

vec3 noise_(in vec2 fragCoord )
{
    vec2 p = fragCoord.xy / iResolution.xy;

	vec2 uv = p*vec2(iResolution.x/iResolution.y,1.0) + iTime*0.25;
	
	float f = 0.0;
	
    // left: value noise	
	if( p.x<0.6 )
	{
		f = noise( 16.0*uv );
	}
    // right: fractal noise (4 octaves)
    else	
	{
		uv *= 5.0;
        mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
		f  = 0.5000*noise( uv ); uv = m*uv;
		f += 0.2500*noise( uv ); uv = m*uv;
		f += 0.1250*noise( uv ); uv = m*uv;
		f += 0.0625*noise( uv ); uv = m*uv;
	}

	f = 0.5 + 0.5*f;
	
    f *= smoothstep( 0.0, 0.005, abs(p.x-0.6) );	
	
	return vec3( f );
}

/* https://www.shadertoy.com/view/XsX3zB
 *
 * The MIT License
 * Copyright  2013 Nikita Miropolskiy
 * 
 * ( license has been changed from CCA-NC-SA 3.0 to MIT
 *
 *   but thanks for attributing your source code when deriving from this sample 
 *   with a following link: https://www.shadertoy.com/view/XsX3zB )
 *
 * ~
 * ~ if you're looking for procedural noise implementation examples you might 
 * ~ also want to look at the following shaders:
 * ~ 
 * ~ Noise Lab shader by candycat: https://www.shadertoy.com/view/4sc3z2
 * ~
 * ~ Noise shaders by iq:
 * ~     Value    Noise 2D, Derivatives: https://www.shadertoy.com/view/4dXBRH
 * ~     Gradient Noise 2D, Derivatives: https://www.shadertoy.com/view/XdXBRH
 * ~     Value    Noise 3D, Derivatives: https://www.shadertoy.com/view/XsXfRH
 * ~     Gradient Noise 3D, Derivatives: https://www.shadertoy.com/view/4dffRH
 * ~     Value    Noise 2D             : https://www.shadertoy.com/view/lsf3WH
 * ~     Value    Noise 3D             : https://www.shadertoy.com/view/4sfGzS
 * ~     Gradient Noise 2D             : https://www.shadertoy.com/view/XdXGW8
 * ~     Gradient Noise 3D             : https://www.shadertoy.com/view/Xsl3Dl
 * ~     Simplex  Noise 2D             : https://www.shadertoy.com/view/Msf3WH
 * ~     Voronoise: https://www.shadertoy.com/view/Xd23Dh
 * ~ 
 *
 */

/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
     p.x-=-0.125;

	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/
	 
	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));
	 
	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);
	 	
	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;
	 
	 /* 2. find four surflets and store them in d */
	 vec4 w, d;
	 
	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);
	 
	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);
	 
	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);
	 
	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;
	 
	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

/* directional artifacts can be reduced by rotating each octave */
float simplex3d_fractal(vec3 m) {
    return   0.5333333*simplex3d(m*rot1)
			+0.2666667*simplex3d(2.0*m*rot2)
			+0.1333333*simplex3d(4.0*m*rot3)
			+0.0666667*simplex3d(8.0*m);
}

void mainImage_simplex3d( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = fragCoord.xy/iResolution.x;
	vec3 p3 = vec3(p, iTime*0.025);
	
	float value;
	
	if (p.x <= 0.6) {
		value = simplex3d(p3*32.0);
	} else {
		value = simplex3d_fractal(p3*8.0+8.0);
	}
	
	value = 0.5 + 0.5*value;
	value *= smoothstep(0.0, 0.005, abs(0.6-p.x)); // hello, iq :)
	
	fragColor = vec4(
			vec3(value),
			1.0);
	return;
}

float fbm(vec3 x){
    //return 0.5+0.5*simplex3d_fractal(x/32.0*8.0+8.0);
    float res= 0.5+0.5*simplex3d(x/2.0*0.3+vec3(15.0));
    //float res= 0.5+0.5*snoise(vec4(x,0.0));
    ///float res= 0.5+0.5*noise_(vec4(x,0.0));
    return res;
}

float worley3d(vec3 n,float s) 
{
    return simplex3d(n);
}

vec3 v3(float x){return vec3(x,x,0);}

vec4 map_cloud2(vec3 pos){
    float time=iTime*slowdown;
    //float time2=0.0;//-iTime*10.0;
    //time=mod(time,100.0);
    //time/=200.0;
    //time=0.0;
    const float scale=0.025;
    float ylimit=8.0*scale*6.0; //8.0
    float ylimit2=-8.0*scale*6.0;
    const float border=3.0*scale; ///0.7
    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);
    
    vec3 uv=pos.xyz*40.0/2.0+vec3(0,0,-time*8.0);
    
    
		float f,a;
        //mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
        float m=3.5;
        vec3 anim=vec3(0.0,0.0,time*2.2*slowdown); if (!animate) anim=vec3(0.0);
        float shape=fbm( uv/8.0 );
        if (shape<0.0)
            return vec4(0.0);
        else {
            f  = 0.5000*fbm( uv ); uv = m*uv;
            f += 0.2500*fbm( uv ); uv = m*uv;
            f += 0.1250*fbm( uv ); //uv = m*uv;
            //f += 0.0625*fbm( uv +anim);
            //f *= fbm( uv/200.0 );
            a=f*shape;
        }
    
    /*
    float w1 = fbm(uv+vec3(0,time2,time));
    float w2 = fbm(uv*2.0+vec3(0,time2,time)*2.0);
    float w3 = fbm(uv*4.0+vec3(0,time2,time)*4.0)/2.0;
    a=(w1+w2+w3)/2.0/1.2;
    */
    
    if (pos.y>ylimit) a*=1.0-smoothstep(ylimit,ylimit+border,pos.y);//((pos.y/ylimit))/0.7;
    if (pos.y<ylimit2) a*=1.0-smoothstep(ylimit2,ylimit2-border,pos.y);//(1.0-(pos.y/ylimit2))/0.7;
    //a=smoothstep(0.4,0.6,a);
    //a=finalLevels(vec3(a),130.0/255.0,1.5,190.0/255.0).x;
    a=flevelRange(a,0.2,0.75);
    return vec4(a);
    return vec4(1.0,1.0,1.0,a);
}

vec3 map_cloudcolor(vec3 pos){
    float time=iTime*slowdown;
    const float scale=0.025;
    float ylimit=8.0*scale*6.0; //8.0
    float ylimit2=-8.0*scale*6.0;
    const float border=3.0*scale; ///0.7
    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);
    
    float cscale=4.0*5.0;
    vec3 uvc=((pos.xyz)*40.0/2.0)*cscale;

    vec3 uv=pos.xyz*40.0/2.0+vec3(0,0,-time*8.0);
    
    
		float f,a;
        //mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
        float m=3.5;
        vec3 anim=vec3(0.0,0.0,time*2.2*slowdown); if (!animate) anim=vec3(0.0);
        /*
        float shape=fbm( uv/8.0 );
        if (shape<0.0)
            return vec4(0.0);
        else {
            f  = 0.5000*fbm( uv ); uv = m*uv;
            f += 0.2500*fbm( uv ); uv = m*uv;
            f += 0.1250*fbm( uv ); //uv = m*uv;
            //f += 0.0625*fbm( uv +anim);
            //f *= fbm( uv/200.0 );
            a=f*shape;
        }
        */
        m=1.0/2.0;
        float r=0.5*fbm(uvc/8.0+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(0,0,-time*8.0));
        float g=0.5*fbm(uvc/8.0+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0));
        float b=0.5*fbm(uvc/8.0+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0));
        vec3 color=vec3(r,g,b);
        float boost=93.0; //testvalue
        float boostlow = 16.0f+boost; ///increase to darken image
        float boosthigh = 219.0f-boost; /// decrease to brighten image
        //float boost=testvalue;
        #define const_1 (boostlow / 255.0)
        #define const_2 (255.0 / boosthigh)
        color= ((color - const_1) * const_2);
        float brighten=2.5;//testvalue;
        color*=brighten;
    /*
    float w1 = fbm(uv+vec3(0,time2,time));
    float w2 = fbm(uv*2.0+vec3(0,time2,time)*2.0);
    float w3 = fbm(uv*4.0+vec3(0,time2,time)*4.0)/2.0;
    a=(w1+w2+w3)/2.0/1.2;
    */
    /*
    if (pos.y>ylimit) a*=1.0-smoothstep(ylimit,ylimit+border,pos.y);//((pos.y/ylimit))/0.7;
    if (pos.y<ylimit2) a*=1.0-smoothstep(ylimit2,ylimit2-border,pos.y);//(1.0-(pos.y/ylimit2))/0.7;
    //a=smoothstep(0.4,0.6,a);
    //a=finalLevels(vec3(a),130.0/255.0,1.5,190.0/255.0).x;
    a=flevelRange(a,0.2,0.75);
    return vec4(a);
    return vec4(1.0,1.0,1.0,a);
    */
    return color;
}

vec3 map_cloudcolor2(vec3 pos){
    float time=iTime*slowdown;
    const float scale=0.025;
    float ylimit=8.0*scale*6.0; //8.0
    float ylimit2=-8.0*scale*6.0;
    const float border=3.0*scale; ///0.7
    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);
    
    float cscale=4.0*5.0/3.0;
    vec3 uvc=((pos.xyz)*40.0/2.0)*cscale;

    vec3 uv=pos.xyz*40.0/2.0+vec3(0,0,-time*8.0);
    
    
		float f,a;
        //mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
        float m=3.5;
        vec3 anim=vec3(0.0,0.0,time*2.2*slowdown); if (!animate) anim=vec3(0.0);
        /*
        float shape=fbm( uv/8.0 );
        if (shape<0.0)
            return vec4(0.0);
        else {
            f  = 0.5000*fbm( uv ); uv = m*uv;
            f += 0.2500*fbm( uv ); uv = m*uv;
            f += 0.1250*fbm( uv ); //uv = m*uv;
            //f += 0.0625*fbm( uv +anim);
            //f *= fbm( uv/200.0 );
            a=f*shape;
        }
        */
        m=1.0/2.0;
        float r=0.5*fbm(uvc/8.0+vec3(0,0,-time*8.0));//+0.25*fbm(uvc*m+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(0,0,-time*8.0));
        float g=0.5*fbm(uvc/8.0+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0));//+0.25*fbm(uvc*m+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(1000.0,1000.0,1000.0)+vec3(0,0,-time*8.0));
        float b=0.5*fbm(uvc/8.0+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0));//+0.25*fbm(uvc*m+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0))+0.25*fbm(uvc*m*m+vec3(10000.0,10000.0,1000.0)+vec3(0,0,-time*8.0));
        vec3 color=vec3(r,g,b);
        float boost=93.0; //testvalue
        float boostlow = 16.0f+boost; ///increase to darken image
        float boosthigh = 219.0f-boost; /// decrease to brighten image
        //float boost=testvalue;
        #define const_1 (boostlow / 255.0)
        #define const_2 (255.0 / boosthigh)
        color= ((color - const_1) * const_2);
        float brighten=2.5;//testvalue;
        color*=brighten;
    /*
    float w1 = fbm(uv+vec3(0,time2,time));
    float w2 = fbm(uv*2.0+vec3(0,time2,time)*2.0);
    float w3 = fbm(uv*4.0+vec3(0,time2,time)*4.0)/2.0;
    a=(w1+w2+w3)/2.0/1.2;
    */
    /*
    if (pos.y>ylimit) a*=1.0-smoothstep(ylimit,ylimit+border,pos.y);//((pos.y/ylimit))/0.7;
    if (pos.y<ylimit2) a*=1.0-smoothstep(ylimit2,ylimit2-border,pos.y);//(1.0-(pos.y/ylimit2))/0.7;
    //a=smoothstep(0.4,0.6,a);
    //a=finalLevels(vec3(a),130.0/255.0,1.5,190.0/255.0).x;
    a=flevelRange(a,0.2,0.75);
    return vec4(a);
    return vec4(1.0,1.0,1.0,a);
    */
    return color;
}

vec4 map_cloud(vec3 pos){
    float time=iTime*2.3;
    float time2=iTime*2.1;
    time=mod(time,100.0);
    time2=mod(time,100.0);
    time/=200.0;
    time2/=200.0;
    //time=0.0; time2=100.0;
    
    vec3 uv=pos*48.0;//32.0
    
    vec3 uv2=uv*2.25;
    vec3 uv3=uv*10.0;
    //float dis = worley(uv+iTime*32.0,32.0);
    //float dis = (worley(uv+iTime*32.0,332.0));
    float w1 = (worley3d(uv+time*v3(102.0),332.0));
    vec3 w1_=finalLevels(vec3(w1),32.0/255.0,1.5,240.0/255.0);
    //vec3 dis3=vec3(dis);
    float w2 = (worley3d(uv+time*v3(112.0),232.0));
    vec3 w2_=finalLevels(vec3(w2),32.0/255.0,1.5,240.0/255.0);
    
    ///float p1 = noise_(vec2(uv*2.0+iTime*3.0)).x;
    ///float p1 = noiseValue(vec3(uv/6.0+iTime*3.0,iTime));
    float p1 = fbm(vec3(time2/2.0,uv3/600.0+time*v3(1.0/1.5)));
    vec3 p1_=vec3(p1);
    p1_=finalLevels(p1_,64.0/255.0,1.5,190.0/255.0);
    float p2 = fbm(vec3(time2/2.0,uv3/2000.0+time*v3(1.0/1.5)));
    vec3 p2_=vec3(p2);

    //vec3 result=p2_;
    
    //tiniest detail:
    
    float p3 = fbm(vec3(time2/2.0,uv3/200.0+time*v3(1.0/1.5)));
    vec3 p3_=vec3(p3);
    float w3 = (1.0-(worley3d(uv+time*v3(32.0),134.0)))/1.2;
    vec3 w3_=finalLevels(vec3(w3),62.0/255.0,0.5,230.0/255.0);
    
    float m = 1.0-fbm(vec3(time2/5.5,uv2/300.0+time/10.0));
    vec3 m_=finalLevels(vec3(m),130.0/255.0,1.5,190.0/255.0);

    vec3 fin=w1_*w2_/2.0;
	vec3 result = (((vec3(1.0)-fin)*p1_+p2_/2.0+w3_)*p3_*m_+(1.0-w1_)/16.0);
    result=finalLevels(result,40.0/255.0,1.5,255.0/255.0);
    
	///fragColor = vec4(m_,1.0);

    //vec4 col_res = vec4(vec3(1.0),result.x);
    vec4 col_res = vec4(result.xyz,result.x);
    
    return col_res;
}

const float normaleps=0.005;
vec3 calcNormal( in vec3 pos )
{
    vec3 eps = vec3( normaleps, 0.0, 0.0 );

    vec3 nor = vec3(
        fbm(pos+eps.xyy) - fbm(pos-eps.xyy),
        fbm(pos+eps.yxy) - fbm(pos-eps.yxy),
        fbm(pos+eps.yyx) - fbm(pos-eps.yyx) );
    return normalize(nor);

}

vec3 render( in vec3 ro, in vec3 rd, in vec2 fragCoord){
vec4 col=vec4(0.0);
vec4 col2=vec4(0.0);
    //--------------------------------------
    // raymarch
    //--------------------------------------
    vec4 sum = vec4( 0.0 );
    // dithering
    //float t = 0.01*(texture(iChannel0, fragCoord.xy/512.0).r);
    float t=0.002;
    
    vec3 pos;
    float lighting;
    for( int i=0; i<200; i++ )
    {
    float mapscale=5.1;
        if(sum.a > 0.95) break;
        pos = ro + t*rd;
        col = map_cloud2(pos.xyz * mapscale)/1.2;

/*
        vec2 coos=vec2(fragCoord.x/1920.0,fragCoord.y/1080.0);
        coos=clamp(coos,0.0,1.0);
        col*=vec4(texture(logo,coos).r);
        */
//-------------------------------------------------------------------
// logo stuff
//-------------------------------------------------------------------
        float znear=(0.5+2.6-4.7-0.3)*0.935; //-1.9
        float zfar=1.5+2.6-0.3-5.6; //3.8-5.6
        float zborder=0.05;
        float f=1.0;

        vec2 coos=vec2(pos.x,pos.y)*4.6;
        coos.x*=-1.0;
        
        if (pos.z>zfar) f*=1.0-smoothstep(zfar,zfar+zborder,pos.z);
        if (pos.z<znear) f*=1.0-smoothstep(znear,znear-zborder,pos.z);

        f*=(pos.z-znear)/(zfar-znear);

        col.a=pow(col.a,0.5)*f;
        vec4 l3logo=vec4(texture(logo,clamp(coos,-0.5,0.5)+vec2(0.5,0.5)).r*f);
        col*=l3logo;
        //if (abs(pos.z-zfar)<0.02*0.3&&col.a>0.1) col+=l3logo/2.5*2.1;
        //if (col.a>0.1) col+=l3logo/3.0*0.5;
//-------------------------------------------------------------------
        
float currz=iTime*slowdown;
vec3 lightning=vec3(-0.05*-6.7,-0.01,0.05+currz);
float flash=length(vec3(pos.x,pos.y,currz)-lightning);
if (flash<0.25) flash=(1.0-flash/0.25)*col.a*7.0
*(
(sin(iTime*1.5)+1.0)/8.0+
(sin(iTime*1.127)+1.0)/8.0+
(abs(sin(iTime*1.723))+1.0)/8.0+
(abs(sin(iTime*0.4))+1.0)/8.0
);
else flash=0.0;

//override:
flash=0.0;

        // lighting:
        //const vec3 sundir=normalize(vec3(-0.5,-0.5,0.0));
        const vec3 sundir = normalize(vec3(-10.0,10.0,-2.0));
        const float ldist=0.0575*2.5;
        const float dim=1.85;

        if (col.a<0.15) lighting=0.0; else
        lighting = clamp((col.a - map_cloud2(pos*mapscale+ldist*sundir).a)/0.3, -0.2, 1.0 )/100.0/dim;
        ///lighting+=flash;
        //lighting = clamp(0.01, -0.2, 1.0 )/30.0/dim;

col.a*=0.05*20.0;
        
        //col.a *= 0.5;
        //col.rgb = mix( vec3(0.0), col.rgb, exp(-0.002*t*t*t) )/40.0/dim;
        col.rgb = map_cloudcolor(pos);
        col2.rgb = map_cloudcolor2(pos);
col.rgb=texture2D(palette,vec2(col.r,col.g)).rgb;
col2.rgb=texture2D(palette2,vec2(col2.r,col2.g)).rgb;
col.rgb=mix(col,col2,0.77).rgb;
        col.rgb = col.rgb/40.0/dim; // *testvalue;
        col.rgb += vec3(0.1,0.1,0.1)*(lighting)*12.0*5.0;
        //col.rgb = col.rgb/testvalue;
        //col.rgb+=vec3(0.1,0.1,0.1)*(lighting)*12.0+vec3(flash)/35.0;
        //col.rgb+=vec3(1.0,1.0,1.0)*(lighting);
        //col.rgb+=vec3(0.0,0.0,1.0)*(lighting);
        sum = sum + col*(1.0 - sum.a);
        t += 0.002;
    }
    /*
    vec3 bg = mix(vec3(80.0/255.0,135.0/255.0,209.0/255.0)/0.85,
    vec3(100.0/255.0,150.0/255.0,200.0/255.0)*1.4,-pos.y*4.0)/1.4;
    */

    float x=(pos.y-0.5)/1.0;
//vec3 bg=texture(iChannel1,vec2(x,0.5)).rgb*0.7;
    vec2 dither = 0.01*(texture(iChannel0, fragCoord.xy/512.0).rg)/0.6;
    vec3 bg=texture2D(palette,vec2(x,x)+dither).rgb;
    
    //col=sum+vec4(bg,1.0)*(1.0-sum.a);
    col=sum*sum.a+vec4(bg,1.0)*(1.0-sum.a);
    //col=texture(iChannel1,vec2(1.0-sum.a,0.0))*sum.a+vec4(bg,1.0)*(1.0-sum.a);

    //col=sum+vec4(1.2,0.9,0.3,1.0)*lsum*sum.a;
    //vec3 col = clamp( mix( bg, sum.xyz/(0.001+sum.w), sum.w ), 0.0, 1.0 );
    //col=col*vec4(smoothstep(0.1,0.7,sum.x));
    return col.rgb;
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(cr), cos(cr),0.0);
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv =          ( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 pos;

    vec2 uv = fragCoord.xy/iResolution.xy;
	vec2 p = uv*2.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
    vec3 col = vec3(0.05);
    vec3 ro = vec3(0.0,0.0,-2.0+0.09);
    vec3 rd = normalize(vec3(p,0.0)-ro);

float fov=1.2;

            //ro=rayorigin;// /vec3(20.0);
            vec3 ta=vec3(0.0,0.0,1.0);//raydirection;// /vec3(20.0);
            mat3 ca = setCamera( ro, ta, 0.0 );
            rd = ca * normalize( vec3(p.x,p.y,fov ) );

     col = render( ro, rd, fragCoord);

    fragColor = vec4( col, 1.0 );
}

void main()
{
    vec4 color=vec4(0.0, 0.0, 0.0, 1.0);
    vec2 coos=gl_FragCoord.xy;
    mainImage(color,coos);
    gl_FragColor = color;
}
