//#version 120
#pragma optionNV unroll all
#define MAX_LIGHTS 1
#define MAX_BONES 78

uniform vec3 cameyevector;

varying vec3 alVec[MAX_LIGHTS];
varying vec3 avVec[MAX_LIGHTS];
varying vec3 aeyeVec[MAX_LIGHTS];
//varying vec2 texCoord;
//uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
attribute vec3 vTangent;

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;
in vec4 vertexBones;
in vec4 vertexWeights;

uniform int hasAnim[1];
uniform mat4 bonePos[MAX_BONES];
uniform mat4 boneRPos[MAX_BONES];
uniform mat4 boneRot[MAX_BONES];
uniform mat4 boneScl[MAX_BONES];

varying vec3 alightVec[MAX_LIGHTS];
//varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];

//varying vec3 vNormal;
//uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
//attribute vec3 vTangent;
vec3 tmpVec;

void main(void)
{
    vec3 lightVec;
    vec3 eyeVec;
    vec3 tmpVec;

    vec4 vP;
    vec4 vN;
    vec4 vT;
    vec4 vPa[4];
    vec4 vNa[4];
    vec4 vTa[4];
    //gl_Position = ftransform();
    //gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
    //texCoord = gl_MultiTexCoord0.xy;
    vP=vec4(vertexPosition.xyz, 1.0);
    vN=vec4(vertexNormal.xyz, 1.0);
    vT=vec4(vertexTangent.xyz, 1.0);

    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0); //there's a risk w wouldn't always be 1, so just to be sure

    texCoord = textureCoord;

    vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
    vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
    vec3 b = cross(n, t) * vertexTangentHandedness;
    vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vP.xyz, 1.0));

    for (int i=0; i<MAX_LIGHTS; i++)
    {
        if (lightsEnabled[i]>0.0)
        {
            tmpVec = gl_LightSource[i].position.xyz - vVertex;

            alightVec[i].x = dot(tmpVec, t);
            alightVec[i].y = dot(tmpVec, b);
            alightVec[i].z = dot(tmpVec, n);

            tmpVec = -vVertex;
            aeyeVec[i].x = dot(tmpVec, t);
            aeyeVec[i].y = dot(tmpVec, b);
            aeyeVec[i].z = dot(tmpVec, n);
        }
    }

//---------------------------------------------------------------------------------------------------------------------------------------
    eyeVec = pow(abs(dot(-normalize(n), normalize(cameyevector))),0.65f);
    //eyeVec = abs(dot(cameyevector,-n));
    //eyeVec = abs(dot(normalize(vec3(gl_ModelViewMatrix * vec4(vN.xyz, 1.0))), normalize(vec3(gl_ModelViewMatrix * vec4(cameyevector.xyz, 1.0)))));
    //eyeVec = abs(normalize(dot(normalize(vec4(vN.xyz,1.0f)), normalize(vec4(cameyevector.xyz,1.0f)) ) ) );
    //eyeVec = abs(dot(normalize(gl_ModelViewMatrix * vN), normalize(gl_ModelViewMatrix * cameyevector)));

    //eyeVec = vec3(1.0f-(dot(normalize(vertexNormal.xyz),normalize(cameyevector))) );
//    eyeVec = vec3(normalize(dot((vertexNormal.xyz),(cameyevector))) );
    //eyeVec = vec3(normalize(dot((vertexNormal.xyz),(gl_Position.xyz))) );

    //eyeVec = vec3( (dot(normalize(n),normalize(cameyevector))) );

    //eyeVec = vec3(1.0f);
    //eyeVec = dot(-normalize(n), vec3(0,0,-1)); //this 0,0,-1 should be replaced with camera eye vector
    aeyeVec[0] = eyeVec;
}
