/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderColumnInfo;
import sun.awt.shell.Win32ShellFolderManager2;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

final class Win32ShellFolder2
extends ShellFolder {
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    public static final int SHGDN_NORMAL = 0;
    public static final int SHGDN_INFOLDER = 1;
    public static final int SHGDN_INCLUDE_NONFILESYS = 8192;
    public static final int SHGDN_FORADDRESSBAR = 16384;
    public static final int SHGDN_FORPARSING = 32768;
    FolderDisposer disposer = new FolderDisposer();
    private long pIShellIcon = -1L;
    private String folderType = null;
    private String displayName = null;
    private Image smallIcon = null;
    private Image largeIcon = null;
    private Boolean isDir = null;
    private boolean isPersonal;
    private volatile Boolean cachedIsFileSystem;
    private volatile Boolean cachedIsLink;
    private static Map smallSystemImages;
    private static Map largeSystemImages;
    private static Map smallLinkedSystemImages;
    private static Map largeLinkedSystemImages;
    private static final int LVCFMT_LEFT = 0;
    private static final int LVCFMT_RIGHT = 1;
    private static final int LVCFMT_CENTER = 2;

    private static native void initIDs();

    private void setIShellFolder(long l) {
        this.disposer.pIShellFolder = l;
    }

    private void setRelativePIDL(long l) {
        this.disposer.relativePIDL = l;
    }

    private static String composePathForCsidl(int n) throws IOException, InterruptedException {
        String string = Win32ShellFolder2.getFileSystemPath(n);
        return string == null ? "ShellFolder: 0x" + Integer.toHexString(n) : string;
    }

    Win32ShellFolder2(final int n) throws IOException, InterruptedException {
        super((ShellFolder)null, Win32ShellFolder2.composePathForCsidl(n));
        Win32ShellFolder2.invoke(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException {
                if (n == 0) {
                    Win32ShellFolder2.this.initDesktop();
                } else {
                    long l;
                    Win32ShellFolder2.this.initSpecial(Win32ShellFolder2.this.getDesktop().getIShellFolder(), n);
                    long l2 = Win32ShellFolder2.this.disposer.relativePIDL;
                    Win32ShellFolder2.this.parent = Win32ShellFolder2.this.getDesktop();
                    while (l2 != 0L && (l = Win32ShellFolder2.copyFirstPIDLEntry(l2)) != 0L) {
                        if ((l2 = Win32ShellFolder2.getNextPIDLEntry(l2)) != 0L) {
                            Win32ShellFolder2.this.parent = new Win32ShellFolder2((Win32ShellFolder2)Win32ShellFolder2.this.parent, l);
                            continue;
                        }
                        Win32ShellFolder2.this.disposer.relativePIDL = l;
                    }
                }
                return null;
            }
        }, InterruptedException.class);
        Disposer.addRecord(this, this.disposer);
    }

    Win32ShellFolder2(Win32ShellFolder2 win32ShellFolder2, long l, long l2, String string) {
        super(win32ShellFolder2, string != null ? string : "ShellFolder: ");
        this.disposer.pIShellFolder = l;
        this.disposer.relativePIDL = l2;
        Disposer.addRecord(this, this.disposer);
    }

    Win32ShellFolder2(Win32ShellFolder2 win32ShellFolder2, final long l) throws InterruptedException {
        super(win32ShellFolder2, Win32ShellFolder2.invoke(new Callable<String>(){

            @Override
            public String call() {
                return Win32ShellFolder2.getFileSystemPath(Win32ShellFolder2.this.getIShellFolder(), l);
            }
        }, RuntimeException.class));
        this.disposer.relativePIDL = l;
        Disposer.addRecord(this, this.disposer);
    }

    private native void initDesktop();

    private native void initSpecial(long var1, int var3);

    public void setIsPersonal() {
        this.isPersonal = true;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return Win32ShellFolder2.invoke(new Callable<File>(){

            @Override
            public File call() {
                File[] fileArray;
                if (Win32ShellFolder2.this.isFileSystem()) {
                    return new File(Win32ShellFolder2.this.getPath());
                }
                Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDrives();
                if (win32ShellFolder2 != null && (fileArray = win32ShellFolder2.listFiles()) != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        Win32ShellFolder2 win32ShellFolder22;
                        if (!(fileArray[i] instanceof Win32ShellFolder2) || !(win32ShellFolder22 = (Win32ShellFolder2)fileArray[i]).isFileSystem() || win32ShellFolder22.hasAttribute(0x2000000)) continue;
                        return new File(win32ShellFolder22.getPath());
                    }
                }
                return new File("C:\\");
            }
        });
    }

    protected void dispose() {
        this.disposer.dispose();
    }

    static native long getNextPIDLEntry(long var0);

    static native long copyFirstPIDLEntry(long var0);

    private static native long combinePIDLs(long var0, long var2);

    static native void releasePIDL(long var0);

    private static native void releaseIShellFolder(long var0);

    private long getIShellFolder() {
        if (this.disposer.pIShellFolder == 0L) {
            try {
                this.disposer.pIShellFolder = Win32ShellFolder2.invoke(new Callable<Long>(){

                    @Override
                    public Long call() {
                        assert (Win32ShellFolder2.this.isDirectory());
                        assert (Win32ShellFolder2.this.parent != null);
                        long l = Win32ShellFolder2.this.getParentIShellFolder();
                        if (l == 0L) {
                            throw new InternalError("Parent IShellFolder was null for " + Win32ShellFolder2.this.getAbsolutePath());
                        }
                        long l2 = Win32ShellFolder2.bindToObject(l, Win32ShellFolder2.this.disposer.relativePIDL);
                        if (l2 == 0L) {
                            throw new InternalError("Unable to bind " + Win32ShellFolder2.this.getAbsolutePath() + " to parent");
                        }
                        return l2;
                    }
                }, RuntimeException.class);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.disposer.pIShellFolder;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder2 win32ShellFolder2 = (Win32ShellFolder2)this.getParentFile();
        if (win32ShellFolder2 == null) {
            return this.getIShellFolder();
        }
        return win32ShellFolder2.getIShellFolder();
    }

    public long getRelativePIDL() {
        if (this.disposer.relativePIDL == 0L) {
            throw new InternalError("Should always have a relative PIDL");
        }
        return this.disposer.relativePIDL;
    }

    private long getAbsolutePIDL() {
        if (this.parent == null) {
            return this.getRelativePIDL();
        }
        if (this.disposer.absolutePIDL == 0L) {
            this.disposer.absolutePIDL = Win32ShellFolder2.combinePIDLs(((Win32ShellFolder2)this.parent).getAbsolutePIDL(), this.getRelativePIDL());
        }
        return this.disposer.absolutePIDL;
    }

    public Win32ShellFolder2 getDesktop() {
        return Win32ShellFolderManager2.getDesktop();
    }

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    private static boolean pathsEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Win32ShellFolder2)) {
            if (!(object instanceof File)) {
                return super.equals(object);
            }
            return Win32ShellFolder2.pathsEqual(this.getPath(), ((File)object).getPath());
        }
        Win32ShellFolder2 win32ShellFolder2 = (Win32ShellFolder2)object;
        if (this.parent == null && win32ShellFolder2.parent != null || this.parent != null && win32ShellFolder2.parent == null) {
            return false;
        }
        if (this.isFileSystem() && win32ShellFolder2.isFileSystem()) {
            return Win32ShellFolder2.pathsEqual(this.getPath(), win32ShellFolder2.getPath()) && (this.parent == win32ShellFolder2.parent || this.parent.equals(win32ShellFolder2.parent));
        }
        if (this.parent == win32ShellFolder2.parent || this.parent.equals(win32ShellFolder2.parent)) {
            try {
                return Win32ShellFolder2.pidlsEqual(this.getParentIShellFolder(), this.disposer.relativePIDL, win32ShellFolder2.disposer.relativePIDL);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    private static boolean pidlsEqual(final long l, final long l2, final long l3) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Win32ShellFolder2.compareIDs(l, l2, l3) == 0;
            }
        }, RuntimeException.class);
    }

    private static native int compareIDs(long var0, long var2, long var4);

    @Override
    public boolean isFileSystem() {
        if (this.cachedIsFileSystem == null) {
            this.cachedIsFileSystem = this.hasAttribute(0x40000000);
        }
        return this.cachedIsFileSystem;
    }

    public boolean hasAttribute(final int n) {
        Boolean bl = Win32ShellFolder2.invoke(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return (Win32ShellFolder2.getAttributes0(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), n) & n) != 0;
            }
        });
        return bl != null && bl != false;
    }

    private static native int getAttributes0(long var0, long var2, int var4);

    private static String getFileSystemPath(long l, long l2) {
        String string;
        int n = 0x20010000;
        if (l == Win32ShellFolderManager2.getNetwork().getIShellFolder() && Win32ShellFolder2.getAttributes0(l, l2, n) == n && (string = Win32ShellFolder2.getFileSystemPath(Win32ShellFolderManager2.getDesktop().getIShellFolder(), Win32ShellFolder2.getLinkLocation(l, l2, false))) != null && string.startsWith("\\\\")) {
            return string;
        }
        return Win32ShellFolder2.getDisplayNameOf(l, l2, 32768);
    }

    static String getFileSystemPath(final int n) throws IOException, InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<String>(){

            @Override
            public String call() throws IOException {
                return Win32ShellFolder2.getFileSystemPath0(n);
            }
        }, IOException.class);
    }

    private static native String getFileSystemPath0(int var0) throws IOException;

    private static boolean isNetworkRoot(String string) {
        return string.equals("\\\\") || string.equals("\\") || string.equals("//") || string.equals("/");
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    @Override
    public boolean isDirectory() {
        if (this.isDir == null) {
            ShellFolder shellFolder;
            this.isDir = this.hasAttribute(0x20000000) && !this.hasAttribute(0x8000000) ? Boolean.TRUE : (this.isLink() ? Boolean.valueOf((shellFolder = this.getLinkLocation(false)) != null && shellFolder.isDirectory()) : Boolean.FALSE);
        }
        return this.isDir;
    }

    private long getEnumObjects(final boolean bl) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Long>(){

            @Override
            public Long call() {
                boolean bl2 = Win32ShellFolder2.this.disposer.pIShellFolder == Win32ShellFolder2.this.getDesktopIShellFolder();
                return Win32ShellFolder2.this.getEnumObjects(Win32ShellFolder2.this.disposer.pIShellFolder, bl2, bl);
            }
        }, RuntimeException.class);
    }

    private native long getEnumObjects(long var1, boolean var3, boolean var4);

    private native long getNextChild(long var1);

    private native void releaseEnumObjects(long var1);

    private static native long bindToObject(long var0, long var2);

    @Override
    public File[] listFiles(final boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.getPath());
        }
        try {
            return Win32ShellFolder2.invoke(new Callable<File[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File[] call() throws InterruptedException {
                    if (!Win32ShellFolder2.this.isDirectory()) {
                        return null;
                    }
                    if (Win32ShellFolder2.this.isLink() && !Win32ShellFolder2.this.hasAttribute(0x20000000)) {
                        return new File[0];
                    }
                    Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                    Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.getPersonal();
                    long l = Win32ShellFolder2.this.getIShellFolder();
                    ArrayList<Win32ShellFolder2> arrayList = new ArrayList<Win32ShellFolder2>();
                    long l2 = Win32ShellFolder2.this.getEnumObjects(bl);
                    if (l2 != 0L) {
                        try {
                            long l3;
                            int n = 0x50000000;
                            do {
                                l3 = Win32ShellFolder2.this.getNextChild(l2);
                                boolean bl2 = true;
                                if (l3 != 0L && (Win32ShellFolder2.getAttributes0(l, l3, n) & n) != 0) {
                                    Win32ShellFolder2 win32ShellFolder23;
                                    if (Win32ShellFolder2.this.equals(win32ShellFolder2) && win32ShellFolder22 != null && Win32ShellFolder2.pidlsEqual(l, l3, win32ShellFolder22.disposer.relativePIDL)) {
                                        win32ShellFolder23 = win32ShellFolder22;
                                    } else {
                                        win32ShellFolder23 = new Win32ShellFolder2(Win32ShellFolder2.this, l3);
                                        bl2 = false;
                                    }
                                    arrayList.add(win32ShellFolder23);
                                }
                                if (!bl2) continue;
                                Win32ShellFolder2.releasePIDL(l3);
                            } while (l3 != 0L && !Thread.currentThread().isInterrupted());
                        }
                        finally {
                            Win32ShellFolder2.this.releaseEnumObjects(l2);
                        }
                    }
                    return Thread.currentThread().isInterrupted() ? new File[]{} : (File[])arrayList.toArray(new ShellFolder[arrayList.size()]);
                }
            }, InterruptedException.class);
        }
        catch (InterruptedException interruptedException) {
            return new File[0];
        }
    }

    Win32ShellFolder2 getChildByPath(final String string) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Win32ShellFolder2>(){

            @Override
            public Win32ShellFolder2 call() throws InterruptedException {
                long l;
                long l2 = Win32ShellFolder2.this.getIShellFolder();
                long l3 = Win32ShellFolder2.this.getEnumObjects(true);
                Win32ShellFolder2 win32ShellFolder2 = null;
                while ((l = Win32ShellFolder2.this.getNextChild(l3)) != 0L) {
                    String string2;
                    if (Win32ShellFolder2.getAttributes0(l2, l, 0x40000000) != 0 && (string2 = Win32ShellFolder2.getFileSystemPath(l2, l)) != null && string2.equalsIgnoreCase(string)) {
                        long l4 = Win32ShellFolder2.bindToObject(l2, l);
                        win32ShellFolder2 = new Win32ShellFolder2(Win32ShellFolder2.this, l4, l, string2);
                        break;
                    }
                    Win32ShellFolder2.releasePIDL(l);
                }
                Win32ShellFolder2.this.releaseEnumObjects(l3);
                return win32ShellFolder2;
            }
        }, InterruptedException.class);
    }

    @Override
    public boolean isLink() {
        if (this.cachedIsLink == null) {
            this.cachedIsLink = this.hasAttribute(65536);
        }
        return this.cachedIsLink;
    }

    @Override
    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    private static native long getLinkLocation(long var0, long var2, boolean var4);

    @Override
    public ShellFolder getLinkLocation() {
        return this.getLinkLocation(true);
    }

    private ShellFolder getLinkLocation(final boolean bl) {
        return Win32ShellFolder2.invoke(new Callable<ShellFolder>(){

            @Override
            public ShellFolder call() {
                if (!Win32ShellFolder2.this.isLink()) {
                    return null;
                }
                Win32ShellFolder2 win32ShellFolder2 = null;
                long l = Win32ShellFolder2.getLinkLocation(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), bl);
                if (l != 0L) {
                    try {
                        win32ShellFolder2 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(Win32ShellFolder2.this.getDesktop(), l);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InternalError internalError) {
                        // empty catch block
                    }
                }
                return win32ShellFolder2;
            }
        });
    }

    long parseDisplayName(final String string) throws IOException, InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Long>(){

            @Override
            public Long call() throws IOException {
                return Win32ShellFolder2.parseDisplayName0(Win32ShellFolder2.this.getIShellFolder(), string);
            }
        }, IOException.class);
    }

    private static native long parseDisplayName0(long var0, String var2) throws IOException;

    private static native String getDisplayNameOf(long var0, long var2, int var4);

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Win32ShellFolder2.invoke(new Callable<String>(){

                @Override
                public String call() {
                    return Win32ShellFolder2.getDisplayNameOf(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), 0);
                }
            });
        }
        return this.displayName;
    }

    private static native String getFolderType(long var0);

    @Override
    public String getFolderType() {
        if (this.folderType == null) {
            final long l = this.getAbsolutePIDL();
            this.folderType = Win32ShellFolder2.invoke(new Callable<String>(){

                @Override
                public String call() {
                    return Win32ShellFolder2.getFolderType(l);
                }
            });
        }
        return this.folderType;
    }

    private native String getExecutableType(String var1);

    @Override
    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath());
    }

    private static native long getIShellIcon(long var0);

    private static native int getIconIndex(long var0, long var2);

    private static native long getIcon(String var0, boolean var1);

    private static native long extractIcon(long var0, long var2, boolean var4);

    private static native long getSystemIcon(int var0);

    private static native long getIconResource(String var0, int var1, int var2, int var3, boolean var4);

    private static native int[] getIconBits(long var0, int var2);

    private static native void disposeIcon(long var0);

    static native int[] getStandardViewButton0(int var0);

    private long getIShellIcon() {
        if (this.pIShellIcon == -1L) {
            this.pIShellIcon = Win32ShellFolder2.getIShellIcon(this.getIShellFolder());
        }
        return this.pIShellIcon;
    }

    private static Image makeIcon(long l, boolean bl) {
        int n;
        int[] nArray;
        if (l != 0L && l != -1L && (nArray = Win32ShellFolder2.getIconBits(l, n = bl ? 32 : 16)) != null) {
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            bufferedImage.setRGB(0, 0, n, n, nArray, 0, n);
            return bufferedImage;
        }
        return null;
    }

    @Override
    public Image getIcon(final boolean bl) {
        Image image;
        Image image2 = image = bl ? this.largeIcon : this.smallIcon;
        if (image == null) {
            image = Win32ShellFolder2.invoke(new Callable<Image>(){

                @Override
                public Image call() {
                    Map map;
                    long l;
                    long l2;
                    int n;
                    Image image = null;
                    if (Win32ShellFolder2.this.isFileSystem() && (n = Win32ShellFolder2.getIconIndex(l2 = Win32ShellFolder2.this.parent != null ? ((Win32ShellFolder2)Win32ShellFolder2.this.parent).getIShellIcon() : 0L, l = Win32ShellFolder2.this.getRelativePIDL())) > 0 && (image = (Image)(map = Win32ShellFolder2.this.isLink() ? (bl ? largeLinkedSystemImages : smallLinkedSystemImages) : (bl ? largeSystemImages : smallSystemImages)).get(n)) == null) {
                        long l3 = Win32ShellFolder2.getIcon(Win32ShellFolder2.this.getAbsolutePath(), bl);
                        image = Win32ShellFolder2.makeIcon(l3, bl);
                        Win32ShellFolder2.disposeIcon(l3);
                        if (image != null) {
                            map.put(n, image);
                        }
                    }
                    if (image == null) {
                        l2 = Win32ShellFolder2.extractIcon(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), bl);
                        image = Win32ShellFolder2.makeIcon(l2, bl);
                        Win32ShellFolder2.disposeIcon(l2);
                    }
                    if (image == null) {
                        image = Win32ShellFolder2.super.getIcon(bl);
                    }
                    return image;
                }
            });
            if (bl) {
                this.largeIcon = image;
            } else {
                this.smallIcon = image;
            }
        }
        return image;
    }

    static Image getSystemIcon(SystemIcon systemIcon) {
        long l = Win32ShellFolder2.getSystemIcon(systemIcon.getIconID());
        Image image = Win32ShellFolder2.makeIcon(l, true);
        Win32ShellFolder2.disposeIcon(l);
        return image;
    }

    static Image getShell32Icon(int n, boolean bl) {
        long l;
        boolean bl2 = true;
        int n2 = bl ? 32 : 16;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string = (String)toolkit.getDesktopProperty("win.icon.shellIconBPP");
        if (string != null) {
            bl2 = string.equals("4");
        }
        if ((l = Win32ShellFolder2.getIconResource("shell32.dll", n, n2, n2, bl2)) != 0L) {
            Image image = Win32ShellFolder2.makeIcon(l, bl);
            Win32ShellFolder2.disposeIcon(l);
            return image;
        }
        return null;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    public boolean isSpecial() {
        return this.isPersonal || !this.isFileSystem() || this == this.getDesktop();
    }

    @Override
    public int compareTo(File file) {
        if (!(file instanceof Win32ShellFolder2)) {
            if (this.isFileSystem() && !this.isSpecial()) {
                return super.compareTo(file);
            }
            return -1;
        }
        return Win32ShellFolderManager2.compareShellFolders(this, (Win32ShellFolder2)file);
    }

    @Override
    public ShellFolderColumnInfo[] getFolderColumns() {
        return Win32ShellFolder2.invoke(new Callable<ShellFolderColumnInfo[]>(){

            @Override
            public ShellFolderColumnInfo[] call() {
                ShellFolderColumnInfo[] shellFolderColumnInfoArray = Win32ShellFolder2.this.doGetColumnInfo(Win32ShellFolder2.this.getIShellFolder());
                if (shellFolderColumnInfoArray != null) {
                    ArrayList<ShellFolderColumnInfo> arrayList = new ArrayList<ShellFolderColumnInfo>();
                    for (int i = 0; i < shellFolderColumnInfoArray.length; ++i) {
                        ShellFolderColumnInfo shellFolderColumnInfo = shellFolderColumnInfoArray[i];
                        if (shellFolderColumnInfo == null) continue;
                        shellFolderColumnInfo.setAlignment(shellFolderColumnInfo.getAlignment() == 1 ? 4 : (shellFolderColumnInfo.getAlignment() == 2 ? 0 : 10));
                        shellFolderColumnInfo.setComparator(new ColumnComparator(Win32ShellFolder2.this, i));
                        arrayList.add(shellFolderColumnInfo);
                    }
                    shellFolderColumnInfoArray = new ShellFolderColumnInfo[arrayList.size()];
                    arrayList.toArray(shellFolderColumnInfoArray);
                }
                return shellFolderColumnInfoArray;
            }
        });
    }

    @Override
    public Object getFolderColumnValue(final int n) {
        return Win32ShellFolder2.invoke(new Callable<Object>(){

            @Override
            public Object call() {
                return Win32ShellFolder2.this.doGetColumnValue(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), n);
            }
        });
    }

    private native ShellFolderColumnInfo[] doGetColumnInfo(long var1);

    private native Object doGetColumnValue(long var1, long var3, int var5);

    private static native int compareIDsByColumn(long var0, long var2, long var4, int var6);

    @Override
    public void sortChildren(final List<? extends File> list) {
        Win32ShellFolder2.invoke(new Callable<Void>(){

            @Override
            public Void call() {
                Collections.sort(list, new ColumnComparator(Win32ShellFolder2.this, 0));
                return null;
            }
        });
    }

    static {
        Win32ShellFolder2.initIDs();
        smallSystemImages = new HashMap();
        largeSystemImages = new HashMap();
        smallLinkedSystemImages = new HashMap();
        largeLinkedSystemImages = new HashMap();
    }

    private static class ColumnComparator
    implements Comparator<File> {
        private final Win32ShellFolder2 shellFolder;
        private final int columnIdx;

        public ColumnComparator(Win32ShellFolder2 win32ShellFolder2, int n) {
            this.shellFolder = win32ShellFolder2;
            this.columnIdx = n;
        }

        @Override
        public int compare(final File file, final File file2) {
            Integer n = ShellFolder.invoke(new Callable<Integer>(){

                @Override
                public Integer call() {
                    if (file instanceof Win32ShellFolder2 && file2 instanceof Win32ShellFolder2) {
                        return Win32ShellFolder2.compareIDsByColumn(ColumnComparator.this.shellFolder.getIShellFolder(), ((Win32ShellFolder2)file).getRelativePIDL(), ((Win32ShellFolder2)file2).getRelativePIDL(), ColumnComparator.this.columnIdx);
                    }
                    return 0;
                }
            });
            return n == null ? 0 : n;
        }
    }

    static class FolderDisposer
    implements DisposerRecord {
        long absolutePIDL;
        long pIShellFolder;
        long relativePIDL;
        boolean disposed;

        FolderDisposer() {
        }

        @Override
        public void dispose() {
            if (this.disposed) {
                return;
            }
            ShellFolder.invoke(new Callable<Void>(){

                @Override
                public Void call() {
                    if (FolderDisposer.this.relativePIDL != 0L) {
                        Win32ShellFolder2.releasePIDL(FolderDisposer.this.relativePIDL);
                    }
                    if (FolderDisposer.this.absolutePIDL != 0L) {
                        Win32ShellFolder2.releasePIDL(FolderDisposer.this.absolutePIDL);
                    }
                    if (FolderDisposer.this.pIShellFolder != 0L) {
                        Win32ShellFolder2.releaseIShellFolder(FolderDisposer.this.pIShellFolder);
                    }
                    return null;
                }
            });
            this.disposed = true;
        }
    }

    public static enum SystemIcon {
        IDI_APPLICATION(32512),
        IDI_HAND(32513),
        IDI_ERROR(32513),
        IDI_QUESTION(32514),
        IDI_EXCLAMATION(32515),
        IDI_WARNING(32515),
        IDI_ASTERISK(32516),
        IDI_INFORMATION(32516),
        IDI_WINLOGO(32517);

        private final int iconID;

        private SystemIcon(int n2) {
            this.iconID = n2;
        }

        public int getIconID() {
            return this.iconID;
        }
    }
}

