//Arrow_Fly(int amount, boolean Arrow?);
class Arrow_Gen {
  AudioPlayer clicking;
  float spawnRate;
  ArrayList <Arrow> arrows;
  int count;

  Arrow_Gen() {
    clicking = minim.loadFile("clicking.wav", 2048);
    arrows = new ArrayList<Arrow>();
  } 

  void manageSpawn() {
    float rand = random(0, 1);  
    if (count > 30) {
      if (rand < spawnRate) {
        arrows.add(new Arrow());
      }
      count = 0;
    }
    count ++;
  }

  void render() {
    manageSpawn();
    display();
  }

  void display() {
    for (int i = arrows.size()-1; i >= 0; i--) {
      Arrow a = arrows.get(i);
      a.render();
      if (a.finished() == true) {
        arrows.remove(i);
      }
    }
  }


  class Arrow {
    PVector loc, ploc;
    PImage arrow;
    float tx, ty;
    int age, lifespan;
    Arrow () {
      loc = new PVector(width, height);
      ploc = new PVector(width, height);
      tx = random(0, 100000);
      ty = random(0, 100000);
      arrow = loadImage("mac-cursor.png");
      lifespan =(int) random(300, 400);
    }
    void render() {
      clicking.loop(); 
      step();
      display();

      age++;
    }

    void display() {
      stroke(255);
      strokeWeight(4);    
      image(arrow, loc.x, loc.y);
    }

    void step() {
      ploc.x = loc.x;
      ploc.y = loc.y;

      loc.x = map(noise(tx), 0, 1, -200, width+200);
      loc.y = map(noise(ty), 0, 1, -200, height+200);
      tx += 0.01;
      ty += 0.01;
    }


    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }
}

