class Cloud_Gen {
  AudioPlayer whitenoise;
  boolean spawn= false;
  Cloud[] clouds;
  int amount;
  Random generator;

  boolean startup, shutdown, first;

  Cloud_Gen(int amt) {
    whitenoise = minim.loadFile("whitenoise.aiff",512);
    first = true;
    amount = amt;
    clouds = new Cloud[amount];
    generator = new Random();
    for (int x=0;x<amount;x++) {
      clouds[x] = new Cloud(x*(width/3)+250, random(0, height*.005));
    }
  }
  void render() {
    if (spawn) {
      whitenoise.loop();
      if (first) {
        startup = true;
        first = false;
      }
      for (int x=0;x<amount;x++) {
        clouds[x].render();
      }
    }
  } 

  class Cloud {
    ArrayList<Line> lines;
    PVector base;
    float spawnRate = .9;
    float count, thickness;
    Cloud(float _x, float _y) {
      lines = new ArrayList<Line>();
      base = new PVector(_x, _y);
      base.x = _x;
      base.y = _y;
    }

    void manageSpawn() {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        for (int x = 0; x< thickness; x++) {
          lines.add(new Line());
        }
      }
    }

    void display() {
      for (int i = lines.size()-1; i >= 0; i--) {
        Line l = lines.get(i);
        l.render();
        if (l.finished() == true) {
          lines.remove(i);
        }
      }
    }
    void render() {
      changeParams();
      manageSpawn();
      display();
    } 

    void changeParams() {
      PVector move = new PVector(random(0, 10), random(0, 5));
      int max = 20;
      if (startup) {
        float thickCh = .1;
        if (thickness < max) {
          thickness += thickCh;
        }
        else {
          startup = false;
        }
      }

      if (shutdown) {
        float thickCh = .1;
        if (thickness <= max) {
          thickness -= thickCh;
        }
        if (thickness < 0) {
          shutdown = false;
          spawn = false;
        }
      }
      if ((shutdown == false) && (startup == false)) {
        thickness = max;
      }
    }

    class Line {
      PVector loc1, loc2;
      color lineFill;
      int age, lifespan;
      Line() {
        loc1 = new PVector(gaus(base.x, 200), gaus(base.y, 50));
        loc2 = new PVector(gaus(base.x, 200), gaus(base.y, 50));
        lifespan =(int) random(3, 10);
      }

      void step() {
      }
      void display() {
        colorMode(HSB);
        lineFill = color(0, 0, random(0, 255), random(0, 255));
        strokeWeight(1);
        stroke(lineFill);
        line(loc1.x, loc1.y, loc2.x, loc2.y);
      }
      void render() {
        step();
        display();

        age++;
      }

      boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
      float gaus(float baseMean, int offset) {
        float num = (float) generator.nextGaussian();
        float sd = offset;
        float mean = baseMean;
        float x = sd * num + mean;
        return x;
      }
    }
  }
}

