//NORTHWEST by Mark Fingerhut 2013

import ddf.minim.*;
import processing.video.*;
import java.util.*; 

AudioOutput out;
Minim minim;

PImage[] titlePics;
GROUND ground;
Title title;

Cloud_Gen cloud;
Line_Gen line;
Rain_Producer rain;
Night_Scene night;
Time_Keeper time;
Firefly_Gen fly;
Trunk_Maker tree;
RGB_Chaos rgbchaos;
Arrow_Gen arrow;
ZipLine_Gen zipline;
Text_Gen text;
Galaxy galaxy;
Texture texture;



PrintWriter output;
AudioSample gong;
boolean okToRun;
boolean looping = false;

void setup() {
  load();
}

void draw() {
  noStroke();
  background(0);
  if (!okToRun) {
    fill(255);
    textSize(24);
    textAlign(LEFT);
    text("Click to Embark", 20, height-20);
  }
  if (okToRun) {
    spawnCheck();
    renderAll();
  }
}

void spawnCheck() {
  if (time.scene == 1) {

    ground.startup = true;
    rgbchaos.spawnRate = .01;
  }
  //BEGIN RGB CHAOS
  if (time.scene == 1.5) {
    rgbchaos.spawnRate = .05;
  }
  if (time.scene == 2) {
    rgbchaos.spawnRate = .05;
  }
  if (time.scene == 2.5) {
    line.spawn = true;
    rgbchaos.spawnRate = .2;
  }
  if (time.scene == 3) {
    rgbchaos.spawnRate = .4;
  }
  if (time.scene == 3.5) {
    line.shutdown = true;
    arrow.spawnRate = .1;
    rgbchaos.spawnRate = .7;
  }
  if (time.scene == 4) {
    zipline.shutdown =true; 
    arrow.spawnRate = .2;
    cloud.spawn = true;
    rgbchaos.spawnRate = .05;
    tree.spawnRate = .05;
  }
  //BEGIN RAIN
  if (time.scene == 4.5) {
    rgbchaos.spawnRate = 0;
    rain.spawn = true;
    arrow.spawnRate = .3;
    tree.spawnRate = .1;
  }
  if (time.scene == 5) {
    tree.spawnRate = .2;
  }
  if (time.scene == 5.5) {
    tree.spawnRate = .25;
  }
  if (time.scene == 6) {
    tree.spawnRate = .5;
    texture.spawn = true;
  }
  if (time.scene == 6.5) {
    arrow.spawnRate = 0;
    tree.spawnRate = .7;
  }
  if (time.scene == 7) {
    tree.spawnRate = .2;
    texture.shutdown = true;
    night.spawn = true;
    rain.shutdown = true;
    night.starfield.startup = true;

    //fly.spawnRate = .1;
  }
  //BGIN NIGHT
  if (time.scene == 7.5) {
    cloud.shutdown = true;
    tree.spawnRate = .05;

    //fly.spawnRate = .2;
  }
  if (time.scene == 8) {
    tree.spawnRate = 0;
    night.moon.startup = true;

    //fly.spawnRate = .3;
  }
  if (time.scene == 8.5) {
    text.spawnRate = .1;
  }
  if (time.scene == 9) {
    fly.spawn = true;
    galaxy.spawn = true;
  }
  if (time.scene == 9.5) {
    galaxy.fractalSpawn = true;
  }
  if (time.scene == 10) {
  }
  //END NIGHT
  if (time.scene == 10.5) {
  }
  if (time.scene == 11) {
    text.spawnRate = 0;
  }
}







void loadObjects() {
  ground = new GROUND();
  time = new Time_Keeper();
  fly = new Firefly_Gen(3);
  rain= new Rain_Producer();
  line = new Line_Gen(10);
  tree = new Trunk_Maker();
  rgbchaos = new RGB_Chaos();
  arrow = new Arrow_Gen();
  night = new Night_Scene();
  cloud = new Cloud_Gen(3);
  zipline = new ZipLine_Gen();
  text = new Text_Gen();
  galaxy = new Galaxy();
  texture = new Texture();
}

void renderAll() {
  renderTexture();
  renderZipLine();
  renderNight();
  renderGalaxy();
  renderRGBChaos();
  renderArrow();
  renderTree();
  renderLines();
  renderTitle();
  renderGround();
  renderTime();
  renderFly();
  renderText();
  renderRain();
  renderCloud();
}



void renderGround() {
  ground.render();
}
void renderLines() {
  line.render();
}
void renderRain() {
  rain.render();
}
void renderFly() {
  fly.render();
}
void renderTime() {
  time.render();
}
void renderTree() {
  tree.render();
}
void renderRGBChaos() {
  rgbchaos.render();
}
void renderArrow() {
  arrow.render();
}
void renderNight() {
  night.render();
}
void renderCloud() {
  cloud.render();
}
void renderZipLine() {
  zipline.render();
}
void renderText() {
  text.render();
}
void renderGalaxy() {
  galaxy.render();
}
void renderTexture() {
  texture.render();
}
void movieEvent(Movie m) {
  m.read();
}
void captureTime() {
  println("This game started at " + minute() + ":" + second());
}

void renderTitle() {
  title.render();
}

class Title {
  boolean first = true;
  Title() {
  }
  void render() {
    if ((time.time > 400) &&(time.scene == 1)) {
      if (first) {
        gong.trigger();
        time.soundtrack.trigger();
        night.moon.shutdown = false;
        night.starfield.shutdown = false;
        first = false;
      }
      pushMatrix();
      imageMode(CENTER);
      translate(width/2, height/2);
      rotate(-radians(time.time/22)+45);
      tint(255);
      image(titlePics[(int)random(0, 30)], 0, 0);
      popMatrix();
    }
  }
}

void stop() {
  minim.stop();
  super.stop();
  output.println ("You wil never go to Northwest.");
  output.flush();
  output.close();
}
/* 
 
 TEXT TO SPEECH
 
 
 */



static class TextToSpeech extends Object {

  // Store the voices, makes for nice auto-complete in Eclipse
  static final String ALEX = "Alex";
  static final String BRUCE = "Bruce";
  static final String FRED = "Fred";
  static final String JUNIOR = "Junior";
  static final String RALPH = "Ralph";
  static final String AGNES = "Agnes";
  static final String KATHY = "Kathy";
  static final String PRINCESS = "Princess";
  static final String VICKI = "Vicki";
  static final String VICTORIA = "Victoria";

  static String[] voices = {
    ALEX, BRUCE, FRED, RALPH, AGNES, KATHY, 
    PRINCESS, VICKI, VICTORIA
  };

  // this sends the "say" command to the terminal with the appropriate args
  static void say(String script, String voice, int speed) {
    try {
      Runtime.getRuntime().exec(new String[] {
        "say", "-v", voice, "[[rate " + speed + "]]" + script
      }
      );
    }
    catch (IOException e) {
      System.err.println("IOException");
    }
  }

  // Overload the say method so we can call it with fewer arguments and basic defaults
  static void say(String script) {
    // 200 seems like a resonable default speed
    say(script, ALEX, 200);
  }
}

void reset() { 
  load();
  //  text.spawnRate = 0;
  //  fly.spawn = false;
  //  zipline.shutdown =false; 
  //  arrow.spawnRate = 0;
  //  cloud.spawn = false;
  //  night.moon.shutdown = true;
  //  night.starfield.shutdown = true;
  //  rgbchaos.spawnRate = 0;
  //  tree.spawnRate = 0;
  //  night.moon.startup = false;
  //  night.starfield.startup = false;
  //  line.shutdown = false;
  //  ground.startup = false;
  //  rain.shutdown = false;
  //  title.first = true;
  //  galaxy.spawn = false;
  //  galaxy.fractalSpawn = false;
  //  time.time = 0;
  //  time.story.reset();
}

void mousePressed() {
  okToRun = true;
}

void keyPressed() {
  if (key == 'r') {
    fill(0);
    rect(0, 0, width, height);
    textAlign(CENTER);
    text("Resetting", width/2, height/2);
    reset();
  }
  if (!okToRun) {
    if (key == 'l') {
      if (looping == false) {
        text("Looping", 20, 40); 
        looping = true;
      }
      else if (looping == true) {
        text("Not Looping", 20, 40); 
        looping = false;
      }
    }
  }
}

void load() {
  output = createWriter("travelLog.txt"); 
  minim = new Minim(this);
  title = new Title();
  gong = minim.loadSample("gong.aif");
  titlePics = new PImage[30];
  for (int x = 0; x< 30; x++) {
    String filename = "title"+x+".png";
    titlePics[x] = loadImage(filename);
  }
  size(1440, 900, P2D);
  noCursor();
  loadObjects();
  okToRun = false;

  captureTime();
}

