class RGB_Chaos {
  float spawnRate;
  ArrayList <Band> bands;
  ArrayList <Border_Lines> borders;
  ArrayList<Pixel> pixel;
  ArrayList<Hole> hole;
  AudioSample[] glitches;
  int lineBuff, it;
  RGB_Chaos() {
    glitches = new AudioSample[20];
    for (int x=0;x<20;x++) {
      String filename = "glitch"+x+".aif";
      glitches[x] = minim.loadSample(filename, 512);

      bands = new ArrayList <Band>();
      borders = new ArrayList <Border_Lines>();
      pixel = new ArrayList<Pixel>();
      hole = new ArrayList<Hole>();
    }
  } 
  void override() {
    hole.add(new Hole());
  }
  void manageSpawn() {
    if (spawnRate >=.7) {
      zipline.startup = true; 
      zipline.theme = "rgb";
    } 
    else if (spawnRate <.7) {
    }
    if (lineBuff > random(2, 10)) {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        if (it > 25) {
          if (spawnRate >= .7) {
            hole.add(new Hole());
            it=0;
          }
        }
        if (spawnRate > .4) {
          pixel.add(new Pixel());
        }
        if (spawnRate > .2) {
          borders.add(new Border_Lines());
        }

        bands.add(new Band());

        glitches[(int)random(0, 20)].trigger();
      }
      lineBuff = 0;
      it++;
    }
    lineBuff++;
  }
  void render() {
    manageSpawn();
    display();
  }
  void display() {
    for (int i = hole.size()-1; i >= 0; i--) {
      Hole h = hole.get(i);
      h.render();
      if (h.finished() == true) {
        hole.remove(i);
      }
    }
    for (int i = bands.size()-1; i >= 0; i--) {
      Band b = bands.get(i);
      b.render();
      if (b.finished() == true) {
        bands.remove(i);
      }
    }
    for (int i = borders.size()-1; i >= 0; i--) {
      Border_Lines b = borders.get(i);
      b.render();
      if (b.finished() == true) {
        borders.remove(i);
      }
    }
    for (int i = pixel.size()-1; i >= 0; i--) {
      Pixel p = pixel.get(i);
      p.render();
      if (p.finished() == true) {
        pixel.remove(i);
      }
    }
  }

  class Band {
    PVector loc;
    int lifespan, age;
    float h;
    Band() {
      h = random(0, 1);
      loc = new PVector(random(0, width), random(0, height));
      lifespan = (int)random(10, 15);
    }
    void display() {
      colorMode(HSB);
      strokeWeight(1);
      stroke(random(255), 255, 255);

      if (h <.5) {
        line(loc.x, height, loc.x, 0);
      }
      else {
        line(0, loc.y, width, loc.y);
      }
    }
    void render() {
      display();
      age++;
    }
    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }//end of Band

  class Border_Lines {
    int side;
    int age, lifespan;

    Border_Lines() {
      //side = 0;
      side = (int) random(0, 3);
      lifespan = (int) random(10, 20);
    }
    void display() {
      if (side == 0) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(width-(t*4), 0, width-(t*4), height);
        }
      }
      if (side == 1) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(0, 0+(t*4), width, 0+(t*4));
        }
      }
      if (side == 2) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(0+(t*4), 0, 0+(t*4), height);
          ;
        }
      }
    }
    void render() {
      display();

      age++;
    }

    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }

  class Pixel {
    int age, lifespan;
    Pixel() {
      lifespan =(int) random(5, 10);
    }
    void render() {
      for (int x=0; x<random(200,1000);x++) {
        point(random(0, width), random(0, height));
      }

      age++;
    }
    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }//End of Pixel
  class Hole {
    int age, lifespan;
    int hue;
    Hole() {
      lifespan =(int) random(16, 30);
      hue =(int) random(0, 255);
    }
    void display() {
      for (int x = 1; x< age; x++) {
        colorMode(HSB);
        //stroke(random(255), 255, 255-(40*x));
        fill(random(255), 255, 255-(10*x));
        int off = width - ((25*x)-25);
        int hoff = height - ((25*x)-25);
        rectMode(CORNERS);
        rect((25*x)-25, (25*x)-25, off, hoff);
      }
    }
    void render() {
      display();

      age++;
    }
    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }// end of Hole
} // end of RGB_Chaos

