class Time_Keeper {
  AudioSample soundtrack;
  float time;
  float scene, prevScene;
  int maxTime;
  int startTime;
  PImage[] walk;
  int walkCnt;
  Story story;
  boolean second;
  Time_Keeper() {
    walk = new PImage[10];
    for (int x = 0; x<10; x++) {
      String filename = "walk"+x+".png";
      walk[x] = loadImage(filename);
    }
    soundtrack = minim.loadSample("soundtrack.aif");
    time = 0; 
    maxTime = 16000;
    story = new Story();
  }

  void render() {
    checkTime();
    display(); 
    story.render();
    time +=1;
  }

  void checkTime() {

    float timeMili = time/frameRate;
    if ((time >= 0) && (time < maxTime*.05)) {
      scene = 1;
    }
    if ((time >= maxTime *.05) && (time < maxTime*.1)) {
      scene = 1.5;
    }
    if ((time >= maxTime *.1) && (time < maxTime*.15)) {
      scene = 2;
    }
    if ((time >= maxTime *.15) && (time < maxTime*.2)) {
      scene = 2.5;
    }
    if ((time >= maxTime *.2) && (time < maxTime*.25)) {
      scene = 3;
    }
    if ((time >= maxTime *.25) && (time < maxTime*.3)) {
      scene = 3.5;
    }
    if ((time >= maxTime *.3) && (time < maxTime*.35)) {
      scene = 4;
    }
    if ((time >= maxTime *.35) && (time < maxTime*.4)) {
      scene = 4.5;
    }
    if ((time >= maxTime *.4) && (time < maxTime*.45)) {
      scene = 5;
    }
    if ((time >= maxTime *.45) && (time < maxTime*.5)) {
      scene = 5.5;
    }
    if ((time >= maxTime *.5) && (time < maxTime*.55)) {
      scene = 6;
    }
    if ((time >= maxTime *.55) && (time < maxTime*.6)) {
      scene = 6.5;
    }
    if ((time >= maxTime *.6) && (time < maxTime*.65)) {
      scene = 7;
    }
    if ((time >= maxTime *.65) && (time < maxTime*.7)) {
      scene = 7.5;
    }
    if ((time >= maxTime *.7) && (time < maxTime*.75)) {
      scene = 8.0;
    }
    if ((time >= maxTime *.75) && (time < maxTime*.8)) {
      scene = 8.5;
    }
    if ((time >= maxTime *.8) && (time < maxTime*.85)) {
      scene = 9;
    }
    if ((time >= maxTime *.85) && (time < maxTime*.9)) {
      scene = 9.5;
    }
    if ((time >= maxTime *.9) && (time < maxTime*.95)) {
      scene = 10;
    }
    if ((time >= maxTime *.95) && (time < maxTime)) {
      scene = 10.5;
    }
    if (time > maxTime) {
      scene = 11;
    }

    if (scene != prevScene) {
      if (second == false) {
        story.life = 500;
      }
      second = !second;
    }

    prevScene = scene;
  } 

  void display() {
    float loc = map(time, 0, maxTime, 0, width);   
    float sin = sin(time/30);
    float sin1 = sin(time/28);
    float walkHeight = map(sin, 0, 1, height, height+2);
    float walkHeight1 = map(sin1, 0, 1, height, height+2);
    imageMode(CORNER);
    tint(255);
    image(walk[walkCnt], width - loc-1, walkHeight, 80, -100);
    tint(230);
    image(walk[walkCnt], width - loc+35, walkHeight1, 70, -90);
    tint(140);
    image(walk[walkCnt], width - loc+55, walkHeight, 80, -110);

    walkCnt++;
    if (walkCnt == 10) {
      walkCnt = 0;
    }
    if (width - loc < -110) {
      if (looping) {
        reset();
      } 
      else {
        exit();
      }
    }
    if (width - loc < -50) {
      float opacity = (loc - width - 50)*6;

      fill(255, opacity);
      textSize(24);
      textAlign(LEFT);
      text("Music was made by Oneohtrix Point Never and used without permission. ", 20, height-20);
      fill(0, opacity);
      rect(0, 0, width, height);
    }
    if (width - loc < -80) {
      textAlign(RIGHT);
      fill(255, 255);
      text("Mark Fingerhut 2013", width-20, height-20);
    }
  }
}

