;---  
; Random: generates a random number within given range
;-- --   -- -    
; this one is from the book "co^jak w assemblerze", but there
; are many ways to generate a pseudo-random number.  the idea
; is to perform some strange operations on the "seed" number,
; you can use your invention.
;
; in  : [RndHi] - [RndLo]=random number range
; out : ax=number
;
rnd_hi             dw ?
rnd_lo             dw ?
Seeds              dw 1234h

Random:            mov  bx, seeds
                   add  bx, 9248h
                   ror  bx, 3
                   mov  seeds, bx
                   mov  ax, rnd_hi
                   sub  ax, rnd_lo
                   mul  bx
                   mov  ax, dx
                   add  ax, rnd_lo
                   ret

;---  
; STR_make: creates a fine starfield
;-- --   -- -    
STR_make:          mov   ax, seg stars
                   mov   es, ax
                   lea   di, stars
                   mov   cx, Stars_nbr
make_strs_loop:
                   mov   rnd_lo, 0
                   mov   rnd_hi, 0ffffh
                   call  Random
                   stosw
                   dec   cx
                   jnz   make_strs_loop
                   ret

;---  
; STR_move: moves all the stars closer
;-- --   -- -    
STR_move:          mov   ax, seg stars
                   mov   ds, ax
                   mov   es, ax
                   lea   si, stars
                   mov   di, si
                   mov   cx, Stars_nbr/6
incy_loop:
                   mov   Rnd_hi, 2
                   mov   Rnd_lo, 0
                   call  Random
                   mov   dx, ax

                   lodsw
                   add   ax, 320
                   add   ax, dx
                   stosw
                   lodsw
                   add   ax, 320
                   add   ax, dx
                   stosw
                   lodsw
                   add   ax, 640
                   add   ax, dx
                   stosw
                   lodsw
                   add   ax, 640
                   add   ax, dx
                   stosw
                   lodsw
                   add   ax, 960
                   add   ax, dx
                   stosw
                   lodsw
                   add   ax, 960
                   add   ax, dx
                   stosw

                   dec   cx
                   jnz   incy_loop
                   ret

;---  
; STR_show: shows all the stars
;-- --   -- -    
STR_show:          mov   ax, seg stars
                   mov   ds, ax
                   lea   si, stars
                   mov   ax, seg virt_scrn
                   mov   es, ax
                   lea   di, virt_scrn

                   mov   cx, Stars_nbr/6
show_loop:

PL1:               lodsw
                   cmp   ax, Clip_t*Xres
                   jb    PL2
                   cmp   ax, Clip_b*Xres
                   ja    PL2
                   mov   di, ax

                   mov   al, es:[di]
                   cmp   al, 21
                   ja    PL2

                   mov   ax, 21
                   stosb

PL2:               lodsw
                   cmp   ax, Clip_t*Xres
                   jb    PL3
                   cmp   ax, Clip_b*Xres
                   ja    PL3

                   mov   di, ax
                   mov   al, es:[di]
                   cmp   al, 42
                   ja    PL3

                   mov   ax, 42
                   stosb

PL3:               lodsw
                   cmp   ax, Clip_t*Xres
                   jb    PL4
                   cmp   ax, Clip_b*Xres
                   ja    PL4

                   mov   di, ax
                   mov   al, es:[di]
                   cmp   al, 63
                   ja    PL4

                   mov   ax, 63
                   stosb

PL4:               lodsw
                   cmp   ax, Clip_t*Xres
                   jb    PL5
                   cmp   ax, Clip_b*Xres
                   ja    PL5
                   mov   di, ax
                   mov   al, es:[di]
                   cmp   al, 84
                   ja    PL5

                   mov   ax, 84
                   stosb

PL5:               lodsw
                   cmp   ax, (Clip_t+1)*Xres
                   jb    PL6
                   cmp   ax, (Clip_b-1)*Xres
                   ja    PL6
                   mov   di, ax

CH1:               mov   al, es:[di]
                   cmp   al, 105
                   ja    CH2
                   mov   al, 105
                   mov   es:[di], al
                   
CH2:               mov   al, es:[di+1]
                   cmp   al, 105
                   ja    CH3
                   mov   al, 105
                   mov   es:[di+1], al
                   
CH3:               mov   al, es:[di-1]
                   cmp   al, 105
                   ja    CH4
                   mov   al, 105
                   mov   es:[di-1], al
                   
CH4:               mov   al, es:[di+320]
                   cmp   al, 105
                   ja    CH5
                   mov   al, 105
                   mov   es:[di+320], al
                   
CH5:               mov   al, es:[di-320]
                   cmp   al, 105
                   ja    PL6
                   mov   al, 105
                   mov   es:[di-320], al

PL6:               lodsw
                   cmp   ax, (Clip_t+1)*Xres
                   jb    NEXTY
                   cmp   ax, (Clip_b-1)*Xres
                   ja    NEXTY
                   mov   di, ax
                   mov   al, 125
                   mov   es:[di-1], al
                   mov   es:[di+1], al
                   mov   es:[di-320], al
                   mov   es:[di+320], al
                   stosb

NEXTY:             dec   cx
                   jnz   show_loop
                   ret