
/* VBE2.H - VBE 2.0 Library */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <go32.h>
#include <dos.h>
#include <dpmi.h>
#include <sys/nearptr.h>

/* SVGA Mode Information */

typedef struct {
  unsigned char  VbeSignature[4]      __attribute__ ((packed));
  unsigned short VbeVersion           __attribute__ ((packed));
  unsigned short OemStringPtrOff      __attribute__ ((packed));
  unsigned short OemStringPtrSeg      __attribute__ ((packed));
  unsigned char  Capabilities[4]      __attribute__ ((packed));
  unsigned long  VideoModePtr         __attribute__ ((packed));
  unsigned short TotalMemory          __attribute__ ((packed));

  unsigned short OemSoftwareRev       __attribute__ ((packed));
  unsigned long  OemVendorNamePtr     __attribute__ ((packed));
  unsigned long  OemProductNamePtr    __attribute__ ((packed));
  unsigned long  OemProductRevPtr     __attribute__ ((packed));
  unsigned char  Reserved[222]        __attribute__ ((packed));

  unsigned char  OemData[256]         __attribute__ ((packed));
} VbeInfoBlock;

typedef struct {
  unsigned short ModeAttributes       __attribute__ ((packed));
  unsigned char  WinAAttributes       __attribute__ ((packed));
  unsigned char  WinBAttributes       __attribute__ ((packed));
  unsigned short WinGranularity       __attribute__ ((packed));
  unsigned short WinSize              __attribute__ ((packed));
  unsigned short WinASegment          __attribute__ ((packed));
  unsigned short WinBSegment          __attribute__ ((packed));
  unsigned long  WinFuncPtr           __attribute__ ((packed));
  unsigned short BytesPerScanLine     __attribute__ ((packed));
  unsigned short XResolution          __attribute__ ((packed));
  unsigned short YResolution          __attribute__ ((packed));
  unsigned char  XCharSize            __attribute__ ((packed));
  unsigned char  YCharSize            __attribute__ ((packed));
  unsigned char  NumberOfPlanes       __attribute__ ((packed));
  unsigned char  BitsPerPixel         __attribute__ ((packed));
  unsigned char  NumberOfBanks        __attribute__ ((packed));
  unsigned char  MemoryModel          __attribute__ ((packed));
  unsigned char  BankSize             __attribute__ ((packed));
  unsigned char  NumberOfImagePages   __attribute__ ((packed));
  unsigned char  res1                 __attribute__ ((packed));
  unsigned char  RedMaskSize          __attribute__ ((packed));
  unsigned char  RedFieldPosition     __attribute__ ((packed));
  unsigned char  GreenMaskSize        __attribute__ ((packed));
  unsigned char  GreenFieldPosition   __attribute__ ((packed));
  unsigned char  BlueMaskSize         __attribute__ ((packed));
  unsigned char  BlueFieldPosition    __attribute__ ((packed));
  unsigned char  RsvdMaskSize         __attribute__ ((packed));
  unsigned char  RsvdFieldPosition    __attribute__ ((packed));
  unsigned char  DirectColorModeInfo  __attribute__ ((packed));

  /* VESA 2.0 variables */
  unsigned long  PhysBasePtr          __attribute__ ((packed));
  unsigned long  OffScreenMemOffset   __attribute__ ((packed));
  unsigned short OffScreenMemSize     __attribute__ ((packed));
  unsigned char  Reserveds[206]       __attribute__ ((packed));
} VbeModeInfoBlock;

VbeInfoBlock vbeinfo;
VbeModeInfoBlock modeinfo;

/* VESA functions */

int getvbeinfo(VbeInfoBlock *vbeinfo);
void getmodeinfo(unsigned short mode, VbeModeInfoBlock *modeinfo);
int searchvideomode(short x,short y,char bits);
int testmode(short x,short y,char bits);
void initmode(int mode);
void settextmode();

