/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "exportwidget.hh"
#include "ui_exportwidget.h"
#include "curveeditorwidget.hh"
#include "renderwidget.hh"

#include <QtCore>
#include <QFileDialog>
#include <QImage>

ExportWidget::ExportWidget(QWidget *parent) :
    QDockWidget(parent),
    ui(new Ui::ExportWidget)
{
    ui->setupUi(this);
    _cancel = false;
}

ExportWidget::~ExportWidget()
{
    delete ui;
}

#define TAB(sizeX, x,y,c) (y)*(sizeX)*3 + (x)*3 + c
void ExportWidget::Export( RenderWidget *rw, CurveEditorWidget *cew, QString path, int X,int Y, int AA, bool AAChecked, float motion, int fps, int timeStart, int timeEnd )
{
    ui->progressBar->setValue(0);
    int size = X * Y * 3 ;

    unsigned char *Data = new unsigned char[size];
    unsigned char *OverData = new unsigned char[X*AA * Y*AA * 3];


    //Frame loop
    QTime time;
    time.start();

    for(int frame=0; frame<(timeEnd-timeStart)*fps; frame++)
    {
        //Time
        cew->setDemoTime( (float)timeStart + (float)frame / (float)fps , false);

        //Anti-aliasing rocksing !
        if(AAChecked)
        {
            rw->setMaximumWidth(X*AA+1);
            rw->setMaximumHeight(Y*AA+1);
            rw->setGeometry(QRect(0,0,X*AA,Y*AA));
            rw->renderToBuffer(OverData,X*AA,Y*AA);

            for(int x=0; x<X; x++)
            for(int y=0; y<Y; y++)
            for(int c=0; c<3; c++)
            {
                int tmp=0;
                for(int i=0; i<AA; i++)
                for(int j=0; j<AA; j++)
                    tmp += OverData[TAB(X*AA,x*AA+i,y*AA+j,c)];
                Data[TAB(X,x,y,c)] = (unsigned char)((float)(tmp/(AA*AA))*(1.f-motion) + (float)Data[TAB(X,x,y,c)]*motion);
            }
        }
        else
        {
            rw->setMaximumWidth(X+1);
            rw->setMaximumHeight(Y+1);
            rw->setGeometry(QRect(0,0,X,Y));
            rw->renderToBuffer(Data,X,Y);
        }


        //Flip & Export
        QImage image( Data, X,Y, QImage::Format_RGB888);
        QImage mirrored = image.mirrored(false,true);
        mirrored.save(path+"/"+QString::number(frame)+".png","PNG",100);

        //Progress ..
        QString tmpStr,tmpStr2;

        tmpStr.setNum(float(time.elapsed())*0.001f/(float(frame+1)), 'f');
        ui->TBFLabel->setText("Time by frame : "+tmpStr+" sec");

        float sec = float(time.elapsed())*0.001f/float(frame)*((timeEnd-timeStart)*fps-frame);
        int min = int(sec/60.f);
        sec = sec-min*60;
        tmpStr.setNum(min);
        tmpStr2.setNum((int)sec);
        ui->RemainingLabel->setText("Remaining time : "+tmpStr+" min "+tmpStr2+" sec");


        tmpStr.setNum(frame);
        tmpStr2.setNum((timeEnd-timeStart)*fps);
        ui->FrameCountLabel->setText("Frame : "+tmpStr+"/"+tmpStr2);

        ui->progressBar->setValue( (frame+1)*100/((timeEnd-timeStart)*fps) );

        qApp->processEvents();

        if(_cancel)
            break;
    }
    _cancel = false;
    delete[] OverData;
    delete[] Data;
}
