/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "glextensions.hh"


        char procAdressesNames[34][29] = {
	{"glCreateProgramObjectARB"},
	{"glCreateShaderObjectARB"},
	{"glShaderSourceARB"},
	{"glCompileShaderARB"},
	{"glAttachObjectARB"},
	{"glLinkProgramARB"},
	{"glUseProgramObjectARB"},
	{"glDeleteObjectARB"},
	{"glGetUniformLocationARB"},
	{"glProgramParameteriEXT"},
	{"glUniform1iARB"},
	{"glUniform1fARB"},
	{"glUniform3fARB"},
	{"glUniform4fARB"},
	{"glGenFramebuffersEXT"},
	{"glGenRenderbuffersEXT"},
	{"glBindFramebufferEXT"},
	{"glBindRenderbufferEXT"},
	{"glDeleteFramebuffersEXT"},
	{"glDeleteRenderbuffersEXT"},
	{"glRenderbufferStorageEXT"},
	{"glFramebufferRenderbufferEXT"},
	{"glFramebufferTexture2DEXT"},
	{"glPointParameterfARB"},
	{"glPointParameterfvARB"},
	{"glGenBuffersARB"},
	{"glDeleteBuffersARB"},
	{"glBindBufferARB"},
	{"glBufferDataARB"},
        {"glBufferSubDataARB"},
        {"glTexImage3D"},
        {"glActiveTexture"},
        {"glGetObjectParameterivARB"},
        {"glUniform2fARB"},
};



PROC procAdresses[50];

void InitProcAdresses(const QGLContext *context)
{
        for(int i=0; i<33; i++)
	{
            procAdresses[i] = NULL;
            procAdresses[i] = context->getProcAddress(QString(&procAdressesNames[i][0]));
		if( !procAdresses[i])
                {
                    QMessageBox::information(NULL, QString("ERROR : Load extension"), QString(procAdressesNames[i]));
                    exit(0);
		}
	}
}









