/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef MAINWINDOW_HH
#define MAINWINDOW_HH

#include <QtGui>

namespace Ui {
    class MainWindow;
}

class PlayerWidget;
class CurveEditorWidget;
class SceneEditorWidget;
class SceneEditorTreeItem;
class ShaderEditorWidget;
class VideoExportWidget;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget* parent = NULL);
    ~MainWindow();

    virtual void keyPressEvent(QKeyEvent* event);
    virtual void keyReleaseEvent(QKeyEvent* event);

public slots:
    void open();
    void save();
    void saveas();
    void about();
private:
    void SaveRecursiveTree(QTextStream &stream, SceneEditorTreeItem* tree);
    Ui::MainWindow *ui;
    PlayerWidget* _pw;
    CurveEditorWidget* _cew;
    SceneEditorWidget* _sew;
    ShaderEditorWidget* _shew;
    VideoExportWidget* _vew;

    QShortcut* _cutShortcut;
    QShortcut* _copyShortcut;
    QShortcut* _pasteShortcut;
    QShortcut* _freeflyShortcut;

    QString _filename;
};

#endif // MAINWINDOW_HH
