/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef RENDERWIDGET_HH
#define RENDERWIDGET_HH

#include <QtGui>
#include <QtOpenGL/QtOpenGL>
#include "fbo.hh"

struct Scene
{
    float camPosX,camPosY,camPosZ;
    float camTargetX,camTargetY,camTargetZ;
    float fov;

    float ShaderParam[8];
    float PostParam[8];
};

class SceneEditorTreeItem;

class RenderWidget : public QGLWidget
{
    Q_OBJECT
public:
    RenderWidget(QWidget* parent = NULL);

    virtual void initializeGL();
    virtual void resizeGL(int w, int h);
    virtual void paintGL();
    virtual void mousePressEvent(QMouseEvent* event);
    virtual void mouseReleaseEvent(QMouseEvent* event);
    virtual void mouseMoveEvent(QMouseEvent* event);
    virtual void wheelEvent(QWheelEvent* event);
    void         renderToBuffer(unsigned char *Data, int X,int Y);
    GLuint       getTexture(int id);
    SceneEditorTreeItem* sceneTree() const;

public slots:
    void setViewAngle(float x, float y);
    void addViewAngle(float x, float y);
    void addZoomFactor(float f);
    void setViewOffset(float x, float y, float z);
    void addViewOffset(float x, float y);
    void setShiftPressed(bool b);

    void setDemoTime(float t);
    void setDemoTime(unsigned int t);
    void setSizeRTT(int width, int height);
    void setCamera(int a);

    void startCameraFreefly();

    void emitMakeWaypoint();

    void CompilShader(QString vertexShader, QString fragmentShader);
    void CompilPostShader(QString vertexShader, QString fragmentShader);

signals:
    void makeWaypoint(float, float, float, float, float, float);
    void shaderSceneStatus(QString);
    void shaderPostStatus(QString);
    void setFPSLabel(QString);

private:
    void ApplyCamera(void);
    int _w, _h;
    float _ratio;

    float _trigX, _trigY;
    float _ofsX, _ofsY, _ofsZ;
    float _zoomFactor;

    /*float _curvePX, _curvePY, _curvePZ, _curveTX, _curveTY, _curveTZ;
    float _mandelbox_scale, _mandelbox_box;*/
    int _cameraType;
    Scene _scene;

    bool _moveToChangeOffset;

    Qt::MouseButton _pressedButton;
    QPoint _startMousePos;

    bool _shiftPressed;
    GLuint _shader,_postShader;
    FBO *_fbo;

    SceneEditorTreeItem* _sceneTree;

    float _demoTime;

    bool _freeflyEnabled;
    float _freeflySpeed;
    QVector3D _freeflyPosition;
    float _freeflyTrigX, _freeflyTrigY;
    float _freeflyPxOffset, _freeflyPyOffset;
    QTime _freeflyTimer;

    GLuint _texture[4];
};

#endif // RENDERWIDGET_HH
