/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "shader.hh"


#include <QtOpenGL/QtOpenGL>


//-----------------------------------------------------------------------------
// MakeShader
//-----------------------------------------------------------------------------
bool MakeShader(GLuint program, const char *txt, GLuint type)
{
	GLuint object = glCreateShaderObject(type);
	glShaderSource(object, 1, (const GLchar**)(&txt), NULL);
	glCompileShader(object);

        GLint ok = false;
        glGetObjectParameteriv(object, GL_OBJECT_COMPILE_STATUS_ARB, &ok);

	glAttachObject(program, object);
	glDeleteObject(object);

        return ok;
}



//-----------------------------------------------------------------------------
// ShaderCompil
//-----------------------------------------------------------------------------
GLuint ShaderCompil(const char *vsh, const char *psh, int *error, const char *gsh)
{
    *error = 0;
    GLuint program = glCreateProgramObject();
    if( !MakeShader(program, vsh, GL_VERTEX_SHADER_ARB) )
        *error = 1;
    if(gsh) {
        MakeShader(program, gsh, GL_GEOMETRY_SHADER_EXT);
        glProgramParameteri(program,GL_GEOMETRY_INPUT_TYPE_EXT , GL_POINTS );
        glProgramParameteri(program,GL_GEOMETRY_OUTPUT_TYPE_EXT , GL_TRIANGLE_STRIP);
        glProgramParameteri(program,GL_GEOMETRY_VERTICES_OUT_EXT, 16);
    }
    if( !MakeShader(program, psh, GL_FRAGMENT_SHADER_ARB) )
        *error = 2;

    glLinkProgram(program);

    return program;
}










