/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "videoexportwidget.hh"
#include "curveeditorwidget.hh"
#include "renderwidget.hh"
#include "ui_videoexportwidget.h"
#include "exportwidget.hh"

#include <QtCore>
#include <QFileDialog>
#include <QImage>

VideoExportWidget::VideoExportWidget(RenderWidget *rw, CurveEditorWidget *cew, QWidget *parent) :
    QDockWidget(parent),
    ui(new Ui::VideoExportWidget)
{
    ui->setupUi(this);
    _rw = rw;
    _cew = cew;
}

VideoExportWidget::~VideoExportWidget()
{
    delete ui;
}

void VideoExportWidget::changeEvent(QEvent *e)
{
    QDockWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void VideoExportWidget::selectPath()
{
    QString path = QFileDialog::getExistingDirectory(this);
    ui->pathLineEdit->setText( path );
}

void VideoExportWidget::exportVideo()
{
    ExportWidget exporter;
    exporter.show();
    exporter.Export(_rw,_cew, ui->pathLineEdit->text(), ui->screenXSpinBox->value(),ui->screenYSpinBox->value(), ui->AAspinbox->value(), ui->AAcheckbox->isChecked(), ui->motionBlurSpinBox->value(), ui->FPSSpinbox->value(), ui->timeStartSpinBox->value(), ui->timeEndSpinBox->value());

}
