
#include <D3D8.h>
#include "D3DU8.h"

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "Rand.h"

#define D3DFVF_BLOBPLANE_VERTEX1 (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2)
struct BLOBPLANE_VERTEX1
  {
    D3DVECTOR Vertex;
    D3DVECTOR Normal;
    DWORD Diffuse;
    FLOAT TexU1, TexV1;
   };

LPDIRECT3DVERTEXBUFFER8 BlobPlane_VertexBuffer1 = NULL, BlobPlane_VertexBuffer2 = NULL;
BLOBPLANE_VERTEX1 *BlobPlane_Vertex1, BlobPlane_ConstVertex1[10] =
  {{{ -1.0f, 1.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00FFFFFF, -0.5f, 0.5f },
    {{ -4.0f, 4.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00000000, -2.0f, 2.0f },
    {{ -1.0f, -1.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00FFFFFF, -0.5f, -0.5f },
    {{ -4.0f, -4.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00000000, -2.0f, -2.0f },
    {{ 1.0f, -1.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00FFFFFF, 0.5f, -0.5f },
    {{ 4.0f, -4.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00000000, 2.0f, -2.0f },
    {{ 1.0f, 1.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00FFFFFF, 0.5f, 0.5f },
    {{ 4.0f, 4.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00000000, 2.0f, 2.0f },
    {{ -1.0f, 1.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00FFFFFF, -0.5f, 0.5f },
    {{ -4.0f, 4.0f, -0.1f }, { 0.0f, 0.0f, 1.0f }, 0x00000000, -2.0f, 2.0f }};

LPDIRECT3DINDEXBUFFER8 BlobPlane_IndexBuffer2 = NULL;
WORD *BlobPlane_Index2;

int BlobPlane_VertexIdx2, BlobPlane_IndexIdx2;

D3DMATERIAL8 BlobPlane_Material1;
D3DLIGHT8 BlobPlane_Light1;

LPDIRECT3DTEXTURE8 BlobPlane_Texture1;

static TXGEN_LAYER *TxLayer1, *TxLayer2;

float BlobPlane_Field[64][64];    // - Blob Field.
D3DVECTOR BlobPlane_Const[16][4]; // - Sin/Cos Consts, Prepared For 64 Planes.
D3DVECTOR BlobPlane_Camera1, BlobPlane_Camera2, BlobPlane_Camera3, BlobPlane_Camera4; 

int FrameFrac = -6;

extern int ExportTGA;

// ------------------------------------------------------------------------------------------------

  #define INTERP 8
  BYTE BlobPlane_Table[16][10] =
    {{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80  },
      { 0x00, 0x01|INTERP, 0x02|INTERP, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
      { 0x01, 0x13|INTERP, 0x01|INTERP, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
      { 0x00, 0x13|INTERP, 0x02|INTERP, 0x01, 0x13|INTERP, 0x00, 0x80, 0x80, 0x80, 0x80 },
      { 0x02, 0x02|INTERP, 0x23|INTERP, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
      { 0x00, 0x01|INTERP, 0x02, 0x02, 0x01|INTERP, 0x23|INTERP, 0x80, 0x80, 0x80, 0x80 },
      { 0x02, 0x02|INTERP, 0x23|INTERP, 0x01, 0x13|INTERP, 0x01|INTERP, 0x80, 0x80, 0x80, 0x80 },
      { 0x01, 0x13|INTERP, 0x00, 0x00, 0x13|INTERP, 0x23|INTERP, 0x00, 0x23|INTERP, 0x02, 0x80 },
      { 0x03, 0x23|INTERP, 0x13|INTERP, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
      { 0x00, 0x01|INTERP, 0x02|INTERP, 0x03, 0x23|INTERP, 0x13|INTERP, 0x80, 0x80, 0x80, 0x80 },
      { 0x03, 0x23|INTERP, 0x01, 0x01, 0x23|INTERP, 0x01|INTERP, 0x80, 0x80, 0x80, 0x80 },
      { 0x01, 0x02|INTERP, 0x00, 0x01, 0x23|INTERP, 0x02|INTERP, 0x03, 0x23|INTERP, 0x01, 0x80 },
      { 0x02, 0x02|INTERP, 0x03, 0x03, 0x02|INTERP, 0x13|INTERP, 0x80, 0x80, 0x80, 0x80 },
      { 0x00, 0x01|INTERP, 0x02, 0x02, 0x01|INTERP, 0x13|INTERP, 0x02, 0x13|INTERP, 0x03, 0x80 },
      { 0x02, 0x02|INTERP, 0x03, 0x03, 0x02|INTERP, 0x01|INTERP, 0x03, 0x01|INTERP, 0x01, 0x80 },
      { 0x00, 0x01, 0x02, 0x01, 0x03, 0x02, 0x80, 0x80, 0x80, 0x80 }};
  #undef INTERP

float V1, V2, W, BlobIso = 0.5f;
int Idx, BlobFlags = 0;

// ------------------------------------------------------------------------------------------------

int BlobPlane_Initialize( void )
  {
    int I, J;

    // Create VertexBuffer1 (Static Part).
    if ( Direct3DDevice->CreateVertexBuffer( 10 * sizeof( BLOBPLANE_VERTEX1 ), 0, D3DFVF_BLOBPLANE_VERTEX1,
      D3DPOOL_DEFAULT, &BlobPlane_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( BlobPlane_VertexBuffer1->Lock( 0, 10 * sizeof( BLOBPLANE_VERTEX1 ), (BYTE**) &BlobPlane_Vertex1, 0 ) != D3D_OK ) return 0;
    for ( I=0; I<10; I++ )
      BlobPlane_Vertex1[ I ] = BlobPlane_ConstVertex1[ I ];
    BlobPlane_VertexBuffer1->Unlock();

    // --- Create VertexBuffer2 (Dynamic Part).
    if ( Direct3DDevice->CreateVertexBuffer(( 33*33 + 1024 ) * sizeof( BLOBPLANE_VERTEX1 ), 0, D3DFVF_BLOBPLANE_VERTEX1,
      D3DPOOL_DEFAULT, &BlobPlane_VertexBuffer2 ) != D3D_OK ) return 0;
    if ( BlobPlane_VertexBuffer2->Lock( 0, 33*33 * sizeof( BLOBPLANE_VERTEX1 ), (BYTE**) &BlobPlane_Vertex1, 0 ) != D3D_OK ) return 0;
    for ( J=0; J<33; J++ )
      for ( I=0; I<33; I++ )
        {
          BlobPlane_ConstVertex1[0].Vertex.x = (float) ( I - 16 ) / 16.0f;
          BlobPlane_ConstVertex1[0].Vertex.y = (float) ( J - 16 ) / 16.0f;
          BlobPlane_ConstVertex1[0].TexU1 = (float) ( I - 16 ) / 32.0f;
          BlobPlane_ConstVertex1[0].TexV1 = (float) ( J - 16 ) / 32.0f;
          BlobPlane_Vertex1[ J*33+I ] = BlobPlane_ConstVertex1[ 0 ];
         }
    BlobPlane_VertexBuffer2->Unlock();

    // --- Create IndexBuffer2 (Dynamic Part).
    if ( Direct3DDevice->CreateIndexBuffer( 16384 * sizeof( WORD ), D3DUSAGE_WRITEONLY, D3DFMT_INDEX16, 
      D3DPOOL_DEFAULT, &BlobPlane_IndexBuffer2 ) != D3D_OK ) return 0;

    // --- Initialize Blob Consts.
    RandSeed = 0x808;
    for ( I=0; I<16; I++ )
      for ( J=0; J<4; J++ )
        {
          BlobPlane_Const[I][J].x = (float) ( Rand() % 1024 ) / 1024.0f;
          BlobPlane_Const[I][J].y = (float) ( Rand() % 1024 ) / 1024.0f;
          BlobPlane_Const[I][J].z = (float) ( Rand() % 1024 ) / 1024.0f;
         }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &BlobPlane_Texture1 );
    if ( !TxGen_LoadTGA( BlobPlane_Texture1, "Dreams01.tga" ))
      {
        TxLayer1 = TxGen_LayerInitialize( 512, 512 );
        TxLayer2 = TxGen_LayerInitialize( 512, 512 );

        TxGen_SubPlasma( TxLayer1, 0x1D3C41, 0x667F83, 30, 5 );
        TxGen_DistortSine( TxLayer1, 3, 0, 37, 4, 0, 29 );
        TxGen_SubPlasma( TxLayer2, 0x1D3C41, 0x566F73, 31, 21 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 20, TXGEN_BLEND_NORMAL );
        TxGen_Cells( TxLayer2, 0x628BC0, 0x000000, 234, 100, 80 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 80, TXGEN_BLEND_MULTIPLY );

        TxGen_SetTexture( BlobPlane_Texture1, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams01.tga" );
        TxGen_LayerCleanup( TxLayer1 );
        TxGen_LayerCleanup( TxLayer2 );
       }

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void BlobPlane_Render( float Time )
  {
    int I, J, X, Y, Xadd1, Xadd2, Yadd1, Yadd2, Fr;
    float X1, Y1, DX, DY, R2, W, Ft, Lit;

    // --- Setup Material.
    memclear( &BlobPlane_Material1, sizeof( D3DMATERIAL8 ));
    BlobPlane_Material1.Diffuse.r = BlobPlane_Material1.Ambient.r = 1.0f;
    BlobPlane_Material1.Diffuse.g = BlobPlane_Material1.Ambient.g = 1.0f;
    BlobPlane_Material1.Diffuse.b = BlobPlane_Material1.Ambient.b = 1.0f;
    Direct3DDevice->SetMaterial( &BlobPlane_Material1 );

    // --- Setup Light.
    memclear( &BlobPlane_Light1, sizeof( D3DLIGHT8 ));
    BlobPlane_Light1.Type = D3DLIGHT_DIRECTIONAL;
    BlobPlane_Light1.Diffuse.r = BlobPlane_Light1.Diffuse.g = BlobPlane_Light1.Diffuse.b = 1.0f;
    D3DUVec3Create( &BlobPlane_Light1.Direction, 0.1f, 0.2f, -0.975f );
    Direct3DDevice->SetLight( 0, &BlobPlane_Light1 );
    Direct3DDevice->LightEnable( 0, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00000000 );
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, TRUE );

    // --- Setup Textures.
    Direct3DDevice->SetTexture( 0, BlobPlane_Texture1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

    Direct3DDevice->SetVertexShader( D3DFVF_BLOBPLANE_VERTEX1 );

    // --- Setup View Matrix.
    Ft = Frac( Time );

    Fr = Fround( Time - 1.5f );
    W = ( 1.0f - Ft ) * Fsqr( 1.0f - Ft ) / 6.0f;
    D3DUVec3Create( &BlobPlane_Camera1,
      1.3f * ( BlobPlane_Const[Fr&15][0].x - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].y + BlobPlane_Const[Fr&15][0].z * Time ),
      1.3f * ( BlobPlane_Const[Fr&15][0].y - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].z + BlobPlane_Const[Fr&15][0].x * Time ), -1.0f );
    D3DUVec3Scale( &BlobPlane_Camera1, &BlobPlane_Camera1, W );
    
    Fr++;
    W = ( 1.0f + 3.0f * ( 1.0f - Ft ) + 3.0f * Ft * Fsqr( 1.0f - Ft )) / 6.0f;
    D3DUVec3Create( &BlobPlane_Camera2,
      1.3f * ( BlobPlane_Const[Fr&15][0].x - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].y + BlobPlane_Const[Fr&15][0].z * Time ),
      1.3f * ( BlobPlane_Const[Fr&15][0].y - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].z + BlobPlane_Const[Fr&15][0].x * Time ), -1.0f );
    D3DUVec3Scale( &BlobPlane_Camera2, &BlobPlane_Camera2, W );

    Fr++;
    W = ( 1.0f + 3.0f * Ft + 3.0f * ( 1.0f - Ft ) * Fsqr( Ft )) / 6.0f;
    D3DUVec3Create( &BlobPlane_Camera3,
      1.3f * ( BlobPlane_Const[Fr&15][0].x - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].y + BlobPlane_Const[Fr&15][0].z * Time ),
      1.3f * ( BlobPlane_Const[Fr&15][0].y - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].z + BlobPlane_Const[Fr&15][0].x * Time ), -1.0f );
    D3DUVec3Scale( &BlobPlane_Camera3, &BlobPlane_Camera3, W );

    Fr++;
    W = ( Ft * Fsqr( Ft )) / 6.0f;
    D3DUVec3Create( &BlobPlane_Camera4,
      1.3f * ( BlobPlane_Const[Fr&15][0].x - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].y + BlobPlane_Const[Fr&15][0].z * Time ),
      1.3f * ( BlobPlane_Const[Fr&15][0].y - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][0].z + BlobPlane_Const[Fr&15][0].x * Time ), -1.0f );
    D3DUVec3Scale( &BlobPlane_Camera4, &BlobPlane_Camera4, W );

    D3DUVec3Add( &D3DVector_CameraPosition, &BlobPlane_Camera1, &BlobPlane_Camera2 );
    D3DUVec3Add( &D3DVector_CameraPosition, &D3DVector_CameraPosition, &BlobPlane_Camera3 );
    D3DUVec3Add( &D3DVector_CameraPosition, &D3DVector_CameraPosition, &BlobPlane_Camera4 );

    D3DUVec3Create( &D3DVector_CameraTarget, Fsin( Time * 1.0f ), Fcos( Time * 0.9f ), Fsin( Time * 0.8f ) + 2.3f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    // --- Setup Projection Matrix.
    D3DUMatrixPerspectiveFovLH( &D3DMatrix_Projection, D3DU_PI * 0.4f, 1.778f, 0.1f, 1000.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    // --- Setup Texture Matrix.
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DUMatrixIdentity );
    
    for ( I=0; I<4; I++ )
      if (( Fround( Time+0.5f ) + I < 299 ) && ( Fround( Time+0.5f ) + I > 289 ))
      {
// odbc32.lib odbccp32.lib

        Lit = 1.0f - (float) ( I - Frac( Time ))/ 3.0f;
        if ( Lit > 1.0f ) Lit = 1.0f;
        if ( Lit < 0.0f ) Lit = 0.0f;

        BlobPlane_Light1.Diffuse.r = BlobPlane_Light1.Diffuse.g = BlobPlane_Light1.Diffuse.b = Lit;
        Direct3DDevice->SetLight( 0, &BlobPlane_Light1 );
        Direct3DDevice->LightEnable( 0, TRUE );

        // --- Setup World Matrix.
        D3DUMatrixTranslation( &D3DMatrix_World0, 0.0f, 0.0f, I - 1.0f - Frac( Time ));
        D3DUMatrixRotationZ( &D3DMatrix_World1, ( I - Frac( Time )) / 2.0f );
        D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_World1 );
        Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
    
        // --- Setup Backface Culling.
        Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE ); // D3DCULL_CW
        
        // --- Render (Static Part).
        Direct3DDevice->SetStreamSource( 0, BlobPlane_VertexBuffer1, sizeof( BLOBPLANE_VERTEX1 ));
        Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 8 );

        // --- Calculate BlobField.
        Fr = Fround( Ftrunc( Time )) + I;
        for ( X=0; X<=32; X++ )
          for ( Y=0; Y<=32; Y++ )
            {
              X1 = (float) X * 0.0625f - 1.0f;
              Y1 = (float) Y * 0.0625f - 1.0f;

              BlobPlane_Field[X][Y] = 0.0f;
              for ( J=0; J<4; J++ )
                { 
                  DX = X1 - 1.3f * ( BlobPlane_Const[Fr&15][J].x - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][J].y + BlobPlane_Const[Fr&15][J].z * 1.4f * Time );
                  DY = Y1 - 1.3f * ( BlobPlane_Const[Fr&15][J].y - 0.5f ) * Fsin( BlobPlane_Const[Fr&15][J].z + BlobPlane_Const[Fr&15][J].x * 1.4f * Time );
                  
                  R2 = Fsqr( DX ) + Fsqr( DY );
                  if ( R2 < 0.25f ) 
                    BlobPlane_Field[X][Y] += 1.4f * Fsqr( 1.0f - R2 / Fsqr( 0.5f ));
                 }
             }
//*        
        if ( BlobPlane_VertexBuffer2->Lock( 0, ( 33*33 + 1024 ) * sizeof( BLOBPLANE_VERTEX1 ), (BYTE**) &BlobPlane_Vertex1, 0 ) != D3D_OK ) return;
        BlobPlane_VertexIdx2 = 33*33;
        if ( BlobPlane_IndexBuffer2->Lock( 0, 32*32*6 * sizeof( WORD ), (BYTE**) &BlobPlane_Index2, 0 ) != D3D_OK ) return;
        BlobPlane_IndexIdx2 = 0;

        for ( X=0; X<32; X++ )
          for ( Y=0; Y<32; Y++ )
            {
              BlobFlags = ( BlobPlane_Field[X][Y] < BlobIso ) ? 1 : 0;
              BlobFlags |= ( BlobPlane_Field[X+1][Y] < BlobIso ) ? 2 : 0;
              BlobFlags |= ( BlobPlane_Field[X][Y+1] < BlobIso ) ? 4 : 0;
              BlobFlags |= ( BlobPlane_Field[X+1][Y+1] < BlobIso ) ? 8 : 0;

              J = 0;          
              while ( BlobPlane_Table[ BlobFlags ][ J ] != 0x80 )
                {
                  if ( !( BlobPlane_Table[ BlobFlags ][ J+1 ] & 0x08 ))
                    {
                      // Vertex1.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;
                      // Vertex2.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;
                      // Vertex3.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;
                     } else
                  if ( BlobPlane_Table[ BlobFlags ][ J+2 ] & 0x08 )
                    {
                      // Vertex1.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;

                      // Vertex2 (Interpolate).
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );

                          Xadd2 = X + (( Idx >> 4 ) & 0x01 );
                          Yadd2 = Y + (( Idx >> 5 ) & 0x01 );

                          V1 = BlobPlane_Field[ Xadd1 ][ Yadd1 ];
                          V2 = BlobPlane_Field[ Xadd2 ][ Yadd2 ];
                          W = ( BlobIso - V2) / ( V1 - V2 );

                          BlobPlane_ConstVertex1[ 0 ].Vertex.x = ( W * (( (float) Xadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Xadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexU1 = BlobPlane_ConstVertex1[ 0 ].Vertex.x * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.y = ( W * (( (float) Yadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Yadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexV1 = BlobPlane_ConstVertex1[ 0 ].Vertex.y * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.z = -0.1f;

                          BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2;
                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];

                          BlobPlane_ConstVertex1[ 0 ].Diffuse = 0xA0A0A0;
                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];

                          BlobPlane_ConstVertex1[ 0 ].Vertex.z = 0.1f;

                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];
                          BlobPlane_ConstVertex1[ 0 ].Diffuse = 0xFFFFFF;

                      // Vertex3 (Interpolate).
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );

                          Xadd2 = X + (( Idx >> 4 ) & 0x01 );
                          Yadd2 = Y + (( Idx >> 5 ) & 0x01 );

                          V1 = BlobPlane_Field[ Xadd1 ][ Yadd1 ];
                          V2 = BlobPlane_Field[ Xadd2 ][ Yadd2 ];
                          W = ( BlobIso - V2) / ( V1 - V2 );

                          BlobPlane_ConstVertex1[ 0 ].Vertex.x = ( W * (( (float) Xadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Xadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexU1 = BlobPlane_ConstVertex1[ 0 ].Vertex.x * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.y = ( W * (( (float) Yadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Yadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexV1 = BlobPlane_ConstVertex1[ 0 ].Vertex.y * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.z = -0.1f;

                          BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2;
                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];

                          BlobPlane_ConstVertex1[ 0 ].Diffuse = 0xA0A0A0;
                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];

                          BlobPlane_ConstVertex1[ 0 ].Vertex.z = 0.1f;

                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];
                          BlobPlane_ConstVertex1[ 0 ].Diffuse = 0xFFFFFF;


                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-5;
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-4;
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-2;

                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-2;
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-4;
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2-1;

                     } else
                    {
                      // Vertex1.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;

                      // Vertex2 (Interpolate).
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );

                          Xadd2 = X + (( Idx >> 4 ) & 0x01 );
                          Yadd2 = Y + (( Idx >> 5 ) & 0x01 );

                          V1 = BlobPlane_Field[ Xadd1 ][ Yadd1 ];
                          V2 = BlobPlane_Field[ Xadd2 ][ Yadd2 ];
                          W = ( BlobIso - V2) / ( V1 - V2 );

                          BlobPlane_ConstVertex1[ 0 ].Vertex.x = ( W * (( (float) Xadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Xadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexU1 = BlobPlane_ConstVertex1[ 0 ].Vertex.x * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.y = ( W * (( (float) Yadd1 - 16.0f )) + ( 1.0f - W ) * ( (float) Yadd2 - 16.0f )) * 0.0625f;
                          BlobPlane_ConstVertex1[ 0 ].TexV1 = BlobPlane_ConstVertex1[ 0 ].Vertex.y * 0.5f;

                          BlobPlane_ConstVertex1[ 0 ].Vertex.z = -0.1f;

                          BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = BlobPlane_VertexIdx2;
                          BlobPlane_Vertex1[ BlobPlane_VertexIdx2++ ] = BlobPlane_ConstVertex1[ 0 ];

                      // Vertex3.
                      Idx = BlobPlane_Table[ BlobFlags ][ J++ ];
                      Xadd1 = X + ( Idx & 0x01 );
                      Yadd1 = Y + (( Idx >> 1 ) & 0x01 );
                      BlobPlane_Index2[ BlobPlane_IndexIdx2++ ] = Yadd1 * 33 + Xadd1;
                     }           
                 }
             }

        BlobPlane_IndexBuffer2->Unlock();
        BlobPlane_VertexBuffer2->Unlock();
//*
        // --- Render (Dynamic Part).
        Direct3DDevice->SetStreamSource( 0, BlobPlane_VertexBuffer2, sizeof( BLOBPLANE_VERTEX1 ));
        Direct3DDevice->SetIndices( BlobPlane_IndexBuffer2, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, BlobPlane_VertexIdx2, 0, BlobPlane_IndexIdx2/3 );
//*/
/*
        // --- Z-Flip World Matrix.
        D3DUMatrixScaling( &D3DMatrix_World1, 1.0f, 1.0f, -1.0f );
        D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_World1 );
        Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );

        // --- Setup Backface Culling.
        Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE ); // D3DCULL_CCW

        // --- Render (Static Part).
        Direct3DDevice->SetStreamSource( 0, BlobPlane_VertexBuffer1, sizeof( BLOBPLANE_VERTEX1 ));
        Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 8 );

        // --- Render (Dynamic Part).
        Direct3DDevice->SetStreamSource( 0, BlobPlane_VertexBuffer2, sizeof( BLOBPLANE_VERTEX1 ));
        Direct3DDevice->SetIndices( BlobPlane_IndexBuffer2, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, BlobPlane_VertexIdx2, 0, BlobPlane_IndexIdx2/3 );
//*/
       }

    Direct3DDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );
    Direct3DDevice->LightEnable( 0, FALSE );
   }

// ------------------------------------------------------------------------------------------------

void BlobPlane_Cleanup( void )
  {
    if ( BlobPlane_VertexBuffer1 != NULL ) BlobPlane_VertexBuffer1->Release();
    if ( BlobPlane_VertexBuffer2 != NULL ) BlobPlane_VertexBuffer2->Release();
    if ( BlobPlane_IndexBuffer2 != NULL ) BlobPlane_IndexBuffer2->Release();
   }