
#include <D3D8.h>
#include "D3DU8.h"

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "Rand.h"

#define D3DFVF_LOGO_VERTEX1 (D3DFVF_XYZ|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2)
typedef struct _LOGO_VERTEX1
  {
    D3DVECTOR Vertex;
    FLOAT TexU, TexV;
   } LOGO_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 Logo_VertexBuffer1 = NULL;
LOGO_VERTEX1 *Logo_LockedVertexBuffer1, Logo_ConstVertex1[] =
  {{{ -200.0f, 266.0f, 0.5f }, 1.0f, 1.0f },
    {{ 312.0f, 266.0f, 0.5f }, 0.0f, 1.0f },
    {{ -200.0f, 394.0f, 0.5f }, 1.0f, 0.0f },
    {{ 312.0f, 394.0f, 0.5f }, 0.0f, 0.0f }};

LPDIRECT3DTEXTURE8 Logo_Texture1 = NULL, Logo_Texture2 = NULL;

TXGEN_LAYER *TxLayer1;

extern "C" BYTE EnokLogo1[27664], EnokLogo2[27664];

// ------------------------------------------------------------------------------------------------

int Logo_Initialize( void )
  {
    int I, J;

    if ( Direct3DDevice->CreateVertexBuffer( 4 * sizeof( LOGO_VERTEX1 ), 0, D3DFVF_LOGO_VERTEX1, 
      D3DPOOL_DEFAULT, &Logo_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( Logo_VertexBuffer1->Lock( 0, 4 * sizeof( LOGO_VERTEX1 ), (BYTE**) &Logo_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    memcopy( (void*) Logo_LockedVertexBuffer1, Logo_ConstVertex1, 4 * sizeof( LOGO_VERTEX1 ));

    Logo_VertexBuffer1->Unlock();    

    Direct3DDevice->CreateTexture( 512, 128, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Logo_Texture1 );

    TxLayer1 = TxGen_LayerInitialize( 512, 128 );
    for ( J=0; J<104; J++ )
      for ( I=0; I<266; I++ )
        TxLayer1->Ptr[ J * TxLayer1->Width + I ] = 0x010101 * (DWORD) EnokLogo1[ J * 266 + I ];
    TxGen_SetTexture( Logo_Texture1, TxLayer1 );    
    TxGen_LayerCleanup( TxLayer1 );

    Direct3DDevice->CreateTexture( 512, 128, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Logo_Texture2 );

    TxLayer1 = TxGen_LayerInitialize( 512, 128 );
    for ( J=0; J<104; J++ )
      for ( I=0; I<266; I++ )
        TxLayer1->Ptr[ J * TxLayer1->Width + I ] = 0x010101 * (DWORD) EnokLogo2[ J * 266 + I ];
    TxGen_SetTexture( Logo_Texture2, TxLayer1 );    
    TxGen_LayerCleanup( TxLayer1 );

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void Logo_Cleanup( void )
  {
    if ( Logo_VertexBuffer1 ) Logo_VertexBuffer1->Release();
    if ( Logo_Texture1 ) Logo_Texture1->Release();
    if ( Logo_Texture2 ) Logo_Texture2->Release();
   }

// ------------------------------------------------------------------------------------------------

void Logo_Render( float Time )
  {
    float Light;

    Light = 0.3f * ( 1.0f - Fcos( Time / 192.0f * Fmath_2Pi ));

    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));
//  Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x808080 );

    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DUMatrixIdentity );

    Direct3DDevice->SetTexture( 0, Logo_Texture1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TFACTOR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_POINT );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_POINT );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetVertexShader( D3DFVF_LOGO_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x000000 );
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, FALSE );

    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetStreamSource( 0, Logo_VertexBuffer1, sizeof( LOGO_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

    Light = Light * 0.3f + 0.15f * ( 1.0f  - Fcos( Time / 96.0f * Fmath_2Pi ));

    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 160.0f * Light ));
    Direct3DDevice->SetTexture( 0, Logo_Texture2 );
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

   }