
#include "defines.h"
#include "player.h"

#include <stdlib.h>
#include <math.h>

#include <ApplicationServices/ApplicationServices.h>
#include <OpenGL/OpenGL.h>
#include <OpenGL/glu.h>
#define deprecated // we don't want the deprecated warning about AudioDeviceAddIOProc
#include <CoreAudio/CoreAudio.h>
#undef deprecated
#include <Carbon/Carbon.h>


static int keyTest();
static OSStatus audioCallback(AudioDeviceID inDevice, const AudioTimeStamp *inNow, const AudioBufferList *inInputData, const AudioTimeStamp *inInputTime, AudioBufferList *outOutputData, const AudioTimeStamp *inOutputTime, void *appGlobals);

static CGLPixelFormatAttribute attribs[] = {
	kCGLPFADoubleBuffer,
	kCGLPFAFullScreen,
	kCGLPFADisplayMask, kCGNullDirectDisplay,
	0 };


static unsigned int audioChannels;
static unsigned int samplePosition = 0;


// Setup of the Projection Matrix and return 
// to the ModelView matrix
void matriuProjeccio (float fov)
{
	glMatrixMode	(GL_PROJECTION);
	glLoadIdentity	();
	gluPerspective	(fov, (float)w_screen/(float)h_screen, 0.05f, 100.0f);
	glMatrixMode	(GL_MODELVIEW);
}

// Reduced version of the gluLookAt
void gluLookAt_ (float eyex, float eyey, float eyez, float centery)
{
	gluLookAt (eyex, eyey, eyez, 0.0f, centery, 0.0f, 0.0f, 1.0f, 0.0f);
}

int et=0;
int etf=0;

void drawNgon (int n, float rmin, float rmax)
{
	float steps = (2*PI)/n;
	float angle = steps/2.0f;


	float x[4];
	float y[4];

	glBegin(GL_QUADS);

	for (int i=0; i<n; i++)
	{
		x[0] = rmin * cosf (angle);
		y[0] = rmin * sinf (angle);
		x[1] = rmax * cosf (angle);
		y[1] = rmax * sinf (angle);
		angle += steps;
		x[2] = rmax * cosf (angle);
		y[2] = rmax * sinf (angle);
		x[3] = rmin * cosf (angle);
		y[3] = rmin * sinf (angle);
		
		glVertex3f(x[0],y[0], 0);
		glVertex3f(x[1],y[1], 0);
		glVertex3f(x[2],y[2], 0);
		glVertex3f(x[3],y[3], 0);
	}
	glEnd();

}


void drawJuanolaNgon (float size, int n, float rmin, float rmax)
{
	glPushMatrix();
	for (int i=0; i<4; i++)
	{
		glRotatef(et/8*PI, 1, 1, 0);
		glPushMatrix();
		glTranslatef(size, 0, 0);
		glRotatef(n/2*PI, 1, 1, 0);
		drawNgon(n, rmin, rmax);
		glPopMatrix();
		glRotatef(90, 0, 1, 0);
	}
	glRotatef(90, 0, 0, 1);
	drawNgon(n, rmin, rmax);
	glRotatef(180, 0, 0, 1);
	drawNgon(n, rmin, rmax);

	glPopMatrix();
}

void drawCubeNgon (float size, int n, float rmin, float rmax)
{
	glPushMatrix();
	for (int i=0; i<4; i++)
	{
		glPushMatrix();
		glTranslatef(0, 0, size);
		drawNgon(n, rmin, rmax);
		glPopMatrix();
		glRotatef(90, 0, 1, 0);
	}
	glRotatef(90, 1, 0, 0);
	glPushMatrix();
	glTranslatef(0, 0, size);
	drawNgon(n, rmin, rmax);
	glPopMatrix();
	glRotatef(180, 1, 0, 0);
	glPushMatrix();
	glTranslatef(0, 0, size);
	drawNgon(n, rmin, rmax);
	glPopMatrix();

	glPopMatrix();
}

void drawMosca(int n) {
	glPushMatrix();
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glScalef(0.2f,0.2f,0.2f);
	glRotatef(et/5.0f,1,1,1);
	drawCubeNgon(1.5f,n,1,2);
	glPopMatrix();
}
void drawIcon() {
	glPushMatrix();
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glScalef(0.2f,0.2f,0.2f);
	glRotatef(et/5.0f,1,1,1);
	drawCubeNgon(0,6,1,2);
	glPopMatrix();
}

void drawScene1() {

	glPushMatrix();
	glRotatef(etf/10.0f,1,1,0);
	for (int i = 0; i < 4*10; ++i) {
		if ((i / 10) & 1 == 1)
			glScalef(1.1f, 1.1f, 1.1f);
		glColor4f(0, 0, 0, 1/(float)i);
		glRotatef(-1, 1, 1, 0);
		drawCubeNgon(1.5f,4,1,2);
	}
	glPopMatrix();
}


void drawScene2() {

	glPushMatrix();
		glPushMatrix();
			glColor4f(1,1,1,0.2f);
			glRotatef(3.6f*et/10.0f,0,1,5);
			drawJuanolaNgon(1,8, 1.5f, 5.0f);
		glPopMatrix();

		glTranslatef (0,0,et/40.0f);
			glColor4f(0, 0, 0, 0.7f);
 		for (int i = 0; i < 2*20; ++i) {
			glTranslatef(0,0,-4);
			glPushMatrix();
			glTranslatef(0.5f*sinf(i/PI),0.5f*cosf(i/PI),0);
			if (i&1)
				glRotatef(i*et/10.f, 0, 0, 1);
			else
				glRotatef(-i*et/10.f, 0, 0, 1);
			drawNgon(8,2,3);
			glPopMatrix();
		}
	glPopMatrix();
}


void drawParticles() {
	glPushMatrix();
	glTranslatef(2,-2,-8);
	glRotatef(90,1,0,0);
	for (int i = 0; i < 50; ++i) {
		for (int j = 0; j < 25; ++j) {
			glPushMatrix();
			glTranslatef(0.2f*i*2*cosf(j*2/(2*PI)), 0.2f*i*2*sinf(j*2/(2*PI)), 0.8f*sinf(0.01f*et+i/(2*PI)));
			drawIcon();
			glPopMatrix();
		}
	}
	glPopMatrix();
}


void drawEscenita() {
	int i;
	
	glPushMatrix();
	glTranslatef(0,0,-1);
	glScalef(0.15f, 0.15f, 0.15f);
	for (i=0; i<20; i++)
	{
		glColor4f(1.3f,1.3f,1.3f, 0.2f);
		glRotatef(10*cosf(sinf(et*0.004f)*5),1,0.33f,0);
		glRotatef(5*sinf(cosf(et*0.002f)*5),0,0.43f,1);
		drawCubeNgon(5*i/10.0f,4,4,5);

	}
	glPopMatrix();
	
	glPushMatrix();
	glTranslatef(0,0,-1);
	glScalef(0.145f, 0.145f, 0.145f);
	for (i=0; i<5; i++)
	{
		glColor4f(0,0,0, 0.2f);
		glRotatef(10*cosf(sinf(0.1f+et*0.004f)*5),1,0.33f,0);
		glRotatef(5*sinf(cosf(0.02f+et*0.002f)*5),0,0.43f,1);
		drawCubeNgon(5*i/5.0f,4,4,5);

	}
	glPopMatrix();
}

void inverse(float posX, float posY, float sizeX, float sizeY) {
	glBlendFunc(GL_ONE_MINUS_DST_COLOR, GL_ZERO);
	glColor3f(1,0,0);
	glPushMatrix();
	matriuProjeccio (90.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0,0,-1);
	glBegin(GL_QUADS);
	glVertex3f(posX,posY,0);
	glVertex3f(posX+sizeX,posY,0);
	glVertex3f(posX+sizeX,posY+sizeY,0);
	glVertex3f(posX,posY+sizeY,0);	
	glEnd();
	glPopMatrix();
}

// Synch and render of the whole intro
__inline void drawMain (s32 etime)
{
	glEnable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	int ietime = etime / 250;
	int iet = et / 250;

	if (iet>>1 != ietime>>1) {
		etf += 500;
	}
	if (etime>3500 && iet != ietime ) {
		etf += 150;
	}

	etf += etime - et;
	et = etime;
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	

	glPushMatrix();

	glClearColor(1,0,0,1);
	

	glColor3f(0,1,0);
	
	matriuProjeccio (90.0f);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();


	if (etime < 8000) {
		glTranslatef(0,0,-5);
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		drawScene1();
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		drawScene1();
	}
	else if (etime < 14000) {
		et -= 8000;
		glTranslatef(0,0,-5);
		drawScene2();
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		drawScene2();
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		et += 8000;
	}
	else if (etime < 20000) {
	// fondo
		glPushMatrix();
			matriuProjeccio (45.0f);
			glColor4f(1,1,0,0.43f);
			glRotatef(et*0.1f,0,1,0.23f);
			drawMosca(4);
		glPopMatrix();

		glTranslatef(0,0,-5);
		
		glColor4f(1,1,1,0.23f);
		drawParticles();
		glColor4f(0,0,0,0.13f);
		glRotatef(180, 0, 0, 1);
		drawParticles();
	}

	else if (etime < 24000) {
		glPushMatrix();
		//	matriuProjeccio (45.0f);
			glColor4f(1,1,0,0.43f);
			glRotatef(et*0.1f,0,1,0.23f);
			drawMosca(4);
		glPopMatrix(); 
		drawEscenita();
		inverse(-2.0f,0.7f,4,1.5f);
		inverse(-2.0f,0.7f,4,1.5f);
		inverse(-2.0f,-0.7f,4,-1.5f);
		inverse(-2.0f,-0.7f,4,-1.5f);
		//inverse(-1,-1,2,2);
		
	}



	// mosca
	glPushMatrix();
		matriuProjeccio (45.0f);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(0,0,-1);

		glScalef(0.1f, 0.1f, 0.1f);
		glTranslatef(-4.6f,3.5f,0);
		glColor4f(1.0,1.0,1.0,0.3f);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		if (etime < 8000) {
			drawMosca(3);
		} else if(etime < 14000) {
			drawMosca(4);
		} else if(etime < 20000) {
			drawMosca(5);
		} else if(etime < 24000) {
			drawMosca(6);
		}
	glPopMatrix();

	// Start rotating and fade from black
	if (etime < 5000)
	{
		glColor3f (etime/5000.0f, etime/5000.0f, etime/5000.0f);

		matriuProjeccio (90.0f - (45.0f*(etime/5000.0f)));

		gluLookAt_ (0,0,-10,0);
	}

	// We kill the 4k at the end
	if (etime>24000)
	{
		exit (0);
	}

	glPopMatrix		();
}

int main()
{
    // Video setup
    CGCaptureAllDisplays();
    CGDisplayHideCursor(kCGNullDirectDisplay);
    
    CGLPixelFormatObj pixelFormatObj;
    GLint numPixelFormats;
    attribs[3] = CGDisplayIDToOpenGLDisplayMask(CGMainDisplayID());
    CGLChoosePixelFormat( attribs, &pixelFormatObj, &numPixelFormats );
    
    CGLContextObj openglContext;
    CGLCreateContext( pixelFormatObj, NULL, &openglContext );
	CGLSetCurrentContext( openglContext );
	CGLSetFullScreen( openglContext );
	
	// Enable vsync
	GLint swapInterval = 1;
	CGLSetParameter(openglContext, kCGLCPSwapInterval, &swapInterval); 
	
	// Init song
	initPlayer ();

	// Audio setup
    unsigned long count;
    AudioDeviceID device;
    
    AudioStreamBasicDescription	deviceFormat;
    count = sizeof(device);
	AudioHardwareGetProperty(kAudioHardwarePropertyDefaultOutputDevice, &count, &device);
	count = sizeof(deviceFormat);
	AudioDeviceGetProperty(device, 0, false, kAudioDevicePropertyStreamFormat, &count, &deviceFormat);
	deviceFormat.mSampleRate = 44100;
	audioChannels = deviceFormat.mChannelsPerFrame;
	AudioDeviceSetProperty(device, 0,  0, false, kAudioDevicePropertyStreamFormat, count, &deviceFormat);
	AudioDeviceAddIOProc(device, audioCallback, NULL);
	AudioDeviceStart(device, audioCallback);
	
	// Main loop
	while(true)
	{
	    if(keyTest())
            exit(0);
		
        float time = samplePosition/44100.0;
    
		// Draw everything at "slow" pace
		drawMain (time*500);

		CGLFlushDrawable(openglContext);
	}
}


int keyTest()
{
	KeyMap pressedKeys;
	GetKeys(pressedKeys);
    return ((unsigned int*)pressedKeys)[1] & 0x00200000; // test for escape
}

OSStatus audioCallback(AudioDeviceID inDevice, const AudioTimeStamp *inNow, const AudioBufferList *inInputData, const AudioTimeStamp *inInputTime, AudioBufferList *outOutputData, const AudioTimeStamp *inOutputTime, void *appGlobals)
{
    float sample;
	float *fillBuffer = (float*)outOutputData->mBuffers[0].mData;
	unsigned int size = outOutputData->mBuffers[0].mDataByteSize / audioChannels / sizeof(float);

	for(unsigned int i = 0; i < size; i++)
    {
		if (samplePosition<(NUMSAMPLES*NUMLOOPS*2))
			sample = datawave[samplePosition];
		else
			sample = 0.0;
        for(unsigned int c = 0; c < audioChannels; c++)
            *(fillBuffer++) = sample;
		samplePosition++;
    }
	return 0;
}

