#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

uniform float time;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec3 wpos;
out vec3 uv_shade;

void main()
{
	wpos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	//uv_shade.xy = TEXCOORD;
	uv_shade.x = 1.0 - TEXCOORD.x;
	uv_shade.y = TEXCOORD.y;
	uv_shade.z = max(1.0 - ((POSITION.y - .05) / 3.2), 0.0);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
