#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec3 wpos;
out vec2 uv;

void main()
{
	wpos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
