
sampler s0 : register(s0);
sampler s1 : register(s1);
sampler s2 : register(s2);
sampler s3 : register(s3);
sampler s4 : register(s4);
sampler s5 : register(s5);
sampler s6 : register(s6);
sampler s7 : register(s7);

float4 one = {1,1,1,1};

float r_texdx_1 = 0;
float r_texdx_4 = 0;

float r_frame_dt = 0;

struct VS_TASK_INPUT
{
    float4 m_position		: POSITION;
    float2 m_texture		: TEXCOORD0;
};

float4 ntex(sampler s, float2 t)
{
	return tex2Dlod(s, float4(t, 0, 0));
}

float4 stex(sampler s, float2 t)
{
	return tex2Dlod(s, float4(t, 0, 0));
/*	
	float2 tc = float2(0,0);
	
	if (t.x > -1)
	{
		tc.x = t.x + 0.0001;
		if (t.y > -1)
		{
			tc.y = t.y + 0.0001;

			return tex2Dlod(s, float4(tc, 0, 0));
		}
		else
			return float4(0, 0, 0, 0);
	}
	else
		return float4(0, 0, 0, 0);*/
		
}

VS_TASK_INPUT task_vs(const VS_TASK_INPUT v)
{
    VS_TASK_INPUT o = (VS_TASK_INPUT) 0;

	o.m_position = float4(v.m_position.xy, 0.5, 1.0);
    o.m_texture  = float4(v.m_texture, v.m_position.xy);
  
    return o;
}

////////////////////////////////////////////////////////////////////////////
// bbox calculation
////////////////////////////////////////////////////////////////////////////

float4 groups_bb_min_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 group_address = tex2D(s0, t);
	float4 group_header = tex2D(s1, group_address.xy);
	
	float4 result = float4(100000.0f, 100000.0f, 100000.0f, 100000.0f);
	
	float last_pos_x = group_header.y * r_texdx_1 + group_header.w;
	[loop] for (float pos_x = group_header.w; pos_x < last_pos_x - 0.01 * r_texdx_1; pos_x = pos_x + r_texdx_1)
	{
		float4 pos_address = tex2Dlod(s1, float4(pos_x, group_address.y, 0, 0));
		float4 pos = tex2Dlod(s2, float4(pos_address.xy, 0, 0));
		
		result = min(result, pos);
	}
	
	return result;
}

technique groups_bb_min_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_bb_min_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}


float4 groups_bb_max_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 group_address = tex2D(s0, t);
	float4 group_header = tex2D(s1, group_address.xy);
	
	float4 result = -float4(100000.0f, 100000.0f, 100000.0f, 100000.0f);
	
	float last_pos_x = group_header.y * r_texdx_1 + group_header.w;
	[loop] for (float pos_x = group_header.w; pos_x < last_pos_x - 0.01 * r_texdx_1; pos_x = pos_x + r_texdx_1)
	{
		float4 pos_address = tex2Dlod(s1, float4(pos_x, group_address.y, 0, 0));
		float4 pos = tex2Dlod(s2, float4(pos_address.xy, 0, 0));
		
		result = max(result, pos);
	}
	
	return result;
}

technique groups_bb_max_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_bb_max_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// groups bbox collisions
////////////////////////////////////////////////////////////////////////////

float test_intersection(float s1, float e1, float s2, float e2)
{
	float lmax = (e1 - s1) + (e2 - s2);
	
	float smin = min(s1, s2);
	float emax = max(e1, e2);
	float l = emax - smin;

	return lmax - l;
}

bool test_bbox_intersection(float4 bbmin1, float4 bbmax1, float4 bbmin2, float4 bbmax2)
{
	if (test_intersection(bbmin1.x, bbmax1.x, bbmin2.x, bbmax2.x) < 0)
	{
		return false;
	}
	
	if (test_intersection(bbmin1.y, bbmax1.y, bbmin2.y, bbmax2.y) < 0)
	{
		return false;
	}
	
	if (test_intersection(bbmin1.z, bbmax1.z, bbmin2.z, bbmax2.z) < 0)
	{
		return false;
	}
	
	return true;
}

float4 groups_collision_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 pair = tex2D(s0, t);
	
	float4 ret = float4(1,1,1,1);
		
	if (any(pair - float4(0.99, 0.99, 0.99, 0.99)))
	{
		float4 bbmin1 = tex2D(s1, pair.xy);
		float4 bbmin2 = tex2D(s1, pair.zw);
		float4 bbmax1 = tex2D(s2, pair.xy);
		float4 bbmax2 = tex2D(s2, pair.zw);
		
		if (test_intersection(bbmin1.x, bbmax1.x, bbmin2.x, bbmax2.x) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
		
		if (test_intersection(bbmin1.y, bbmax1.y, bbmin2.y, bbmax2.y) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
		
		if (test_intersection(bbmin1.z, bbmax1.z, bbmin2.z, bbmax2.z) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
	}
	
	return  ret;
}

technique groups_collision_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_collision_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// groups bbox collisions
////////////////////////////////////////////////////////////////////////////

float4 get_point(float4 a, float4 b, float4 n)
{
	float t = (n.w - dot(a.xyz, n.xyz)) / dot(b.xyz - a.xyz, n.xyz);
	
	return float4((a + t*(b-a)).xyz, t);
}

bool test_range(float t)
{
	bool ret = true;
	
	if (t < 0.0002)
		ret = false;
		
	if (t > 0.9998)
		ret = false;

	return ret;
}

bool test_ranges(float a1, float b1, float a2, float b2)
{
	float d = b1 - a1;
	float t1 = (a2 - a1) / d;
	float t2 = (b2 - a1) / d;
	
	if (test_range(t1))
		return true;
		
	if (test_range(t2))
		return true;

	if ((t1 < 0.0002) == (t2 > 0.9998))
		return true;

	return false;
}

float r_skip_groups = 0;

float4 triangle_collision_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 header = tex2D(s0, t); //r0
	float4 ret = float4(0,0,0,0); //r1
	
	if (header.w < 0)
		return ret;
		
	float4 group_pair = stex(s1, header.xy); //r2
	float4 group_addr = stex(s3, float2(group_pair.xy)); //r3
	float4 group_header = stex(s4, group_addr.xy); //r4
	
	float4 tri_coord = float4(group_header.z + header.z * r_texdx_4, group_addr.y, 0, 0); // r5
	
	float4 trix = tex2D(s4, tri_coord.xy); //r6
	float4 triy = tex2D(s4, float2(tri_coord.x + r_texdx_4, tri_coord.y)); //r7
	
	float4 pos1a = tex2D(s5, float2(trix.x, triy.x)); //r8
	float4 pos1b = tex2D(s5, float2(trix.y, triy.y)); //r9
	float4 pos1c = tex2D(s5, float2(trix.z, triy.z)); //r10
	
	float4 norm1 = float4(cross(pos1a - pos1c, pos1b - pos1c), 0); //r11
	norm1.w = dot(pos1a.xyz, norm1.xyz);
	

	float4 tri_min = min(min(pos1a, pos1b), pos1c); //r12
	float4 tri_max = max(max(pos1a, pos1b), pos1c); //r13
	
	float to_skip = r_skip_groups;
	
	[loop] while(header.x < header.w)
	{
		[loop] while(header.x < header.w)
		{
			ret.w++;
			
			to_skip = to_skip - 1;
			if (stex(s2, header.xy).x > 0 && to_skip < 0)
			{
				group_addr = stex(s3, float2(group_pair.zw));
				
				group_header = float4(0,0,0,0);
				
				{
					float4 bb_min = tex2Dlod(s6, float4(group_pair.zw, 0, 0));
					float4 bb_max = tex2Dlod(s7, float4(group_pair.zw, 0, 0));
					
					if (test_bbox_intersection(bb_min, bb_max, tri_min, tri_max))
					{
						group_header = stex(s4, group_addr.xy);
					}
				}
				
				[loop] for (float tri2 = 0; tri2 < group_header.x; tri2 += 1)
				{
					tri_coord.zw = float2(group_header.z + tri2 * r_texdx_4 * 2, group_addr.y);
					
					if (any(tri_coord.zw - tri_coord.xy))
					{
						trix = stex(s4, tri_coord.zw); //r6
						triy = stex(s4, float2(tri_coord.z + r_texdx_4, tri_coord.w)); //r7

						float4 pos2a = stex(s5, float2(trix.x, triy.x)); //r14
						float4 pos2b = stex(s5, float2(trix.y, triy.y)); //r15
						float4 pos2c = stex(s5, float2(trix.z, triy.z)); //r16					
						
						float4 norm2 = float4(cross(pos2a - pos2b, pos2b - pos2c), 0);
						norm2.w = dot(pos2a.xyz, norm2.xyz);
						
						float4 ab1 = get_point(pos1a, pos1b, norm2);
						float4 ac1 = get_point(pos1a, pos1c, norm2);

						group_pair.x = 0;
						
						if (!test_range(ab1.w))
						{
							if (test_range(ac1.w))
							{
								ab1 = get_point(pos1c, pos1b, norm2);
								if (test_range(ab1.w))
								{
									group_pair.x = 1;
								}
							}
						}
						else if(!test_range(ac1.w))
						{
							ac1 = get_point(pos1c, pos1b, norm2);
							if (test_range(ac1.w))
								group_pair.x = 1; //ac1 && ab1 ok
						}
						else
						{
							group_pair.x = 1;
						}
							
						float4 ab2 = get_point(pos2a, pos2b, norm1);
						float4 ac2 = get_point(pos2a, pos2c, norm1);

						group_pair.y = 0;
						
						if (!test_range(ab2.w))
						{
							if (test_range(ac2.w))
							{
								ab2 = get_point(pos2c, pos2b, norm1);
								if (test_range(ab2.w))
								{
									group_pair.y = 1;
								}
							}
						}
						else if(!test_range(ac2.w))
						{
							ac2 = get_point(pos2c, pos2b, norm1);
							if (test_range(ac2.w))
								group_pair.y = 1; //ac2 && ab2 ok
						}
						else
						{
							group_pair.y = 1;
						}
						
						group_pair.x = group_pair.y * group_pair.x;
						
						if (group_pair.x > 0.1)
						{
							if (test_ranges(ab1.x, ac1.x, ab2.x, ac2.x))
							{
								ret.xyz += normalize(norm2.xyz);
							}
	/*						else if (test_ranges(ab1.y, ac1.y, ab2.y, ac2.y))
							{
								ret.xyz += normalize(norm2.xyz);
							}*/
						}
					}
				}
			}

			header.x += r_texdx_1;
			group_pair = stex(s1, header.xy);
		}
	}

	return ret; 
}

bool test_collision(float t1, float t2, float t3)
{
	int test = 0;
	
	if (test_range(t1))
		test++;

	if (test_range(t2))
		test++;

	if (test_range(t3))
		test++;
		
	return test > 1;
}

float4 triangle_collision_task_ps_old(in float2 t : TEXCOORD0) : COLOR
{
	float4 pair = tex2D(s0, t);
	float4 ret = float4(0,0,0,0);
		
	if (pair.w > 0)
	{
		float4 groups_test = tex2Dlod(s2, float4(pair.xy, 0, 0));
		
		if (groups_test.x > 0)
		{
			float4 group_pair = stex(s1, pair.xy);
					
			float4 a1 = stex(s3, float2(group_pair.xy));
			float4 h1 = stex(s4, a1.xy);
			float tx = h1.z + pair.z * r_texdx_4;
			float4 tri1x = stex(s4, float2(tx, a1.y));
			float4 tri1y = stex(s4, float2(tx + r_texdx_4, a1.y));
			
			float4 a2 = stex(s3, float2(group_pair.zw));
			float4 h2 = stex(s4, a2.xy);
			

			float4 pos1a = stex(s5, float2(tri1x.x, tri1y.x));
			float4 pos1b = stex(s5, float2(tri1x.y, tri1y.y));
			float4 pos1c = stex(s5, float2(tri1x.z, tri1y.z));

			
			float4 norm1 = float4(cross(pos1a - pos1c, pos1b - pos1c), 0);
			norm1.w = dot(pos1a.xyz, norm1.xyz);
			
			float tri_max = h2.z + (h1.x * 2 - 0.1) * r_texdx_4;
			
//			float tri2 = h2.z;
			[loop] for (float tri2 = h2.z; tri2 < tri_max; tri2 += (r_texdx_4 * 2))
			{
				float4 tri2x = stex(s4, float2(tri2, a2.y));
				float4 tri2y = stex(s4, float2(tri2 + r_texdx_4, a2.y));

				bool go = false;
				
				if (any(tri1x - tri2x))
					go = true;
				
				if (any(tri1y - tri2y))
					go = true;
				
				if (go)
				{
					float4 pos2a = stex(s5, float2(tri2x.x, tri2y.x));
					float4 pos2b = stex(s5, float2(tri2x.y, tri2y.y));
					float4 pos2c = stex(s5, float2(tri2x.z, tri2y.z));
					
					float4 norm2 = float4(cross(pos2a - pos2b, pos2b - pos2c), 0);
					norm2.w = dot(pos2a.xyz, norm2.xyz);
					
					float4 ab1 = get_point(pos1a, pos1b, norm2);
					float4 ac1 = get_point(pos1a, pos1c, norm2);
					float4 cb1 = get_point(pos1c, pos1b, norm2);
					
					if (test_collision(ab1.w, ac1.w, cb1.w))
					{
						float4 ab2 = get_point(pos2a, pos2b, norm1);
						float4 ac2 = get_point(pos2a, pos2c, norm1);
						float4 cb2 = get_point(pos2c, pos2b, norm1);
						
						if (test_collision(ab2.w, ac2.w, cb2.w))
						{
							if (test_range(ab1.w))
							{
								if (!test_range(ac1.w))
									ac1 = cb1;
							}
							else
							{
								ab1 = cb1;
							}
							
							if (test_range(ab2.w))
							{
								if (!test_range(ac2.w))
									ac2 = cb2;
							}
							else
							{
								ab2 = cb2;
							}

							if (test_ranges(ab1.x, ac1.x, ab2.x, ac2.x))
							{
								ret.xyz += normalize(norm2.xyz);
							}
							else if (test_ranges(ab1.y, ac1.y, ab2.y, ac2.y))
							{
								ret.xyz += normalize(norm2.xyz);
							}
						}
					}
				}
			}
		}
	}
	
	return ret;
}

technique triangle_collision_task < string params = "r_skip_groups r_texdx_4 r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 triangle_collision_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// sum triangle collisions
// 0: m_TrianglesSumCollTexture
// 1: triangle_collision_task result
////////////////////////////////////////////////////////////////////////////

float4 sum_collision_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 tri_desc = tex2D(s0, t);
	float4 result = float4(0,0,0,0);
	
	[loop] for (float tri_idx = 0; tri_idx < tri_desc.z; tri_idx = tri_idx + 1)
	{
		result = result + tex2Dlod(s1, float4(tri_desc.x + tri_idx * r_texdx_1, tri_desc.y, 0, 0));
	}
	
	result.xyz = normalize(result.xyz);
	
	return result;
}

technique sum_collision_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 sum_collision_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

