float4x4 r_world = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_view_world = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_world_normal = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_projection = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_projection_view_world = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};

float4 r_color = {0, 1, 0, 0};

float r_texdx_1;
float r_texdy_1;
float r_texdx_2;
float r_texdy_2;

float r_texdx_0;
float r_texdy_0;

sampler s0 : register(s0);
sampler s1 : register(s1);
sampler s2 : register(s2);

struct VS_INPUT_N
{
    float3 vPosition        : POSITION;
    float3 vNormal			: NORMAL;
    float3 vTexCoords       : TEXCOORD0;
    float3 vBiNormalU		: TEXCOORD1;
    float3 vBiNormalV		: TEXCOORD2;
};


////////////////////////////////////////////////////////////////////////////
// bb
////////////////////////////////////////////////////////////////////////////

struct VS_BB_INPUT
{
    float4 m_position		: POSITION;
    float4 m_diffuse		: COLOR0;
};

VS_BB_INPUT bb_vs(const VS_BB_INPUT v)
{
    VS_BB_INPUT o = (VS_BB_INPUT) 0;
	
	float4 pos = float4(v.m_position.xyz, 1.0);

	o.m_position = mul(pos, r_projection);
    o.m_diffuse  = v.m_diffuse;
  
    return o;
}

float4 bb_ps(in float4 c : COLOR0) : COLOR
{
	return c;
}

technique BoundingBox < string params = "r_projection"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 bb_vs();
		PixelShader = compile ps_3_0 bb_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// text
////////////////////////////////////////////////////////////////////////////

struct VS_TEXT_INPUT
{
    float4 m_position		: POSITION;
    float4 m_tex			: TEXCOORD0;
    float4 m_diffuse		: COLOR0;
};

VS_TEXT_INPUT text_vs(const VS_TEXT_INPUT v)
{
    VS_TEXT_INPUT o = (VS_TEXT_INPUT) 0;
	
	o.m_position = float4(v.m_position.xy, 0.5, 1.0);
    o.m_diffuse  = v.m_diffuse;
    o.m_tex = v.m_tex;
  
    return o;
}

float4 text_ps(in float4 c : COLOR0, in float4 tex : TEXCOORD0) : COLOR
{
	float col = tex2D(s0, tex.xy).x;
	return float4(c.xyz * col, 1 - col);
}

technique Text < string params = "r_projection"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 text_vs();
		PixelShader = compile ps_3_0 text_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// color
////////////////////////////////////////////////////////////////////////////

struct VS_COLOR_INPUT
{
    float4 m_position		: POSITION;
};

VS_COLOR_INPUT color_vs(const VS_COLOR_INPUT v)
{
    VS_COLOR_INPUT o = (VS_COLOR_INPUT) 0;
	
	float4 pos = float4(v.m_position.xyz, 1.0);

	o.m_position = mul(pos, r_projection_view_world);
  
    return o;
}

float4 color_ps() : COLOR
{
	return r_color;
}

technique color < string params = "r_projection_view_world r_color"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 color_vs();
		PixelShader = compile ps_3_0 color_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// color
////////////////////////////////////////////////////////////////////////////

technique color_particles < string params = "r_projection_view_world r_color"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 color_vs();
		PixelShader = compile ps_3_0 color_ps();
	    CullMode = NONE;
		ZEnable = TRUE;
		AlphaBlendEnable = TRUE;
		SrcBlend = ONE;
		DestBlend = SRCALPHA;
		PointSize = 1.2;
	}
}

////////////////////////////////////////////////////////////////////////////
// two lights
////////////////////////////////////////////////////////////////////////////

float4 light1_pos = {20,40,40,1};
float4 light2_pos = {-20,40,20,1};
float4 r_view_pos = {0, 0, 0, 0};

struct VS_TWO_LIGHTS_INPUT
{
    float4 m_position		: POSITION;
    float3 m_norm			: NORMAL;
};

struct VS_TWO_LIGHTS_OUTPUT
{
    float4 m_position		: POSITION;
    float3 m_norm			: TEXCOORD0;
    float3 m_pos			: TEXCOORD1;
};

VS_TWO_LIGHTS_OUTPUT two_lights_vs(const VS_TWO_LIGHTS_INPUT v)
{
    VS_TWO_LIGHTS_OUTPUT o = (VS_TWO_LIGHTS_OUTPUT) 0;
	
	float4 pos = float4(v.m_position.xyz, 1.0);

	o.m_pos = mul(pos, r_world);
	o.m_norm = mul(v.m_norm, r_world_normal);
	
	o.m_position = mul(pos, r_projection_view_world);
  
    return o;
}

float4 two_lights_ps(in float3 pos : TEXCOORD1, in float3 norm : TEXCOORD0) : COLOR
{
	float3 to_l1 = normalize(light1_pos - pos);
	float3 to_l2 = normalize(light2_pos - pos);
	norm = normalize(norm);
	
	float3 to_cam = normalize(r_view_pos - pos);
	float3 r_l1 = normalize(-reflect(to_l1, norm));
	float3 r_l2 = normalize(-reflect(to_l2, norm));
	
	float s1 = dot(r_l1, to_cam);
	float s2 = dot(r_l2, to_cam);
	
	float l1 = dot(to_l1, norm) * 0.5;
	float l2 = dot(to_l2, norm) * 0.5;
	
	l1 = max(l1, 0);
	l2 = max(l2, 0);
	s1 = max(s1, 0);
	s2 = max(s2, 0);
	
	s1 = s1 * s1;
	s1 = s1 * s1;
	s1 = s1 * s1;
	s1 = s1 * s1;
//	s1 = s1 * s1;
	
	s2 = s2 * s2;
	s2 = s2 * s2;
	s2 = s2 * s2;
	s2 = s2 * s2;
//	s2 = s2 * s2;

	float l = l1 + l2;
	
	return r_color * l * (1 - r_color.a) + r_color * r_color.a + (s1 + s2) * float4(0.3, 0.3, 0.3, 0.3);
}

technique two_lights < string params = "r_projection_view_world r_world r_world_normal r_color r_view_pos"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 two_lights_vs();
		PixelShader = compile ps_3_0 two_lights_ps();
//	    CullMode = CCW;
	    CullMode = NONE;
		ZEnable = TRUE;
	}
}

////////////////////////////////////////////////////////////////////////////
// d3d_material
////////////////////////////////////////////////////////////////////////////

struct VS_D3D_INPUT
{
    float4 m_position		: POSITION;
    float3 m_norm			: NORMAL;
    float2 m_tex			: TEXCOORD0;
};

struct VS_D3D_OUTPUT
{
    float4 m_position		: POSITION;
    float3 m_norm			: TEXCOORD0;
    float4 m_pos			: TEXCOORD1;
    float2 m_tex			: TEXCOORD2;
};

VS_D3D_OUTPUT d3d_material_vs(const VS_D3D_INPUT v)
{
    VS_D3D_OUTPUT o = (VS_D3D_OUTPUT) 0;
	
	float4 pos = float4(v.m_position.xyz, 1.0);

	o.m_pos.xyz = mul(pos, r_world);
	o.m_pos.w = mul(pos, r_view_world).z;

	o.m_norm = mul(v.m_norm, r_world_normal);
	
	o.m_position = mul(pos, r_projection_view_world);
	o.m_tex = v.m_tex;
  
    return o;
}

float4 r_diffuse = {0, 0, 0, 0};
float4 r_specular = {0, 0, 0, 0};
float4 r_ambient = {0, 0, 0, 0};
float4 r_emissive = {0, 0, 0, 0};
float r_power = 0;
float r_use_texture = 0;

float4 d3d_material_ps(in float4 pos : TEXCOORD1, in float3 norm : TEXCOORD0, in float2 tex : TEXCOORD2, out float4 rt_input : COLOR1) : COLOR0
{
	float3 to_l1 = normalize(light1_pos - pos);
	float3 to_l2 = normalize(light2_pos - pos);
	norm = normalize(norm);

	float3 to_cam = r_view_pos - pos.xyz;
	
	float z = -pos.w;
	if (r_specular.x < 0.05f)
		z = -1;
		
	rt_input = float4(norm, z);
	
	to_cam = normalize(to_cam);
	float3 r_l1 = normalize(-reflect(to_l1, norm));
	float3 r_l2 = normalize(-reflect(to_l2, norm));
	
	float s1 = dot(r_l1, to_cam);
	float s2 = dot(r_l2, to_cam);
	
	float l1 = dot(to_l1, norm);
	float l2 = dot(to_l2, norm);
	
	l1 = max(l1, 0);
	l2 = max(l2, 0);
	s1 = max(s1, 0);
	s2 = max(s2, 0);
	
	s1 = pow(s1, r_power);
	s2 = pow(s2, r_power);
	
	float s = s1 + s2;
	float l = l1 + l2;
	
	float4 tex_color = {1, 1, 1, 1};
	if (r_use_texture > 0.5)
	 tex_color = tex2D(s0, tex);
	
	return r_emissive + tex_color * (r_ambient + r_diffuse * l + r_specular * s);
}

technique d3d_material < string params = "r_projection_view_world r_view_world r_world r_world_normal r_use_texture r_diffuse r_specular r_ambient r_emissive r_power r_view_pos"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 d3d_material_vs();
		PixelShader = compile ps_3_0 d3d_material_ps();
	    CullMode = CW;
		ZEnable = TRUE;
	}
}
////////////////////////////////////////////////////////////////////////////
// dbg_tex
////////////////////////////////////////////////////////////////////////////

float4 r_dbg_tex_pos;
float4 r_dbg_tex_scale;
float4 r_dbg_tex_base;
float r_dbg_tex_rot;

struct VS_DBG_TEX_INPUT
{
    float4 m_position		: POSITION;
    float2 m_texture		: TEXCOORD0;
};

VS_DBG_TEX_INPUT dbg_tex_vs(const VS_DBG_TEX_INPUT v)
{
    VS_DBG_TEX_INPUT o = (VS_DBG_TEX_INPUT) 0;
	
	o.m_position = float4((v.m_position.xy + float2(1, 1))* r_dbg_tex_pos.zw + r_dbg_tex_pos.xy * 2.0 - float2(1, 1), 0.5, 1);
	o.m_texture = v.m_texture;
  
    return o;
}

float4 dbg_tex_ps(in float2 tex : TEXCOORD0) : COLOR
{
//	return float4((tex2D(s0, tex) * r_dbg_tex_scale + r_dbg_tex_base).xyz, r_dbg_tex_base.w);
	
	
	float3 color = tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * 0.5).xyz + r_dbg_tex_base.xyz;
	float alpha = max(color.x, color.y);
	alpha = max(color.z, alpha);
	alpha = max(r_dbg_tex_scale.w, alpha);
	
	return float4(color, saturate(1 - alpha * r_dbg_tex_base.w));
}

technique dbg_tex < string params = "r_dbg_tex_pos r_dbg_tex_scale r_dbg_tex_base r_texdx_0 r_texdy_0"; >
{
	pass P0
	{
        VertexShader = compile vs_2_0 dbg_tex_vs();
		PixelShader = compile ps_2_0 dbg_tex_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

float4 clipart_tex_ps(in float2 tex : TEXCOORD0) : COLOR
{
	float3 color = tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * 0.5).xyz;
	float3 alpha = tex2D(s1, tex + float2(r_texdx_0, r_texdy_0) * 0.5).xyz;

	return float4(color, 1 - alpha.x);
}

technique clipart_tex < string params = "r_dbg_tex_pos r_texdx_0 r_texdy_0"; >
{
	pass P0
	{
        VertexShader = compile vs_2_0 dbg_tex_vs();
		PixelShader = compile ps_2_0 clipart_tex_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

// bilboard color
float4 bilboard_color_ps(in float2 tex : TEXCOORD0) : COLOR
{
	return r_color;
}

technique bilboard_color < string params = "r_dbg_tex_pos r_color"; >
{
	pass P0
	{
        VertexShader = compile vs_2_0 dbg_tex_vs();
		PixelShader = compile ps_2_0 bilboard_color_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

//bicubic

float w0(float a)
{
//    return (1.0f/6.0f)*(-a*a*a + 3.0f*a*a - 3.0f*a + 1.0f);
    return (1.0f/6.0f)*(a*(a*(-a + 3.0f) - 3.0f) + 1.0f);   // optimized
}

float w1(float a)
{
//    return (1.0f/6.0f)*(3.0f*a*a*a - 6.0f*a*a + 4.0f);
    return (1.0f/6.0f)*(a*a*(3.0f*a - 6.0f) + 4.0f);
}

float w2(float a)
{
//    return (1.0f/6.0f)*(-3.0f*a*a*a + 3.0f*a*a + 3.0f*a + 1.0f);
    return (1.0f/6.0f)*(a*(a*(-3.0f*a + 3.0f) + 3.0f) + 1.0f);
}

float w3(float a)
{
    return (1.0f/6.0f)*(a*a*a);
}

float4 tex_forBiCubic(float x, float y)
{
	return tex2D(s0, float2(x * r_texdx_0, y * r_texdy_0));
}

float4 cubicFilter(float x, float4 c0, float4 c1, float4 c2, float4 c3)
{
    float4 r;
    r = c0 * w0(x);
    r += c1 * w1(x);
    r += c2 * w2(x);
    r += c3 * w3(x);
    return r;
}

float4 bicubic_tex_ps(in float2 tex : TEXCOORD0) : COLOR
{
	return tex2D(s0, tex);
	
	float dt = 1;
	float x = (tex.x + 0.5 - dt * 0.5) / r_texdx_0 * dt;
	float y = (tex.y + 0.5 - dt * 0.5) / r_texdy_0 * dt;

    x -= 0.5f;
    y -= 0.5f;
    
    float px = floor(x);
    float py = floor(y);
    float fx = x - px;
    float fy = y - py;
    
    float4 v1 = cubicFilter(fx, tex_forBiCubic(px-1, py-1), tex_forBiCubic(px, py-1), tex_forBiCubic(px+1, py-1), tex_forBiCubic(px+2,py-1));
    float4 v2 = cubicFilter(fx, tex_forBiCubic(px-1, py),   tex_forBiCubic(px, py),   tex_forBiCubic(px+1, py),   tex_forBiCubic(px+2, py));
    float4 v3 = cubicFilter(fx, tex_forBiCubic(px-1, py+1), tex_forBiCubic(px, py+1), tex_forBiCubic(px+1, py+1), tex_forBiCubic(px+2, py+1));
    float4 v4 = cubicFilter(fx, tex_forBiCubic(px-1, py+2), tex_forBiCubic(px, py+2), tex_forBiCubic(px+1, py+2), tex_forBiCubic(px+2, py+2));

    return cubicFilter(fy, v1, v2, v3, v4);

//	return float4(color, 1 - alpha.x);
}

technique bicubic_tex < string params = "r_dbg_tex_pos r_texdx_0 r_texdy_0"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 dbg_tex_vs();
		PixelShader = compile ps_3_0 bicubic_tex_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// copy_rt_tex
////////////////////////////////////////////////////////////////////////////

VS_DBG_TEX_INPUT copy_rt_tex_vs(const VS_DBG_TEX_INPUT v)
{
    VS_DBG_TEX_INPUT o = (VS_DBG_TEX_INPUT) 0;
	
	o.m_position = float4((v.m_position.xy /* 0.5f + float2(0.5f, 0.5f)*/), 0.5, 1);
	o.m_texture = v.m_texture;
  
    return o;
}

float2 dTex[] =
{
	{0.000000, 1.000000},
	{0.406737, 0.913545},
	{0.743145, 0.669131},
	{0.951057, 0.309017},
	{0.994522, -0.104529},
	{0.866025, -0.500000},
	{0.587785, -0.809017},
	{0.207912, -0.978148},
	{-0.207912, -0.978148},
	{-0.587785, -0.809017},
	{-0.866025, -0.500000},
	{-0.994522, -0.104528},
	{-0.951056, 0.309017},
	{-0.743145, 0.669131},
	{-0.406736, 0.913546}
};

float r_rt_scale_x;
float r_rt_scale_y;

float4 copy_rt_tex_ps(in float2 tex : TEXCOORD0) : COLOR
{
	tex.x = (tex.x + r_texdx_0 * 0.6f) * r_rt_scale_x;
	tex.y = (tex.y + r_texdy_0 * 0.6f) * r_rt_scale_y;
	
	return tex2D(s0, tex);
	
	float r = 0.9f;
	float4 ret = float4(0, 0, 0, 0);
	
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[0] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[1] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[2] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[3] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[4] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[5] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[6] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[7] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[8] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[9] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[10] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[11] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[12] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[13] * r);
	ret += tex2D(s0, tex + float2(r_texdx_0, r_texdy_0) * dTex[14] * r);

	return ret * 0.06666666666;
}

technique copy_rt_tex < string params = "r_texdx_0 r_texdy_0 r_rt_scale_x r_rt_scale_y"; >
{
	pass P0
	{
        VertexShader = compile vs_2_0 copy_rt_tex_vs();
		PixelShader = compile ps_2_0 copy_rt_tex_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// dbg_tex
////////////////////////////////////////////////////////////////////////////

VS_DBG_TEX_INPUT clear_tex_vs(const VS_DBG_TEX_INPUT v)
{
    VS_DBG_TEX_INPUT o = (VS_DBG_TEX_INPUT) 0;
	
	o.m_position = float4(v.m_position.xy , 0.5, 1);
	o.m_texture = v.m_texture;
  
    return o;
}

float4 r_clear_color;

float4 clear_tex_ps(in float2 tex : TEXCOORD0) : COLOR
{
	return r_clear_color;
}

technique clear_tex < string params = "r_clear_color"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 clear_tex_vs();
		PixelShader = compile ps_3_0 clear_tex_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// dbg_tex
////////////////////////////////////////////////////////////////////////////

float4 r_zoom_mat1;
float4 r_zoom_mat2;
float r_zoom_aspect;
float r_zoom_blend;
float r_zoom_blend2;

uint r_zoom_images_x = 0;

VS_DBG_TEX_INPUT zoom_effect_vs(const VS_DBG_TEX_INPUT v)
{
    VS_DBG_TEX_INPUT o = (VS_DBG_TEX_INPUT) 0;
	
	o.m_position = float4(v.m_position.xy , 0.5, 1);
	o.m_texture = float2(v.m_texture.x - 0.5, (v.m_texture.y - 0.5) * r_zoom_aspect);
  
    return o;
}

float4 zoom_effect_ps(in float2 tex : TEXCOORD0) : COLOR
{
	float4 tex4 = float4(tex, 0, 1);
	float2 new_tex = float2(dot(r_zoom_mat1, tex4), dot(r_zoom_mat2, tex4));
	
	float4 color = tex2D(s0, new_tex);
	
	uint red = color.x * 63.f;
	uint green = color.y * 63.f;
	uint blue = color.z * 63.f;
	
	uint index = red + green * 64 + blue * 4096;
	float x = (0.5f + float(index % 512)) / 512.f;
	float y = (0.5f + float(index / 512)) / 512.f;
	
	float4 desc = tex2D(s2, float2(x, y));
	
/*	
	if (tex.x < 0.3)
	{
		desc.w = 0;
		return desc;
	}
*/	
	uint image = uint(desc.w * 255.f + 0.3f);
	
	uint image_x = image % r_zoom_images_x;
	uint image_y = image / r_zoom_images_x;
	
	float jpimage_x = 1.f / float(r_zoom_images_x);
	
	float base_x = float(image_x) * jpimage_x;
	float base_y = float(image_y) * jpimage_x;
		
	new_tex.x = frac(new_tex.x / r_texdx_0) * jpimage_x + base_x;// + r_texdx_1 * 0.5f;
	new_tex.y = frac(new_tex.y / r_texdy_0) * jpimage_x + base_y;// + r_texdx_1 * 0.5f;

	float4 img_color = tex2D(s1, new_tex);
	
	float4 ret_color = lerp(color, img_color + color - desc, r_zoom_blend);
	ret_color = lerp(ret_color, img_color, r_zoom_blend2);

	return ret_color;
}

float4 zoom_effect2_ps(in float2 tex : TEXCOORD0) : COLOR
{
	float4 tex4 = float4(tex, 0, 1);
	float2 new_tex = float2(dot(r_zoom_mat1, tex4), dot(r_zoom_mat2, tex4));
	
	float4 color = tex2D(s0, new_tex);
	
	uint red = color.x * 63.f;
	uint green = color.y * 63.f;
	uint blue = color.z * 63.f;
	
	uint index = red + green * 64 + blue * 4096;
	float x = (0.5f + float(index % 512)) / 512.f;
	float y = (0.5f + float(index / 512)) / 512.f;
	
	float4 desc = tex2D(s2, float2(x, y));
	
	uint image = uint(desc.w * 255.f + 0.3f);
	
	uint image_x = image % r_zoom_images_x;
	uint image_y = image / r_zoom_images_x;
	
	float jpimage_x = 1.f / float(r_zoom_images_x);
	
	float base_x = float(image_x) * jpimage_x;
	float base_y = float(image_y) * jpimage_x;
		
	new_tex.x = frac(new_tex.x / r_texdx_0) * jpimage_x + base_x;// + r_texdx_1 * 0.5f;
	new_tex.y = frac(new_tex.y / r_texdy_0) * jpimage_x + base_y;// + r_texdx_1 * 0.5f;

	color = tex2D(s1, new_tex);// * float4(scale, 1);

	red = color.x * 63.f;
	green = color.y * 63.f;
	blue = color.z * 63.f;
	
	index = red + green * 64 + blue * 4096;
	x = (0.5f + float(index % 512)) / 512.f;
	y = (0.5f + float(index / 512)) / 512.f;
	
	desc = tex2D(s2, float2(x, y));
	
	image = uint(desc.w * 255.f + 0.3f);
	
	image_x = image % r_zoom_images_x;
	image_y = image / r_zoom_images_x;
	
//	jpimage_x = 1.f / float(r_zoom_images_x);
	
	base_x = float(image_x) * jpimage_x;
	base_y = float(image_y) * jpimage_x;
		
	new_tex.x = frac(new_tex.x / r_texdx_1) * jpimage_x + base_x;// + r_texdx_1 * 0.5f;
	new_tex.y = frac(new_tex.y / r_texdy_1) * jpimage_x + base_y;// + r_texdx_1 * 0.5f;

	float4 img_color = tex2D(s1, new_tex);
	
	color = lerp(color, img_color + color - desc, r_zoom_blend);
	color = lerp(color, img_color, r_zoom_blend2);

/*	float4 img_color = tex2D(s1, new_tex);
	color = lerp(color, img_color * float4(scale, 1), r_zoom_blend);
	color = lerp(color, img_color, r_zoom_blend2);*/
	
	return color;
}

technique zoom_effect < string params = "r_texdx_1 r_texdy_1 r_zoom_images_x r_zoom_blend r_zoom_blend2 r_texdx_0 r_texdy_0 r_texdx_2 r_texdy_2 r_zoom_mat1 r_zoom_mat2 r_zoom_aspect"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 zoom_effect_vs();
		PixelShader = compile ps_3_0 zoom_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}

	pass P1
	{
        VertexShader = compile vs_3_0 zoom_effect_vs();
		PixelShader = compile ps_3_0 zoom_effect2_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}
