
float g_fScreenX = 100.0f;
float g_fScreenY = 100.0f;

float g_dX = 0.01f;
float g_dY = 0.01f;

sampler s0 : register(s0);
sampler s1 : register(s1);
sampler s2 : register(s2);

struct VS_INPUT
{
    float3 vPosition        : POSITION;
    float4 vDiffuse         : COLOR0;
    float2 vTexCoords       : TEXCOORD0;
    float2 vTexCoords2      : TEXCOORD1;
};

struct VS_OUTPUT
{
    float4 vPosition        : POSITION;
    float2 vTexCoords       : TEXCOORD0;
};

VS_OUTPUT fullscreen_vs(const VS_INPUT v)
{
    VS_OUTPUT o = (VS_OUTPUT) 0;

	float4 f = float4( v.vPosition, 1 );
	f.xy = f.xy + float2( v.vTexCoords2.x, -v.vTexCoords2.y );
	
	o.vPosition = f;
	o.vTexCoords = v.vTexCoords * 0.5f + float2( 0.5, 0.5 );
 
    return o;
}

float4 blur_effect_ps(in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float dx = g_dX * 0.8f;
	float dy = g_dY * 0.8f;
	
	float4 color = { 0, 0, 0, 0 };
	
	color += tex2D( s0, vTex + float2( dx, dy ) );
	color += tex2D( s0, vTex + float2( -dx, dy ) );
	color += tex2D( s0, vTex + float2( dx, -dy ) );
	color += tex2D( s0, vTex + float2( -dx, -dy ) );
	
	color = color * 0.25;
	
	return color;
}

float g_fKernelSize = 1.1;
float g_fFocusZ = 20.0;
float g_fFocusScale = 0.04;

float sample_weight( float2 vTex )
{
//	return 1.0f;
	float z = tex2D( s1, vTex );
	float ret = ( g_fFocusZ - z ) * g_fFocusScale;
	ret = ret * ret;
	
	if( ret > 1 )
		ret = 1;
	
	return ret;
}

float4 sample_depth( float2 vTex, float weight )
{
	return tex2D( s0, vTex ) * weight;
}

float g_fScaleKernel = 1.0;

float4 random_effect_ps( in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float2 dx = ( float2( 0.5, 0.5 ) - tex2D( s1, vTex ).xy ) * g_fScaleKernel;
	return tex2D( s0, vTex + float2( dx.x * g_dX, dx.y * g_dY ) );
}

float g_fDownsampleScale = 0.98f;
float g_fDownsampleDX = 0.0;

VS_OUTPUT down_sample_effect_vs(const VS_INPUT v)
{
    VS_OUTPUT o = (VS_OUTPUT) 0;

	float4 f = float4( v.vPosition, 1 );
	f.xy = f.xy + float2( v.vTexCoords2.x, -v.vTexCoords2.y ) * g_fDownsampleScale;
	
	o.vPosition = f;
	o.vTexCoords = v.vTexCoords * 0.5f + float2( 0.5, 0.5 );
 
    return o;
}

float4 down_sample_effect_ps( in float2 vTex1 : TEXCOORD0 ) : COLOR0
{
	float2 vTex = vTex1; // + float2( g_dX * 4.0f, g_dY * 4.0f );
	float4 ret_color = { 0, 0, 0, 0 };
	
	float dx = g_dX * 2.5;
	float dy = g_dY * 2.5;
	
/*	ret_color += tex2D( s0, vTex + float2( dx, dy ) );
	ret_color += tex2D( s0, vTex + float2( -dx, dy ) );
	ret_color += tex2D( s0, vTex + float2( dx, -dy ) );
	ret_color += tex2D( s0, vTex + float2( -dx, -dy ) );*/
	ret_color += tex2D( s0, vTex );
	
	return ret_color;
}

float4 blend_effect_ps( in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float2 vTex2 = -float2( g_dX , g_dY ) * 0 + (vTex - float2( 0.5, 0.5 )) * g_fDownsampleScale + float2( 0.5, 0.5 );
	return ( 0 * tex2D( s0, vTex ) + 4 * tex2Dlod( s1, float4( vTex2, 2.0, 2.0 ) ) )* 0.25;
}

float2 transform_dx( float2 dx, float4 mat )
{
	return float2( dx.x * mat.r + dx.y * mat.b, dx.x * mat.g + dx.y * mat.a );
}

float frame_rand_dx = 0;

float4 depth_effect_ps( in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float totalW = 0;
	
//	return float4( sample_weight( vTex ), 0, 0, 1 );
	
	float4 color = { 0, 0, 0, 0 };
	
	float kernelSize = g_fScaleKernel * g_fKernelSize;
	
	float4 mat = float4( 1,0,0,1 );//tex2D( s2, vTex + float2( frame_rand_dx, 0 ) ) * 2.0f - float4( 1, 1, 1, 1 );
	
	float2 sample1 = vTex + transform_dx( float2( -kernelSize, kernelSize * 0.65 ), mat);
	float2 sample2 = vTex + transform_dx( float2( kernelSize, kernelSize * 0.65 ), mat);
	float2 sample3 = vTex + transform_dx( float2( 0, -kernelSize ), mat);
	float2 sample4 = vTex + transform_dx( float2( -kernelSize, -kernelSize * 0.65 ), mat);
	float2 sample5 = vTex + transform_dx( float2( kernelSize, -kernelSize * 0.65 ), mat);
	float2 sample6 = vTex + transform_dx( float2( 0, kernelSize ), mat);
	
	float weight = 0;
	
	weight = sample_weight( sample1 );
	color += sample_depth( sample1, weight );
	totalW += weight;
	
	weight = sample_weight( sample2 );
	color += sample_depth( sample2, weight );
	totalW += weight;
	
	weight = sample_weight( sample3 );
	color += sample_depth( sample3, weight );
	totalW += weight;
	
	weight = sample_weight( sample4 );
	color += sample_depth( sample4, weight );
	totalW += weight;
	
	weight = sample_weight( sample5 );
	color += sample_depth( sample5, weight );
	totalW += weight;

	weight = sample_weight( sample6 );
	color += sample_depth( sample6, weight );
	totalW += weight;
	
	weight = sample_weight( vTex );
//	return float4( weight * 0.01, weight * 0.1, weight, 0 );
//	weight = 1.0 - weight * weight;
//	if( weight < 0 )
//	weight = 0;
	weight = 0.05 / (weight + 0.01);
		
	color += sample_depth( vTex, weight );
	totalW += weight;
	
	totalW = 1.0 / totalW;
	

	return color * totalW;
//	return float4( color.xy, weight, 0 );
}

float4 depth_effect_ps30( in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float totalW = 0;
	
	return float4( sample_weight( vTex ), 0, 0, 1 );
	
	float4 color = { 0, 0, 0, 0 };
	
	float2 sample1 = vTex + float2( -g_fKernelSize, g_fKernelSize * 0.75 );
	float2 sample2 = vTex + float2( g_fKernelSize, g_fKernelSize * 0.75 );
	float2 sample3 = vTex + float2( 0, -g_fKernelSize );
	float2 sample4 = vTex + float2( -g_fKernelSize, -g_fKernelSize * 0.75 );
	float2 sample5 = vTex + float2( g_fKernelSize, -g_fKernelSize * 0.75 );
	float2 sample6 = vTex + float2( 0, g_fKernelSize );
	
	float weight = 0;
	
	weight = sample_weight( sample1 );
	color += sample_depth( sample1, weight );
	totalW += weight;
	
	weight = sample_weight( sample2 );
	color += sample_depth( sample2, weight );
	totalW += weight;
	
	weight = sample_weight( sample3 );
	color += sample_depth( sample3, weight );
	totalW += weight;
	
	weight = sample_weight( sample4 );
	color += sample_depth( sample4, weight );
	totalW += weight;
	
	weight = sample_weight( sample5 );
	color += sample_depth( sample5, weight );
	totalW += weight;

	weight = sample_weight( sample6 );
	color += sample_depth( sample6, weight );
	totalW += weight;
	
	weight = sample_weight( vTex );
//	weight = 1.0 - weight * weight;
//	weight = 1.0 / (weight + 0.1);
	color += sample_depth( vTex, weight );
//	totalW += weight;
	
	totalW = 1152.3 / totalW;
	
	return color * totalW;
}

float4 sum_0_a1_ps(in float2 vTex : TEXCOORD0 ) : COLOR0
{
	float4 color0 = tex2D( s0, vTex );
	float4 color1 = tex2D( s1, vTex );
	
	return color0 * ( 1.0 - color1.a )+ color1 * color1.a;
}

technique sum_0_a1
{
    pass P0
    {
        VertexShader = compile vs_1_1 fullscreen_vs();
		PixelShader = compile ps_2_0 sum_0_a1_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}

technique depth_effect
{
    pass P0
    {
        VertexShader = compile vs_3_0 fullscreen_vs();
		PixelShader = compile ps_3_0 depth_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}

technique blend_effect
{
    pass P0
    {
        VertexShader = compile vs_3_0 fullscreen_vs();
		PixelShader = compile ps_3_0 blend_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}

technique depth_effect30
{
    pass P0
    {
        VertexShader = compile vs_1_1 fullscreen_vs();
		PixelShader = compile ps_3_0 depth_effect_ps30();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}

technique random_effect
{
    pass P0
    {
        VertexShader = compile vs_1_1 fullscreen_vs();
		PixelShader = compile ps_2_0 random_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}

technique down_sample_effect
{
    pass P0
    {
        VertexShader = compile vs_1_1 down_sample_effect_vs();
		PixelShader = compile ps_2_0 down_sample_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}
technique blur_effect
{
    pass P0
    {
        VertexShader = compile vs_1_1 fullscreen_vs();
		PixelShader = compile ps_2_0 blur_effect_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
    }
}