
sampler s0 : register(s0);
sampler s1 : register(s1);
sampler s2 : register(s2);
sampler s3 : register(s3);
sampler s4 : register(s4);
sampler s5 : register(s5);

float4 one = {1,1,1,1};
float op_scale = 0.2;

float r_texdx_0 = 0;
float r_texdy_0 = 0;
float r_texdx_1 = 0;
float r_texdx_2 = 0;
float r_texdx_4 = 0;

float r_mesh_id = 0;
float r_frame_dt = 0;

struct VS_TASK_INPUT
{
    float4 m_position		: POSITION;
    float2 m_texture		: TEXCOORD0;
};

float4 stex(sampler s, float2 t)
{
	float2 tc = float2(0,0);
	
	if (t.x > -1)
	{
		tc.x = t.x + 0.0001;
		if (t.y > -1)
		{
			tc.y = t.y + 0.0001;

			return tex2Dlod(s, float4(tc, 0, 0));
		}
		else
			return float4(0, 0, 0, 0);
	}
	else
		return float4(0, 0, 0, 0);
		
}

VS_TASK_INPUT task_vs(const VS_TASK_INPUT v)
{
    VS_TASK_INPUT o = (VS_TASK_INPUT) 0;

	o.m_position = float4(v.m_position.xy, 0.5, 1.0);
    o.m_texture  = float4(v.m_texture, v.m_position.xy);
  
    return o;
}

////////////////////////////////////////////////////////////////////////////
// volume
////////////////////////////////////////////////////////////////////////////

float4 volume_task_ps(in float2 t : TEXCOORD0, out float4 norm_field : COLOR1) : COLOR0
{
	float4 triangle_x = tex2D(s0, t);
	
	if (triangle_x.w != 0)
	{
		float4 triangle_y = tex2D(s0, t + float2(r_texdx_0, 0));
		
		float4 v1 = tex2D(s1, float2(triangle_x.x, triangle_y.x)) + float4(10, 10, 10, 0);
		float4 v2 = tex2D(s1, float2(triangle_x.y, triangle_y.y)) + float4(10, 10, 10, 0);
		float4 v3 = tex2D(s1, float2(triangle_x.z, triangle_y.z)) + float4(10, 10, 10, 0);
		
		float4 d1 = v1 - v2;
		float4 d2 = v2 - v3;
		float4 d3 = v3 - v1;
		
		float4 len = float4(length(d1.xy), length(d2.xy), length(d3.xy),0);
		float p = (len.x + len.y + len.z)*0.5;
		p = sqrt(p * (p-len.x) * (p-len.y) * (p-len.z));
		
		float h = (v1.z + v2.z + v3.z) * 0.33333;
		
		len = float4(length(d1.xyz), length(d2.xyz), length(d3.xyz), 0);
		float p3 = (len.x + len.y + len.z)*0.5;
		p3 = sqrt(p3 * (p3-len.x) * (p3-len.y) * (p3-len.z));

		float4 n = float4(normalize(cross(d1.xyz, d2.xyz)), p3);
		norm_field = n;
		len.x = -sign(n.z) * p * h;
		len.y = triangle_x.w;
		
		return len;
	}
	else
	{	
		norm_field = float4(1,0,0,0);
		return float4(0,0,0,0);
	}
}

technique volume_task < string params = "r_texdx_0"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 volume_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// pick mesh volume
////////////////////////////////////////////////////////////////////////////

float4 pick_volume_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 t1 = tex2D(s0, t);
	float4 t2 = tex2D(s0, t + float2(0, r_texdy_0));
	float4 t3 = tex2D(s0, t + float2(r_texdx_0, 0));
	float4 t4 = tex2D(s0, t + float2(r_texdx_0, r_texdy_0));
	
	float4 ret = float4(0,0,0,0);
	
	if (t1.y == r_mesh_id)
		ret += t1;
	
	if (t2.y == r_mesh_id)
		ret += t2;
	
	if (t3.y == r_mesh_id)
		ret += t3;
	
	if (t4.y == r_mesh_id)
		ret += t4;
	
	return ret;
}

technique pick_volume_task < string params = "r_texdx_0 r_texdy_0 r_mesh_id"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 pick_volume_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// sum volume lines
// (0, sum_lines)
// (1, volume.get_result)
////////////////////////////////////////////////////////////////////////////

float4 sum_volume_lines_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	//data[first_line + l] = aeris::vector(0, y, count);
	float4 line_desc = tex2D(s0, t);
	if (line_desc.x < 0)
		return float4(0,0,0,0);
		
	float4 ret = float4(0,0,0,0);
	
	for (float idx = 0; idx < line_desc.z; idx++)
	{
		ret.xyz += tex2Dlod(s1, float4(line_desc.x + idx * r_texdx_1, line_desc.y, 0, 0)).xyz;
		ret.w += 1;
	}
	
	return ret;
}

technique sum_volume_lines_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 sum_volume_lines_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// sum volume
////////////////////////////////////////////////////////////////////////////

float4 sum_volume_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 sum = tex2D(s0, t + float2(0.1 * r_texdx_0, 0));
//	sum.z = t.x;
//	return sum;
	
	float4 volume = float4(0,0,0,0);
	
	for (float idx = 0; idx < sum.y; idx++)
	{
		volume.xw += tex2Dlod(s1, float4(idx * r_texdx_1 + sum.x, 0, 0, 0)).xw;
	}
	
	if (sum.z > 0)
		volume.y = sum.z / volume.x;
	else
		volume.y = 1;
		
//	volume.z = sum.x;
		
	return volume;
}

technique sum_volume_task < string params = "r_texdx_1 r_texdx_0"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 sum_volume_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// spring forces
////////////////////////////////////////////////////////////////////////////

float4 calc_force(float4 x1, float4 x2, float4 v1, float4 v2, float4 props)
{
	float3 x = x2.xyz - x1.xyz;

	float len = length(x);
	float f = (len - props.x) * props.y - props.z * (dot(x.xyz, (v1-v2).xyz)) / len;
	return float4(normalize(x) * f, abs(f));
}

float4 spring_forces_ps(in float2 t : TEXCOORD0) : COLOR
{
	r_frame_dt;

	float4 ends = tex2D(s0, t);
	float4 props = tex2D(s0, t + float2(r_texdx_0, 0));
	
	float4 p1 = tex2D(s1, ends.xy);
	float4 p2 = tex2D(s1, ends.zw);
	float4 v1 = tex2D(s2, ends.xy);
	float4 v2 = tex2D(s2, ends.zw);
	
	props.z = 0.3;
	
	float4 f1 = calc_force(p1, p2, v1, v2, props);
	p1 = p1 + v1 * r_frame_dt;
	p2 = p2 + v2 * r_frame_dt;
	
	float4 f2 = calc_force(p1, p2, v1, v2, props);
	
	f1 = (f1 + f2) * 0.5;
	
	return f1;
}

technique spring_forces_task < string params = "r_texdx_0 r_frame_dt"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 spring_forces_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// sum forces
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//	(0, m_CalculateSpringsTask.GetResult())
//	(1, m_SumAddrTexture)
//	(2, m_SumSpringsTexture)
//	(3, m_NormalTexture)
//	(4, m_PressureTexture)
////////////////////////////////////////////////////////////////////////////

float4x4 r_camera = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};

float4 sum_forces_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 base = tex2D(s1, t);
	float4 vars = tex2D(s5, t);
	
	float4 pressure = tex2D(s4, float2(r_texdx_4 * (vars.w + 0.1),0));
	
	float4 result = float4(0,0,0,0);

	while (base.z >= 0)
	{	
		float4 force_address = tex2Dlod(s2, float4(base.xy, 0, 0));
		result += tex2Dlod(s0, float4(force_address.xy,0,0)) * force_address.z;
		
		base += float4(r_texdx_2, 0, -1.0, 0);
/*		
		if ()
			break;*/
	}
	
	float4 norm = tex2D(s3, t);
	float4 gravity = mul(r_camera, float4(0, -0.8, 0, 0));
	
	float inside_pressure = 170.7f;
	float outside_pressure =0.f;

	float fpress = ((pressure.y) * inside_pressure - outside_pressure) * 10.0f;
	if (fpress < 0)
		fpress = 0;

	result += norm * fpress * norm.w;
	result += gravity;
	
	return result;
}

technique sum_forces_task < string params = "r_camera r_texdx_2 r_texdx_4"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 sum_forces_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// update velocity and position
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//	(0, m_VelocityTexture) COLOR1 = m_TargetVelocity
//	(1, m_PositionTexture) COLOR0 = m_TargetPosition
//	(2, sum_forces_task.GetResult())
//	(3, m_CalculateVerticesCollisionsTask.GetResult())
////////////////////////////////////////////////////////////////////////////

float4 r_box_min = {-3.0, -3.0, -3.0, 1.0};
float4 r_box_max = {3.0, 3.0, 3.0, 1.0};

void collide(in out float4 v, float4 c)
{
	float dvc = dot(v.xyz, c.xyz);
//	if (dvc < 0)
	{
		float4 vc = c * dvc;
		v = v - vc;
		
/*		float lvc = length(vc.xyz);
		
		if (lvc > 1)
			v = v - 1.7 * vc;
		else
			v = v + c;*/
	}

	v = v + 1.1 * c;
}

float4 apply_forces_ps(in float2 t : TEXCOORD0, out float4 velocity : COLOR1) : COLOR0
{
	float4 currV = tex2D(s0, t);
	float4 currP = tex2D(s1, t);
	float4 currF = tex2D(s2, t);
	float4 collision = tex2D(s3, t);
	
	collide(currV, collision);
	
	currV = currV + currF * r_frame_dt;
	
	float4 nextP = currP + currV * r_frame_dt; //currently m = 1
	
	float4 smax = sign(r_box_max - nextP);
	float4 smin = sign(nextP - r_box_min);
	
	float4 oldV = currV;
	currV = currV * smin;
	currV = currV * smax;
	
//	currV *= 1.01;

	float4 np = nextP;
		
	nextP = nextP + (one - smax) * (r_box_max - nextP);
	nextP = nextP + (one - smin) * (r_box_min - nextP);
	
	float3 o = one.xyz - (one.xyz * 4 - (smax.yzx + smax.zxy + smin.yzx + smin.zxy)) * op_scale;
	currV.xyz = currV.xyz * o;
	
/*	if (length((np - nextP).xyz) > 0.01)
	{
		currV *= 0.98f;
	}
	else
	{
		currV *= 1;
	}
*/	
	velocity = currV;
	return nextP;
}

technique apply_forces_task < string params = "r_box_max r_box_min r_frame_dt"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 apply_forces_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// sum norms
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//	(0, m_TriangleFields)
//	(1, m_SumNormAddrTexture)
//	(2, m_SumNormTexture)
//	out = norm.xyz, field
////////////////////////////////////////////////////////////////////////////

float4 sum_norm_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 base = tex2D(s1, t);
	
	float4 result = float4(0,0,0,0);

	for (float i = 0; i < base.z; i++)
	{	
		float4 norm_address = tex2Dlod(s2, float4(base.xy, 0, 0));
		result += tex2Dlod(s0, float4(norm_address.xy, 0, 0));
		
		base.x += r_texdx_2;
//		base += float4(r_texdx_2, 0, -1.0, 0);
	}
	
	result.xyz = -normalize(result.xyz);
	result.w *= 0.3333;
	
	return result;
}

technique sum_norm_task < string params = "r_texdx_2"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 sum_norm_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

