float4x4 r_world = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_world_normal = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_projection = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
float4x4 r_projection_view = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};

sampler sa0 : register(s0);
sampler sa1 : register(s1);
sampler sa2 : register(s2);

////////////////////////////////////////////////////////////////////////////
// terrain
////////////////////////////////////////////////////////////////////////////

float4 light1_pos = {20,20,40,1};
float4 light2_pos = {-20,-40,20,1};
float4 r_view_pos = {0, 0, 0, 0};

float r_texdx_257 = 0; //vertex texture 0
float r_texdy_257 = 0; //vertex texture 0

float r_texdx_0 = 0; //texture 0
float r_texdy_0 = 0; //texture 0

float r_grid_size = 1;

struct VS_TERRAIN_INPUT
{
    float4 m_position		: POSITION;
    float3 m_norm			: NORMAL;
};

struct VS_TERRAIN_OUTPUT
{
    float4 m_position		: POSITION;
    float3 m_start_pos		: TEXCOORD0;
    float3 m_pos			: TEXCOORD1;
    float2 m_tex			: TEXCOORD2;
};

float sample_level(float2 pos)
{
	return tex2Dlod(sa0, float4(pos, 0, 0)).x * 2.0f;
}

float sample_level_ps(float2 pos)
{
	return tex2Dlod(sa2, float4(pos, 0, 0)).x * 2.0f;
}

float terrain_vertex_scale(float3 pos)
{
	return 500.f;

/*	return 1.0f / cos(d * 1.57);*/
}

float2 get_sample_coord(float3 pos)
{
	return pos.xz * 0.0003 + float2(0.5, 0.5);
}

float3 snap_to_grid(float3 pos, float scale)
{
	scale = r_grid_size / scale;
	return float3(pos.x - frac(pos.x * scale) / scale, 0, pos.z - frac(pos.z * scale) / scale);
}

VS_TERRAIN_OUTPUT terrain_vs(const VS_TERRAIN_INPUT v)
{
    VS_TERRAIN_OUTPUT o = (VS_TERRAIN_OUTPUT) 0;
    
    float scale = terrain_vertex_scale(v.m_position.xyz);
    
    float3 start_position = snap_to_grid(v.m_position.xyz * scale + r_view_pos.xyz, scale);
	
	float4 pos = mul(float4(start_position, 1.0), r_world);
	
	o.m_start_pos = pos.xyz;
	float2 sample_coord = get_sample_coord(pos.xyz);

	pos.y = sample_level(sample_coord);
	
	float dx = 0.1f;
	
	float level00 = sample_level(get_sample_coord(pos.xyz + float3(-dx, 0, -dx)));
	float level10 = sample_level(get_sample_coord(pos.xyz + float3(dx, 0, -dx)));
	float level01 = sample_level(get_sample_coord(pos.xyz + float3(-dx, 0, dx)));
	float level11 = sample_level(get_sample_coord(pos.xyz + float3(dx, 0, dx)));
	
	float3 ds00 = float3(-dx, level00 - pos.y, -dx);
	float3 ds10 = float3(dx, level10 - pos.y, -dx);
	float3 ds01 = float3(-dx, level01 - pos.y, dx);
	float3 ds11 = float3(dx, level11 - pos.y, dx);
	
	float3 norm = normalize(cross(ds00, ds10) + cross(ds10, ds11) + cross(ds11, ds01) + cross(ds01, ds00));
	
	o.m_pos = pos.xyz;
	
	o.m_position = mul(pos, r_projection_view);
	o.m_tex = sample_coord;
	
    return o;
}

float r_use_ps_norm = 0;

float4 terrain_ps(in float3 pos : TEXCOORD1, in float2 tex : TEXCOORD2, float3 start_pos : TEXCOORD0) : COLOR
{
	float3 to_l1 = normalize(light1_pos - pos);
	float3 to_l2 = normalize(light2_pos - pos);
	
	float dx = 0.3;
	
	float2 sample_coord = get_sample_coord(start_pos);

	float level = sample_level_ps(sample_coord);
	float level00 = sample_level_ps(get_sample_coord(start_pos + float3(-dx, 0, -dx)));
	float level10 = sample_level_ps(get_sample_coord(start_pos + float3(dx, 0, -dx)));
	float level01 = sample_level_ps(get_sample_coord(start_pos + float3(-dx, 0, dx)));
	float level11 = sample_level_ps(get_sample_coord(start_pos + float3(dx, 0, dx)));
	
	float3 ds00 = float3(-dx, level00 - level, -dx);
	float3 ds10 = float3(dx, level10 - level, -dx);
	float3 ds01 = float3(-dx, level01 - level, dx);
	float3 ds11 = float3(dx, level11 - level, dx);
	
	float3 norm = normalize(cross(ds00, ds10) + cross(ds10, ds11) + cross(ds11, ds01) + cross(ds01, ds00));
	
	float3 r_l1 = normalize(reflect(to_l1, norm));
	float3 r_l2 = normalize(reflect(to_l2, norm));
	
	float3 to_cam = normalize(r_view_pos - pos);
	float s1 = dot(r_l1, to_cam);
	float s2 = dot(r_l2, to_cam);

	s1 = max(s1, 0);
	s2 = max(s2, 0);

	s1 = s1 * s1;
	s1 = s1 * s1;
	s1 = s1 * s1;
	s1 = s1 * s1;
	s1 = s1 * s1;
	
	s2 = s2 * s2;
	s2 = s2 * s2;
	s2 = s2 * s2;
	s2 = s2 * s2;
	s2 = s2 * s2;
	
	
	float l1 = dot(to_l1, norm) * 0.5;
	float l2 = dot(to_l2, norm) * 0.5;
	
	l1 = max(l1, 0);
	l2 = max(l2, 0);
	
	float l = l1 + l2 + s1 + s2;
	tex.x = tex.x * r_texdx_0 / r_texdx_257;
	tex.y = tex.y * r_texdy_0 / r_texdy_257;
	
	float t = (-norm.y - 0.65) * 20;
	t = clamp(t, 0, 1);
	
	float4 tc = tex2D(sa0, tex);
	
	return (l * 0.6 + 0.4) * float4(1,1,1,1) * tc;
}

technique terrain <string params = "r_use_ps_norm r_grid_size r_texdx_257 r_texdy_257 r_texdx_0 r_texdy_0 r_view_pos r_projection_view r_world r_world_normal";>
{
	pass P0
	{
        VertexShader = compile vs_3_0 terrain_vs();
		PixelShader = compile ps_3_0 terrain_ps();
	    CullMode = CCW;
	    CullMode = NONE;
		ZEnable = TRUE;
	}
}

