#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Game options state (redefine keys, etc).
; ----------------------------------------------------------------------------

#if LANG=LANG_EN
txp1start	.db "1 ONE PLAYER", 0
txp2start	.db "2 TWO PLAYER", 0
txplayer1ink	.db "3 PLAYER 1: KEYBOARD", 0
txplayer1ins1	.db "3 PLAYER 1: SINCLAIR", 0
txplayer1inke	.db "3 PLAYER 1: KEMPSTON", 0
txplayer2ink	.db "4 PLAYER 2: KEYBOARD ", 0
txplayer2ins1	.db "4 PLAYER 2: SINCLAIR", 0
txplayer2inke	.db "4 PLAYER 2: KEMPSTON", 0
txredefine	.db "5 REDEFINE KEYS", 0

OPTIONS_TX_X	.equ (ARAMW - 20) / 2
#else
txp1start	.db "1 UN JUGADOR", 0
txp2start	.db "2 DOS JUGADORES", 0
txplayer1ink	.db "3 JUGADOR 1: TECLADO ", 0
txplayer1ins1	.db "3 JUGADOR 1: SINCLAIR", 0
txplayer1inke	.db "3 JUGADOR 1: KEMPSTON", 0
txplayer2ink	.db "4 JUGADOR 2: TECLADO ", 0
txplayer2ins1	.db "4 JUGADOR 2: SINCLAIR", 0
txplayer2inke	.db "4 JUGADOR 2: KEMPSTON", 0
txredefine	.db "5 REDEFINIR TECLAS", 0

OPTIONS_TX_X	.equ (ARAMW - 21) / 2
#endif

txp1inputs	.dw txplayer1ink
		.dw txplayer1ins1
		.dw txplayer1inke

txp2inputs	.dw txplayer2ink
		.dw txplayer2ins1
		.dw txplayer2inke

options_code	.db ICLS, PBLUE
		.db ITEXT, PBLUE|CYAN, ARAMW-TXCIDELSA_LEN, 23
			.dw txcidelsa_str
		.db IDRHLINE, 'C', PBLUE|GREEN, 0, 0, 31
		.db IDRVLINE, 'C', PBLUE|GREEN, 31, 1, 7
		.db IDRHLINE, 'C', PBLUE|GREEN, 8, 31, 0
		.db IDRVLINE, 'C', PBLUE|GREEN, 0, 7, 1
		.db ITEXT, PBLUE|WHITE, 5, 2,
			.dw txdefeat0
		.db ITEXT, PBLUE|WHITE, 5, 3
			.dw txdefeat1
		.db IIFBIRDK, 0
		.db ITEXT, PBLUE|WHITE, 5, 4
			.dw txdefeat2
		.db IENDIF
		.db IIFBIRDK, 1
		.db ITEXT, PBLUE|WHITE, 5, 4
			.dw txdefeat3
		.db ITEXT, PBLUE|YELLOW, 5, 6
			.dw txtop
		.db IENDIF
		.db IDRVLINE, 'C', PBLUE|GREEN, 31, 8, 22
		.db IDRHLINE, 'C', PBLUE|GREEN, 22, 30, 0
		.db IDRVLINE, 'C', PBLUE|GREEN, 0, 21, 8
		.db ISTOP

options_code2	.db ITEXT, PBLUE|WHITE, OPTIONS_TX_X, 11,
			.dw txp1start
		.db ITEXT, PBLUE|WHITE, OPTIONS_TX_X, 12,
			.dw txp2start
		.db ITEXT, PBLUE|WHITE, OPTIONS_TX_X, 13
p1intext		.dw txplayer1ink
		.db ITEXT, PBLUE|WHITE, OPTIONS_TX_X, 14
p2intext			.dw txplayer2ink
		.db ITEXT, PBLUE|WHITE, OPTIONS_TX_X, 15,
			.dw txredefine
		.db ISTOP

#if LANG=LANG_EN
txpress		.db "PRESS KEY FOR", 0
TXPRESS_X	.equ (ARAMW - 13)/2

txp1	.db "PLAYER 1", 0
txp2	.db "PLAYER 2", 0
TXPN_X	.equ (ARAMW - 8) / 2

txpkup	.db " UP  ", 0
txpkdo	.db "DOWN ", 0
txpkle	.db "LEFT ", 0
txpkri	.db "RIGHT", 0
txpkfi	.db "FIRE ", 0
TXKINFO_X	.equ (ARAMW - 5) / 2
#else
txpress		.db "PULSA TECLA PARA", 0
TXPRESS_X	.equ (ARAMW - 16)/2

txp1	.db "JUGADOR 1", 0
txp2	.db "JUGADOR 2", 0
TXPN_X	.equ (ARAMW - 9) / 2

txpkup	.db "  ARRIBA ", 0
txpkdo	.db "  ABAJO  ", 0
txpkle	.db "IZQUIERDA", 0
txpkri	.db " DERECHA ", 0
txpkfi	.db " DISPARO ", 0
TXKINFO_X	.equ (ARAMW - 9) / 2
#endif

redefine_table1
	.dw txpkup, p1keys+3
	.dw txpkdo, p1keys+2
	.dw txpkle, p1keys+1
	.dw txpkri, p1keys
	.dw txpkfi, p1keys+4
	.dw 0

redefine_table2
	.dw txpkup, p2keys+3
	.dw txpkdo, p2keys+2
	.dw txpkle, p2keys+1
	.dw txpkri, p2keys
	.dw txpkfi, p2keys+4
	.dw 0

; Index into the table redefine_table.
redefine_i	.db 0

pnkeys	.dw p1keys
	.dw p2keys

p1keys	.db KEY_K, KEY_H, KEY_J, KEY_U, KEY_A, KEY_S 
p2keys	.db KEY_K, KEY_H, KEY_J, KEY_U, KEY_A, KEY_S 

IN_KEYBOARD	.equ 0
IN_SINCLAIR	.equ 1
IN_KEMPSTON	.equ 2

p1input	.db IN_KEYBOARD
p2input	.db IN_KEYBOARD

input_types
	.dw poll_keyboard
	.dw poll_sinclair1
	.dw poll_kempston

OPTIONS_WTIME	.equ 65535
options_wtime	.dw 0

; ------------------
; 'enter_options_st'
; ------------------

enter_options_st
	call options_reset_wtime

; Set initial text for current controls.

	ld a,(p1input)
	ld hl,txp1inputs
	call getwt
	ld (p1intext),hl

	ld a,(p2input)
	ld hl,txp2inputs
	call getwt
	ld (p2intext),hl

; Run drawing machine.

	ld hl,options_code
	call mach_start
	call mach_update_till_end

	ld hl,options_code2
	call mach_start
	call mach_update_till_end
	ret

; -------------------
; 'update_options_st'
; -------------------

update_options_st

	call pollk
	call getkey
	or a
	jr z,update_options_chk_time

	cp KEY_1
	jr z,start_one_player
	cp KEY_2
	jr z,start_two_players
	cp KEY_3
	jr z,change_p1_input
	cp KEY_4
	jr z,change_p2_input
	cp KEY_5
	jr z,start_redefine
	
update_options_chk_time

; Check time to go to attract mode.

	ld hl,(options_wtime)
	dec hl
	ld (options_wtime),hl
	ld a,h
	or l
	ret nz

	ld a,STATE_ATTRACT
	call set_state
	ret

change_p1_input

	ld a,(p1input)
	call next_input
	ld (p1input),a
	ld hl,txp1inputs
	call getwt
	
	ld de,(13<<8)+OPTIONS_TX_X
	ld a,PBLUE|WHITE
	call drstr
	ret

change_p2_input

	ld a,(p2input)
	call next_input
	ld (p2input),a
	ld hl,txp2inputs
	call getwt
	
	ld de,(14<<8)+OPTIONS_TX_X
	ld a,PBLUE|WHITE
	call drstr
	ret

start_redefine
	call redefine
	call options_reset_wtime
	ret

start_two_players

; Set two player game.

	ld a,1
	ld (two_player_game),a

; Set player lifes.

	ld a,PLAYER_LIFES
	ld (lifesp1),a
	ld (lifesp2),a
	jr start_game

start_one_player

; Set one player game.

	xor a
	ld (two_player_game),a

; Set player lifes.

	ld a,PLAYER_LIFES
	ld (lifesp1),a
	xor a
	ld (lifesp2),a

start_game

; Player 1 starts.

	xor a
	ld (cur_player),a

; Reset levels.

	ld (levelp1),a
	ld (levelp2),a

; Reset bird killed.

	ld (bird_killed_cur_game),a

; Reset score.

	call rstscor

; Enter gameplay.

	ld a,STATE_ROUND
	call set_state
	ret

; ------------
; 'next_input'
; ------------
;	Given A IN_KEYBOARD, IN_SINCLAIR, IN_KEMPSTON, lets A as the next
; input type.
;
; In	A 0 - 2.
; Out	(A + 1) mod 3
; Saves	BC, DE, HL.

next_input
	inc a
	cp 3
	ret nz
	xor a
	ret

; ---------------------
; 'options_reset_wtime'
; ---------------------

options_reset_wtime
	ld hl,OPTIONS_WTIME
	ld (options_wtime),hl
	ret

; ----------
; 'redefine'
; ----------

redefine
	call kfeedbk

	ld hl,txpress
	ld de,(18<<8)+TXPRESS_X
	ld a,PBLUE|YELLOW
	call drstr

	ld hl,txp1
	ld de,(17<<8)+TXPN_X
	ld a,PBLUE|YELLOW
	call drstr

	ld hl,redefine_table1
	call redefine_loop

	ld hl,txp2
	ld de,(17<<8)+TXPN_X
	ld a,PBLUE|YELLOW
	call drstr

	ld hl,redefine_table2
	call redefine_loop

	ld a,PBLUE
	ld de,1+(17<<8)
	ld bc,ARAMW-2+(4<<8)
	call clrwin
	ret

redefine_loop

; Load text address, or 0 if end.

	ld e,(hl)
	inc hl
	ld d,(hl)
	ld a,d
	or e
	jr z,redefine_end
	inc hl
	push hl
	
; Draw the info text.

	ex de,hl
	ld de,(20<<8)+TXKINFO_X
	ld a,PBLUE|YELLOW
	call drstr

; Load key config address for player.

	pop hl
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl

redefine_wkey

; Wait for a key.

	push bc
	push hl
	call pollk
	pop hl
	pop bc
	call getkey
	jr z,redefine_wkey

; Save key.

	ld (bc),a

; Some feedback.

	call kfeedbk
	jr redefine_loop

redefine_end
	ret

