/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.GLArrayDataClient;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import java.nio.Buffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLException;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLArrayHandlerInterleaved;
import jogamp.opengl.util.GLDataArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandlerInterleaved;

public class GLArrayDataServer
extends GLArrayDataClient
implements GLArrayDataEditable {
    private int interleavedOffset = 0;

    public static GLArrayDataServer createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n, n2, n3, bl, n4, buffer, buffer.limit(), false, gLFixedArrayHandler, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixed(int n, int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n, n2, n3, bl, 0, null, n4, false, gLFixedArrayHandler, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n, n2, bl, 0, null, n3, true, gLSLArrayHandler, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n, n2, bl, n3, buffer, buffer.limit(), true, gLSLArrayHandler, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n, int n2, int n3, Buffer buffer, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n, n2, false, n3, buffer, buffer.limit(), false, gLDataArrayHandler, 0, 0L, n4, n5, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n, int n2, int n3, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n, n2, false, 0, null, n3, false, gLDataArrayHandler, 0, 0L, n4, n5, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, false, 0, null, n3, false, gLArrayHandlerInterleaved, 0, 0L, n4, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, n3, buffer, buffer.limit(), false, gLArrayHandlerInterleaved, 0, 0L, n4, 34962, false);
        return gLArrayDataServer;
    }

    public GLArrayData addFixedSubArray(int n, int n2, int n3) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n4 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n4 + " > " + this.getComponentCount() + ")");
        }
        if (this.usesGLSL) {
            throw new GLException("buffer uses GLSL");
        }
        GLArrayDataWrapper gLArrayDataWrapper = GLArrayDataWrapper.createFixed(n, n2, this.getComponentType(), this.getNormalized(), this.getStride(), this.getBuffer(), this.getVBOName(), this.interleavedOffset, this.getVBOUsage(), n3);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n2 * this.getComponentSizeInBytes();
        if (34962 == n3) {
            this.glArrayHandler.addSubHandler(new GLFixedArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, false, 0, null, n3, false, gLSLArrayHandlerInterleaved, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, n3, buffer, buffer.limit(), false, gLSLArrayHandlerInterleaved, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public GLArrayData addGLSLSubArray(String string, int n, int n2) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n3 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n3 + " > " + this.getComponentCount() + ")");
        }
        if (!this.usesGLSL) {
            throw new GLException("buffer uses fixed function");
        }
        GLArrayDataWrapper gLArrayDataWrapper = GLArrayDataWrapper.createGLSL(string, n, this.getComponentType(), this.getNormalized(), this.getStride(), this.getBuffer(), this.getVBOName(), this.interleavedOffset, this.getVBOUsage(), n2);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n * this.getComponentSizeInBytes();
        if (34962 == n2) {
            this.glArrayHandler.addSubHandler(new GLSLArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public final void setInterleavedOffset(int n) {
        this.interleavedOffset = n;
    }

    public final int getInterleavedOffset() {
        return this.interleavedOffset;
    }

    @Override
    public void destroy(GL gL) {
        int n = this.vboName;
        super.destroy(gL);
        if (n != 0) {
            int[] nArray = new int[]{n};
            gL.glDeleteBuffers(1, nArray, 0);
            this.vboName = 0;
        }
    }

    @Override
    public void setVBOEnabled(boolean bl) {
        this.checkSeal(false);
        super.setVBOEnabled(bl);
    }

    @Override
    public String toString() {
        return "GLArrayDataServer[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", usesGLSL " + this.usesGLSL + ", usesShaderState " + (null != this.shaderState) + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.components + ", stride " + this.strideB + "b " + this.strideL + "c" + ", initialElementCount " + this.initialElementCount + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    @Override
    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, boolean bl2, GLArrayHandler gLArrayHandler, int n6, long l, int n7, int n8, boolean bl3) throws GLException {
        super.init(string, n, n2, n3, bl, n4, buffer, n5, bl2, gLArrayHandler, n6, l, n7, n8, bl3);
        this.vboEnabled = true;
    }

    @Override
    protected void init_vbo(GL gL) {
        super.init_vbo(gL);
        if (this.vboEnabled && this.vboName == 0) {
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            this.vboName = nArray[0];
            if (0 < this.interleavedOffset) {
                this.glArrayHandler.setSubArrayVBOName(this.vboName);
            }
        }
    }

    protected GLArrayDataServer() {
    }

    public GLArrayDataServer(GLArrayDataServer gLArrayDataServer) {
        super(gLArrayDataServer);
        this.interleavedOffset = gLArrayDataServer.interleavedOffset;
    }
}

