/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;

public class PinkNoise
implements AudioSignal {
    protected float amp;
    protected float pan;
    protected float leftScale;
    protected float rightScale;
    private int maxKey;
    private int key;
    private int range;
    private float[] whiteValues;
    private float maxSumEver;

    public PinkNoise() {
        this.amp = 1.0f;
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.initPink();
    }

    public PinkNoise(float f) {
        this.setAmp(f);
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.initPink();
    }

    public void setAmp(float f) {
        this.amp = this.constrain(f, 0.0f, 1.0f);
    }

    public void setPan(float f) {
        this.pan = this.constrain(f, -1.0f, 1.0f);
        this.calcLRScale();
    }

    @Override
    public void generate(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.amp * this.pink();
        }
    }

    @Override
    public void generate(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.leftScale * this.amp * this.pink();
            fArray2[i] = this.rightScale * this.amp * this.pink();
        }
    }

    private void initPink() {
        this.maxKey = 31;
        this.range = 128;
        this.maxSumEver = 90.0f;
        this.key = 0;
        this.whiteValues = new float[6];
        for (int i = 0; i < 6; ++i) {
            this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
        }
    }

    private float pink() {
        int n = this.key++;
        if (this.key > this.maxKey) {
            this.key = 0;
        }
        int n2 = n ^ this.key;
        float f = 0.0f;
        for (int i = 0; i < 6; ++i) {
            if ((n2 & 1 << i) != 0) {
                this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
            }
            f += this.whiteValues[i];
        }
        if (f > this.maxSumEver) {
            this.maxSumEver = f;
        }
        f = 2.0f * (f / this.maxSumEver) - 1.0f;
        return f;
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }
}

