/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.javasound.FloatSampleTools;
import javax.sound.sampled.AudioFormat;

public class FloatSampleBuffer {
    private static final boolean LAZY_DEFAULT = true;
    private Object[] channels = new Object[2];
    private int sampleCount = 0;
    private int channelCount = 0;
    private float sampleRate = 0.0f;
    private int originalFormatType = 0;
    public static final int DITHER_MODE_AUTOMATIC = 0;
    public static final int DITHER_MODE_ON = 1;
    public static final int DITHER_MODE_OFF = 2;
    private float ditherBits = 0.7f;
    private int ditherMode = 0;
    private AudioFormat lastConvertToByteArrayFormat = null;
    private int lastConvertToByteArrayFormatCode = 0;

    public FloatSampleBuffer() {
        this(0, 0, 1.0f);
    }

    public FloatSampleBuffer(int n, int n2, float f) {
        this.init(n, n2, f, true);
    }

    public FloatSampleBuffer(byte[] byArray, int n, int n2, AudioFormat audioFormat) {
        this(audioFormat.getChannels(), n2 / (audioFormat.getSampleSizeInBits() / 8 * audioFormat.getChannels()), audioFormat.getSampleRate());
        this.initFromByteArray(byArray, n, n2, audioFormat);
    }

    public void init(int n, int n2, float f) {
        this.init(n, n2, f, true);
    }

    public void init(int n, int n2, float f, boolean bl) {
        if (n < 0 || n2 < 0 || f <= 0.0f) {
            throw new IllegalArgumentException("invalid parameters in initialization of FloatSampleBuffer.");
        }
        this.setSampleRate(f);
        if (this.sampleCount != n2 || this.channelCount != n) {
            this.createChannels(n, n2, bl);
        }
    }

    public static void checkFormatSupported(AudioFormat audioFormat) {
        FloatSampleTools.getFormatType(audioFormat);
    }

    private final void grow(int n, boolean bl) {
        if (this.channels.length < n || !bl) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.channels, 0, objectArray, 0, this.channelCount < n ? this.channelCount : n);
            this.channels = objectArray;
        }
    }

    private final void createChannels(int n, int n2, boolean bl) {
        if (bl && n <= this.channelCount && n2 <= this.sampleCount) {
            this.setSampleCountImpl(n2);
            this.setChannelCountImpl(n);
            return;
        }
        this.setSampleCountImpl(n2);
        this.grow(n, true);
        this.setChannelCountImpl(0);
        for (int i = 0; i < n; ++i) {
            this.insertChannel(i, false, bl);
        }
        this.grow(n, bl);
    }

    public void initFromByteArray(byte[] byArray, int n, int n2, AudioFormat audioFormat) {
        this.initFromByteArray(byArray, n, n2, audioFormat, true);
    }

    public void initFromByteArray(byte[] byArray, int n, int n2, AudioFormat audioFormat, boolean bl) {
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.initFromByteArray: buffer too small.");
        }
        int n3 = n2 / audioFormat.getFrameSize();
        this.init(audioFormat.getChannels(), n3, audioFormat.getSampleRate(), bl);
        this.originalFormatType = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.byte2float(byArray, n, this.channels, 0, this.sampleCount, audioFormat);
    }

    public void initFromFloatSampleBuffer(FloatSampleBuffer floatSampleBuffer) {
        this.init(floatSampleBuffer.getChannelCount(), floatSampleBuffer.getSampleCount(), floatSampleBuffer.getSampleRate());
        for (int i = 0; i < this.getChannelCount(); ++i) {
            System.arraycopy(floatSampleBuffer.getChannel(i), 0, this.getChannel(i), 0, this.sampleCount);
        }
    }

    public int writeByteBuffer(byte[] byArray, int n, AudioFormat audioFormat, int n2, int n3) {
        int n4;
        if (n2 + n3 > this.getSampleCount()) {
            n3 = this.getSampleCount() - n2;
        }
        if ((n4 = audioFormat.getChannels()) > this.getChannelCount()) {
            n4 = this.getChannelCount();
        }
        if (n4 > audioFormat.getChannels()) {
            n4 = audioFormat.getChannels();
        }
        for (int i = 0; i < n4; ++i) {
            float[] fArray = this.getChannel(i);
            FloatSampleTools.byte2floatGeneric(byArray, n, audioFormat.getFrameSize(), fArray, n2, n3, audioFormat);
            n += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        return n3;
    }

    public void reset() {
        this.init(0, 0, 1.0f, false);
    }

    public void reset(int n, int n2, float f) {
        this.init(n, n2, f, false);
    }

    public int getByteArrayBufferSize(AudioFormat audioFormat) {
        return this.getByteArrayBufferSize(audioFormat, this.getSampleCount());
    }

    public int getByteArrayBufferSize(AudioFormat audioFormat, int n) {
        FloatSampleBuffer.checkFormatSupported(audioFormat);
        return audioFormat.getFrameSize() * n;
    }

    public int convertToByteArray(byte[] byArray, int n, AudioFormat audioFormat) {
        return this.convertToByteArray(0, this.getSampleCount(), byArray, n, audioFormat);
    }

    public int convertToByteArray(int n, int n2, byte[] byArray, int n3, AudioFormat audioFormat) {
        int n4 = audioFormat.getFrameSize() * n2;
        if (n3 + n4 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: buffer too small.");
        }
        if (audioFormat != this.lastConvertToByteArrayFormat) {
            if (audioFormat.getSampleRate() != this.getSampleRate()) {
                throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different samplerates.");
            }
            if (audioFormat.getChannels() != this.getChannelCount()) {
                throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different channel count.");
            }
            this.lastConvertToByteArrayFormat = audioFormat;
            this.lastConvertToByteArrayFormatCode = FloatSampleTools.getFormatType(audioFormat);
        }
        FloatSampleTools.float2byte(this.channels, n, byArray, n3, n2, this.lastConvertToByteArrayFormatCode, audioFormat.getChannels(), audioFormat.getFrameSize(), this.getConvertDitherBits(this.lastConvertToByteArrayFormatCode));
        return n4;
    }

    public byte[] convertToByteArray(AudioFormat audioFormat) {
        byte[] byArray = new byte[this.getByteArrayBufferSize(audioFormat)];
        this.convertToByteArray(byArray, 0, audioFormat);
        return byArray;
    }

    public void changeSampleCount(int n, boolean bl) {
        int n2 = this.getSampleCount();
        if (n2 >= n) {
            this.setSampleCountImpl(n);
            return;
        }
        if (this.channelCount == 1 || this.channelCount == 2) {
            float[] fArray;
            float[] fArray2 = this.getChannel(0);
            if (fArray2.length < n) {
                fArray = new float[n];
                if (bl && n2 > 0) {
                    System.arraycopy(fArray2, 0, fArray, 0, n2);
                }
                this.channels[0] = fArray;
            } else if (bl) {
                for (int i = n2; i < n; ++i) {
                    fArray2[i] = 0.0f;
                }
            }
            if (this.channelCount == 2) {
                fArray2 = this.getChannel(1);
                if (fArray2.length < n) {
                    fArray = new float[n];
                    if (bl && n2 > 0) {
                        System.arraycopy(fArray2, 0, fArray, 0, n2);
                    }
                    this.channels[1] = fArray;
                } else if (bl) {
                    for (int i = n2; i < n; ++i) {
                        fArray2[i] = 0.0f;
                    }
                }
            }
            this.setSampleCountImpl(n);
            return;
        }
        Object[] objectArray = null;
        if (bl) {
            objectArray = this.getAllChannels();
        }
        this.init(this.getChannelCount(), n, this.getSampleRate());
        if (bl) {
            int n3 = n < n2 ? n : n2;
            for (int i = 0; i < this.channelCount; ++i) {
                float[] fArray = (float[])objectArray[i];
                float[] fArray3 = (float[])this.channels[i];
                if (fArray != fArray3) {
                    System.arraycopy(fArray, 0, fArray3, 0, n3);
                }
                if (n2 >= n) continue;
                for (int j = n2; j < n; ++j) {
                    fArray3[j] = 0.0f;
                }
            }
        }
    }

    public void makeSilence() {
        this.makeSilence(0, this.getSampleCount());
    }

    public void makeSilence(int n, int n2) {
        if (n < 0 || n2 + n > this.getSampleCount() || n2 < 0) {
            throw new IllegalArgumentException("offset and/or sampleCount out of bounds");
        }
        int n3 = this.getChannelCount();
        for (int i = 0; i < n3; ++i) {
            this.makeSilence(this.getChannel(i), n, n2);
        }
    }

    public void makeSilence(int n) {
        this.makeSilence(n, 0, this.getSampleCount());
    }

    public void makeSilence(int n, int n2, int n3) {
        if (n2 < 0 || n3 + n2 > this.getSampleCount() || n3 < 0) {
            throw new IllegalArgumentException("offset and/or sampleCount out of bounds");
        }
        this.makeSilence(this.getChannel(n), n2, n3);
    }

    private void makeSilence(float[] fArray, int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            fArray[i] = 0.0f;
        }
    }

    public void linearFade(float f, float f2) {
        this.linearFade(f, f2, 0, this.getSampleCount());
    }

    public void linearFade(float f, float f2, int n, int n2) {
        for (int i = 0; i < this.getChannelCount(); ++i) {
            this.linearFade(i, f, f2, n, n2);
        }
    }

    public void linearFade(int n, float f, float f2, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        float f3 = n3 + n2;
        float f4 = (f2 - f) / (float)n3;
        float[] fArray = this.getChannel(n);
        float f5 = f;
        int n4 = n2;
        while ((float)n4 < f3) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] * f5;
            f5 += f4;
        }
    }

    public void addChannel(boolean bl) {
        this.insertChannel(this.getChannelCount(), bl);
    }

    public void insertChannel(int n, boolean bl) {
        this.insertChannel(n, bl, true);
    }

    public void insertChannel(int n, boolean bl, boolean bl2) {
        int n2;
        this.grow(this.channelCount + 1, true);
        int n3 = this.channels.length;
        int n4 = this.channelCount;
        float[] fArray = null;
        if (n3 > n4) {
            for (n2 = n4; n2 < n3; ++n2) {
                float[] fArray2 = (float[])this.channels[n2];
                if (fArray2 == null || (!bl2 || fArray2.length < this.getSampleCount()) && (bl2 || fArray2.length != this.getSampleCount())) continue;
                fArray = fArray2;
                this.channels[n2] = null;
                break;
            }
        }
        if (fArray == null) {
            fArray = new float[this.getSampleCount()];
        }
        for (n2 = n; n2 < n4; ++n2) {
            this.channels[n2 + 1] = this.channels[n2];
        }
        this.channels[n] = fArray;
        this.setChannelCountImpl(this.channelCount + 1);
        if (bl) {
            this.makeSilence(n);
        }
        this.grow(this.channelCount, bl2);
    }

    public void removeChannel(int n) {
        this.removeChannel(n, true);
    }

    public void removeChannel(int n, boolean bl) {
        float[] fArray = (float[])this.channels[n];
        for (int i = n; i < this.channelCount - 1; ++i) {
            this.channels[i] = this.channels[i + 1];
        }
        if (!bl) {
            this.grow(this.channelCount - 1, true);
        } else {
            this.channels[this.channelCount - 1] = fArray;
        }
        this.setChannelCountImpl(this.channelCount - 1);
    }

    public void copyChannel(int n, int n2) {
        float[] fArray = this.getChannel(n);
        float[] fArray2 = this.getChannel(n2);
        System.arraycopy(fArray, 0, fArray2, 0, this.getSampleCount());
    }

    public void copyChannel(int n, int n2, int n3, int n4, int n5) {
        float[] fArray = this.getChannel(n);
        float[] fArray2 = this.getChannel(n3);
        System.arraycopy(fArray, n2, fArray2, n4, n5);
    }

    public void copy(int n, int n2, int n3) {
        int n4 = this.getChannelCount();
        for (int i = 0; i < n4; ++i) {
            this.copy(i, n, n2, n3);
        }
    }

    public void copy(int n, int n2, int n3, int n4) {
        float[] fArray = this.getChannel(n);
        int n5 = this.getSampleCount();
        if (n2 + n4 > n5 || n3 + n4 > n5 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IndexOutOfBoundsException("parameters exceed buffer size");
        }
        System.arraycopy(fArray, n2, fArray, n3, n4);
    }

    public void expandChannel(int n) {
        if (this.getChannelCount() != 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: can only expand channels for mono signals.");
        }
        for (int i = 1; i < n; ++i) {
            this.addChannel(false);
            this.copyChannel(0, i);
        }
    }

    public void mixDownChannels() {
        float[] fArray = this.getChannel(0);
        int n = this.getSampleCount();
        for (int i = this.getChannelCount() - 1; i > 0; --i) {
            float[] fArray2 = this.getChannel(i);
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                fArray[n2] = fArray[n2] + fArray2[j];
            }
            this.removeChannel(i);
        }
    }

    public void mix(FloatSampleBuffer floatSampleBuffer) {
        int n;
        int n2 = this.getSampleCount();
        if (n2 > floatSampleBuffer.getSampleCount()) {
            n2 = floatSampleBuffer.getSampleCount();
        }
        if ((n = this.getChannelCount()) > floatSampleBuffer.getChannelCount()) {
            n = floatSampleBuffer.getChannelCount();
        }
        for (int i = 0; i < n; ++i) {
            float[] fArray = this.getChannel(i);
            float[] fArray2 = floatSampleBuffer.getChannel(i);
            for (int j = 0; j < n2; ++j) {
                int n3 = j;
                fArray[n3] = fArray[n3] + fArray2[j];
            }
        }
    }

    public void mix(FloatSampleBuffer floatSampleBuffer, int n, int n2, int n3) {
        int n4 = this.getChannelCount();
        for (int i = 0; i < n4; ++i) {
            float[] fArray = this.getChannel(i);
            float[] fArray2 = floatSampleBuffer.getChannel(i);
            for (int j = 0; j < n3; ++j) {
                int n5 = j + n2;
                fArray[n5] = fArray[n5] + fArray2[j + n];
            }
        }
    }

    public int copyTo(FloatSampleBuffer floatSampleBuffer, int n, int n2) {
        return this.copyTo(0, floatSampleBuffer, n, n2);
    }

    public int copyTo(int n, FloatSampleBuffer floatSampleBuffer, int n2, int n3) {
        int n4;
        if (n + n3 > this.getSampleCount()) {
            n3 = this.getSampleCount() - n;
        }
        if (n3 + n2 > floatSampleBuffer.getSampleCount()) {
            n3 = floatSampleBuffer.getSampleCount() - n2;
        }
        if ((n4 = this.getChannelCount()) > floatSampleBuffer.getChannelCount()) {
            n4 = floatSampleBuffer.getChannelCount();
        }
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(this.getChannel(i), n, floatSampleBuffer.getChannel(i), n2, n3);
        }
        return n3;
    }

    public void setSamplesFromBytes(byte[] byArray, int n, AudioFormat audioFormat, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n < 0) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: negative inByteOffset, floatOffset, or frameCount");
        }
        if (n + n3 * audioFormat.getFrameSize() > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: input buffer too small.");
        }
        if (n2 + n3 > this.getSampleCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: frameCount too large");
        }
        FloatSampleTools.byte2float(byArray, n, this.channels, n2, n3, audioFormat, false);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    protected void setChannelCountImpl(int n) {
        if (this.channelCount != n) {
            this.channelCount = n;
            this.lastConvertToByteArrayFormat = null;
        }
    }

    protected void setSampleCountImpl(int n) {
        if (this.sampleCount != n) {
            this.sampleCount = n;
        }
    }

    public void setSampleCount(int n, boolean bl) {
        this.changeSampleCount(n, bl);
    }

    public void setSampleRate(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Invalid samplerate for FloatSampleBuffer.");
        }
        if (this.sampleRate != f) {
            this.sampleRate = f;
            this.lastConvertToByteArrayFormat = null;
        }
    }

    public float[] getChannel(int n) {
        if (n >= this.channelCount) {
            throw new IllegalArgumentException("FloatSampleBuffer: invalid channel number.");
        }
        return (float[])this.channels[n];
    }

    public float[] setRawChannel(int n, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("cannot set a channel to a null array");
        }
        float[] fArray2 = this.getChannel(n);
        this.channels[n] = fArray;
        return fArray2;
    }

    public Object[] getAllChannels() {
        Object[] objectArray = new Object[this.getChannelCount()];
        for (int i = 0; i < this.getChannelCount(); ++i) {
            objectArray[i] = this.getChannel(i);
        }
        return objectArray;
    }

    public void setDitherBits(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("DitherBits must be greater than 0");
        }
        this.ditherBits = f;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal DitherMode");
        }
        this.ditherMode = n;
    }

    public int getDitherMode() {
        return this.ditherMode;
    }

    protected float getConvertDitherBits(int n) {
        boolean bl = false;
        switch (this.ditherMode) {
            case 0: {
                bl = (this.originalFormatType & 7) > (n & 7);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
            }
        }
        return bl ? this.ditherBits : 0.0f;
    }
}

