#include "ptc.h"
#include "fstream.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"


Map::Map(char filename[])
{
	Buf *Tmp;
	Tmp = new Buf(512, 384, filename);
	int i,j;
	int pos1,pos2;

	xm = 0;
	ym = 0;
	bufm = new Buf(1536, 1152);

	for(j=0 ; j<1152 ; j++)
	for(i=0 ; i<1536 ; i++)
	{
		pos1 = (j*1536+i)*3;
		pos2 = ((j/3)*512+(i/3))*3;

		bufm->dat[pos1+RED] = Tmp->dat[pos2+RED];
		bufm->dat[pos1+GREEN] = Tmp->dat[pos2+GREEN];
		bufm->dat[pos1+BLUE] = Tmp->dat[pos2+BLUE];
	}


	for(j=1 ; j<1151 ; j++)
	for(i=1 ; i<1535 ; i++)
	{
		pos1 = (j*1536+i)*3;
		
		if(bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE]>100)
		{
			bufm->dat[pos1+RED] = (bufm->dat[pos1+RED-3] + bufm->dat[pos1+RED+3] + bufm->dat[pos1+RED+1536*3] + bufm->dat[pos1+RED-1536*3])/4;
			bufm->dat[pos1+GREEN] = (bufm->dat[pos1+GREEN-3] + bufm->dat[pos1+GREEN+3] + bufm->dat[pos1+GREEN+1536*3] + bufm->dat[pos1+GREEN-1536*3])/4;
			bufm->dat[pos1+BLUE] = (bufm->dat[pos1+BLUE-3] + bufm->dat[pos1+BLUE+3] + bufm->dat[pos1+BLUE+1536*3] + bufm->dat[pos1+BLUE-1536*3])/4;
		
			pos2 = ((bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE])-100)/3;
			if(pos2<0)
			{
				bufm->dat[pos1+RED]+=-pos2;
				bufm->dat[pos1+GREEN]+=-pos2;
				bufm->dat[pos1+BLUE]+=-pos2;
			}
			if(bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE]<=100)
				bufm->dat[pos1+BLUE]+=101-(bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE]);
		}
		else
		{
			bufm->dat[pos1+RED] = (bufm->dat[pos1+RED-3] + bufm->dat[pos1+RED+3] + bufm->dat[pos1+RED+1536*3] + bufm->dat[pos1+RED-1536*3])/4;
			bufm->dat[pos1+GREEN] = (bufm->dat[pos1+GREEN-3] + bufm->dat[pos1+GREEN+3] + bufm->dat[pos1+GREEN+1536*3] + bufm->dat[pos1+GREEN-1536*3])/4;
			bufm->dat[pos1+BLUE] = (bufm->dat[pos1+BLUE-3] + bufm->dat[pos1+BLUE+3] + bufm->dat[pos1+BLUE+1536*3] + bufm->dat[pos1+BLUE-1536*3])/4;
			
			pos2 = ((bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE])-100)/3;
			if(pos2>0)
			{
				bufm->dat[pos1+RED]-=pos2;
				bufm->dat[pos1+GREEN]-=pos2;
				bufm->dat[pos1+BLUE]-=pos2;
			}
			if(bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE]>100)
				bufm->dat[pos1+BLUE]-=(bufm->dat[pos1+RED]+bufm->dat[pos1+GREEN]+bufm->dat[pos1+BLUE])-100;
		}
	}

	Tmp->~Buf();
}


Map::~Map()
{
	bufm->~Buf();
}


Map::Pos(int x, int y)
{
	xm = x;
	ym = y;
}


Map::Eye()
{
	int posm;
	int j;
	
	if(xm<0) xm=0;
	if(xm>1536-320) xm=1536-320;
	if(ym<0) ym=0;
	if(ym>1152-200) ym=1152-200;
	
	posm = (ym*1536+xm)*3;

	for(j=0 ; j<200 ; j++)
	{
		memcpy(screen->dat+j*320*3, bufm->dat+posm, 320*3);
		posm+=1536*3;
	}
}
