#include "ptc.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"


Sprite::Sprite(int w, int h, char filename[])
{
	width = w;
	height = h;
	xs = 0;
	ys = 0;
	alpha = 0;
	framex = 0;
	framey = 0;
	anim = 0.;
	buf = new Buf(320, 200, filename);
}


Sprite::~Sprite()
{
	buf->~Buf();
}


Sprite::Show()
{
	int i,j;
	int sx,sy;
	int ex,ey;
	int poso, poss;
	int l;
	
	if(xs+width>=0 && xs<=319 && ys>=0 && ys-height<=199)
	{	
		sx = xs;
		sy = ys-height;
		ex = xs+width;
		ey = ys;
		poss = PAdr(framex*width, framey*height);
		
		if(sx<0) { sx=0; poss+=(-xs)*3; }
		if(sy<0) { sy=0; poss+=(-ys+height)*320*3; }
		if(ex>319) ex=319;
		if(ey>199) ey=199;
		
		l = 320*3-(ex-sx)*3;

		for(j=sy ; j<ey ; j++)
		{
			for(i=sx ; i<ex ; i++)
			{
				poso = PAdr(i,j);
				if(!(buf->dat[poss+RED]==0 && buf->dat[poss+GREEN]==0 && buf->dat[poss+BLUE]==0))
				{
					if(alpha==0)
					{
						screen->dat[poso+RED] = buf->dat[poss+RED];
						screen->dat[poso+GREEN] = buf->dat[poss+GREEN];
						screen->dat[poso+BLUE] = buf->dat[poss+BLUE];
					}
					else
					{	
						if(alpha==-1)
						{
							if(buf->dat[poss+RED]+screen->dat[poso+RED]<256)
								screen->dat[poso+RED] = buf->dat[poss+RED]+screen->dat[poso+RED];
							else screen->dat[poso+RED] = 255;
							if(buf->dat[poss+GREEN]+screen->dat[poso+GREEN]<256)
								screen->dat[poso+GREEN] = buf->dat[poss+GREEN]+screen->dat[poso+GREEN];
							else screen->dat[poso+GREEN] = 255;
							if(buf->dat[poss+BLUE]+screen->dat[poso+BLUE]<256)
								screen->dat[poso+BLUE] = buf->dat[poss+BLUE]+screen->dat[poso+BLUE];
							else screen->dat[poso+BLUE] = 255;
						}
						else
						{
							screen->dat[poso+RED] = (buf->dat[poss+RED]+screen->dat[poso+RED]*alpha)/(alpha+1);
							screen->dat[poso+GREEN] = (buf->dat[poss+GREEN]+screen->dat[poso+GREEN]*alpha)/(alpha+1);
							screen->dat[poso+BLUE] = (buf->dat[poss+BLUE]+screen->dat[poso+BLUE]*alpha)/(alpha+1);
						}
					}
				}
				poss+=3;
			}
			poss+=l;
		}	
	}
}




bool Sprite::Contact(int p)	// p : 0-up 1-right 2-down 3-left
{
	int k;
	int pos;

	if(xs+width+1>=512*3 || xs-2<=0) return TRUE;

	if(p==0)
	{
		pos = (ys-height-1)*1536*3+(xs+1)*3;
		for(k=0 ; k<width-1 ; k++)
		{
			if(map->bufm->dat[pos+RED]+map->bufm->dat[pos+GREEN]+map->bufm->dat[pos+BLUE]>100)
				return TRUE;
			pos+=3;
		}
		return FALSE;
	}
	
	if(p==1)
	{
		pos = (ys-height+1)*1536*3+(xs+width+1)*3;
		for(k=0 ; k<height-1 ; k++)
		{
			if(map->bufm->dat[pos+RED]+map->bufm->dat[pos+GREEN]+map->bufm->dat[pos+BLUE]>100)
				return TRUE;
			pos+=1536*3;
		}
		return FALSE;
	}

	if(p==2)
	{
		pos = ys*1536*3+(xs+1)*3;
		for(k=0 ; k<width-1 ; k++)
		{
			if(map->bufm->dat[pos+RED]+map->bufm->dat[pos+GREEN]+map->bufm->dat[pos+BLUE]>100)
				return TRUE;
			pos+=3;
		}
		return FALSE;
	}

	if(p==3)
	{
		pos = (ys-height+1)*1536*3+(xs-2)*3;
		for(k=0 ; k<height-1 ; k++)
		{
			if(map->bufm->dat[pos+RED]+map->bufm->dat[pos+GREEN]+map->bufm->dat[pos+BLUE]>100)
				return TRUE;
			pos+=1536*3;
		}
		return FALSE;
	}

	return FALSE;
}

