#include "ptc.h"
#include "fmod.h"
#include "fstream.h"
#include "math.h"
#include "stdlib.h"
#include "string.h"
#include "setjmp.h"
#include "stdio.h"
#include "winuser.h"

#include "gfx/head/sound.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/blood.h"
#include "world/head/weapon.h"
#include "world/head/entity.h"
#include "world/head/player.h"
#include "world/head/bot.h"
#include "world/head/item.h"
#include "gfx/head/police.h"
#include "world/head/game.h"
#include "inter/head/pol.h"
#include "inter/head/inter.h"


int Bbots[20];

int p1skin;
int p2skin;
int mapsel;

FSOUND_SAMPLE *smenu;


void Interface()
{
	bpolice = new BPolice("base/gfx/menu/police.bmp");
	screen = new Buf(320, 200);
	WIDTH  = 640;
	HEIGHT = 400;
	Init_Console();
	Init_Sound();
	
	smenu = FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/menu.wav", FSOUND_NORMAL, 0);

	Play_Mp3("base/sounds/intro.mp3");

	dplayer = 0;
	EBexplose = 1;
	EBbump = 0;
	EBblood = 1;
	
	SKILL = HARDCORE;
	
	EMUSIC = 1;

	PK1 = new Player_Keys();
	PK2 = new Player_Keys();

	p1skin = 7;
	p2skin = 2;
	bskins = new BSkin("base/skins/skins.txt");
	bmaps  = new BMaps("base/maps/maps.txt");
	mapsel = 0;

	for(int i=0 ; i<20 ; i++)
		Bbots[i] = -1;

	police = new Police("base/gfx/police.bmp", 21);


	Main_Menu();

	
	police->~Police();
	
	
	Stop_Mp3();
	bskins->~BSkin();
	bmaps->~BMaps();
	Close_Sound();
	Exit_Console();
	screen->~Buf();
	bpolice->~BPolice();
}



void Main_Menu()
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		bpolice->BBlitTxt("burnt", 10, 50, *scr, 0);

		if(sel==0) bpolice->BBlitTxt("new game", 260, 100, *scr, 1);
		else bpolice->BBlitTxt("new game", 260, 100, *scr, 0);
		if(sel==1) bpolice->BBlitTxt("options", 260, 200, *scr, 1);
		else bpolice->BBlitTxt("options", 260, 200, *scr, 0);
		if(sel==2) bpolice->BBlitTxt("exit", 260, 300, *scr, 1);
		else bpolice->BBlitTxt("exit", 260, 300, *scr, 0);
		
		
		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::UP:
                {
					if(sel>0) sel--;
					else sel=2;
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                }
				break;
				case Key::DOWN:
                {
					if(sel<2) sel++;
					else sel=0;
                	FSOUND_PlaySound(FSOUND_FREE, smenu);
                }
				break;
				case Key::SPACE:
                {
					if(sel==0) Game_Menu();
					if(sel==1) Options_Menu();
					if(sel==2) mquit=1;
				}
				break;
			}
		}

	
		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}

	for(i=0 ; i<640*400*3 ; i++)
		scr->dat[i] = 0;

	bpolice->BBlitTxt("burnt", 10, 50, *scr, 0);
	
	bpolice->BBlitTxt("code     skarab", 200, 100, *scr, 0);
	bpolice->BBlitTxt("design   skarab", 200, 200, *scr, 0);
	bpolice->BBlitTxt("gfx      skarab", 200, 300, *scr, 0);

	scr->Blit();

	while(!((GetAsyncKeyState(VK_ESCAPE)&0x8000)==0x8000))
	{
	}

	scr->~Buf();
	back->~Buf();
}




void Options_Menu()
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int oquit=0;
	
	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(oquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		if(sel==0)
		{
			if(SKILL==BRING_IT_ON) bpolice->BBlitTxt("skill  bring it on", 200, 60, *scr, 1);
			if(SKILL==HURT_ME_PLENTY) bpolice->BBlitTxt("skill  hurt me plenty", 200, 60, *scr, 1);
			if(SKILL==HARDCORE) bpolice->BBlitTxt("skill  hardcore", 200, 60, *scr, 1);
			if(SKILL==NIGHTMARE) bpolice->BBlitTxt("skill  nightmare", 200, 60, *scr, 1);
		}
		else
		{
			if(SKILL==BRING_IT_ON) bpolice->BBlitTxt("skill  bring it on", 200, 60, *scr, 0);
			if(SKILL==HURT_ME_PLENTY) bpolice->BBlitTxt("skill  hurt me plenty", 200, 60, *scr, 0);
			if(SKILL==HARDCORE) bpolice->BBlitTxt("skill  hardcore", 200, 60, *scr, 0);
			if(SKILL==NIGHTMARE) bpolice->BBlitTxt("skill  nightmare", 200, 60, *scr, 0);
		}
		

		if(sel==1)
			if(EBblood==0) bpolice->BBlitTxt("blood disabled", 200, 120, *scr, 1);
			else bpolice->BBlitTxt("blood enabled", 200, 120, *scr, 1);
		else
			if(EBblood==0) bpolice->BBlitTxt("blood disabled", 200, 120, *scr, 0);
			else bpolice->BBlitTxt("blood enabled", 200, 120, *scr, 0);

		if(sel==2)
			if(EBexplose==0) bpolice->BBlitTxt("worms mode disabled", 200, 180, *scr, 1);
			else bpolice->BBlitTxt("worms mode enabled", 200, 180, *scr, 1);
		else
			if(EBexplose==0) bpolice->BBlitTxt("worms mode disabled", 200, 180, *scr, 0);
			else bpolice->BBlitTxt("worms mode enabled", 200, 180, *scr, 0);
		
		if(sel==3)
			if(VMODE==0) bpolice->BBlitTxt("fullscreen mode", 200, 240, *scr, 1);
			else bpolice->BBlitTxt("windowed mode", 200, 240, *scr, 1);
		else
			if(VMODE==0) bpolice->BBlitTxt("fullscreen mode", 200, 240, *scr, 0);
			else bpolice->BBlitTxt("windowed mode", 200, 240, *scr, 0);
		
		if(sel==4)
			if(EMUSIC==0) bpolice->BBlitTxt("music disabled", 200, 300, *scr, 1);
			else bpolice->BBlitTxt("music enabled", 200, 300, *scr, 1);
		else
			if(EMUSIC==0) bpolice->BBlitTxt("music disabled", 200, 300, *scr, 0);
			else bpolice->BBlitTxt("music enabled", 200, 300, *scr, 0);


		if(sel==5) bpolice->BBlitTxt("ok", 200, 360, *scr, 1);
		else bpolice->BBlitTxt("ok", 200, 360, *scr, 0);
		
		
		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::UP:
                {
					if(sel>0) sel--;
					else sel=5;
                	FSOUND_PlaySound(FSOUND_FREE, smenu);
                }
				break;
				case Key::DOWN:
                {
					if(sel<5) sel++;
					else sel=0;
                	FSOUND_PlaySound(FSOUND_FREE, smenu);
                }
				break;
				case Key::LEFT:
				{
					if(sel==0)
					{
						if(SKILL<NIGHTMARE) SKILL++;
						else SKILL=0;
					}
					if(sel==1) EBblood=0;
					if(sel==2) EBexplose=0;
					if(sel==3) 
					{
						Exit_Console();
						VMODE=0;
						Init_Console();
					}
                	if(sel==4) EMUSIC=0;
				}
				break;
				case Key::RIGHT:
				{
					if(sel==0)
					{
						if(SKILL>0) SKILL--;
						else SKILL=NIGHTMARE;
					}
					if(sel==1) EBblood=1;
					if(sel==2) EBexplose=1;
					if(sel==3)
					{
						Exit_Console();
						VMODE=1;
						Init_Console();
					}
					if(sel==4) EMUSIC=1;
				}
				break;
				case Key::SPACE:
                {
					if(sel==5) oquit=1;
				}
				break;
			}
		}

	
		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();
}




void Game_Menu()
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		if(sel==0)
			if(dplayer==0) bpolice->BBlitTxt("one player", 200, 100, *scr, 1);
			else bpolice->BBlitTxt("two players", 200, 100, *scr, 1);
		else 
			if(dplayer==0) bpolice->BBlitTxt("one player", 200, 100, *scr, 0);
			else bpolice->BBlitTxt("two players", 200, 100, *scr, 0);
		
		if(sel==1) bpolice->BBlitTxt("configure player one", 200, 200, *scr, 1);
		else bpolice->BBlitTxt("configure player one", 200, 200, *scr, 0);
		
		if(sel==2) bpolice->BBlitTxt("configure player two", 200, 300, *scr, 1);
		else bpolice->BBlitTxt("configure player two", 200, 300, *scr, 0);

		if(sel==3) bpolice->BBlitTxt("back", 40, 370, *scr, 1);
		else bpolice->BBlitTxt("back", 40, 370, *scr, 0);

		if(sel==4) bpolice->BBlitTxt("accept", 300, 370, *scr, 1);
		else bpolice->BBlitTxt("accept", 300, 370, *scr, 0);


		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::UP:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(sel>0) sel--;
					else sel=4;
                }
				break;
				case Key::DOWN:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(sel<4) sel++;
					else sel=0;
                }
				break;
				case Key::LEFT:
                {
					if(sel==0) dplayer=0;
				}
				break;
				case Key::RIGHT:
                {
					if(sel==0) dplayer=1;
				}
				break;
				case Key::SPACE:
                {
					if(sel==1)
					{
						p1skin=Choose_Skin(p1skin);
						Conf_Keys(*PK1);
					}
					if(sel==2)
					{
						p2skin=Choose_Skin(p2skin);
						Conf_Keys(*PK2);
					}
					if(sel==3) mquit=1;
					if(sel==4) Bots_Menu();
				}
				break;
			}
		}

		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();
}



int Choose_Skin(int n)
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;
	int ns = n;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		
		bpolice->BBlitTxt(bskins->skins[ns].name, 250, 100, *scr, 0);
		bskins->skins[ns].screen->xs = 250;
		bskins->skins[ns].screen->ys = 250;
		bskins->skins[ns].screen->BShow(*scr, 1);

		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::LEFT:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(ns<bskins->num-1) ns++;
					else ns=0;
				}
				break;
				case Key::RIGHT:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(ns>0) ns--;
					else ns=bskins->num-1;
				}
				break;
				case Key::SPACE:
                {
					mquit=1;
				}
				break;
			}
		}

		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();

	return ns;
}



void Conf_Keys(Player_Keys & pkd)
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;
	int n=0;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		if(n==0) bpolice->BBlitTxt("press key jump", 200, 200, *scr, 1);
		if(n==1) bpolice->BBlitTxt("press key left", 200, 200, *scr, 1);
		if(n==2) bpolice->BBlitTxt("press key right", 200, 200, *scr, 1);
		if(n==3) bpolice->BBlitTxt("press key fire", 200, 200, *scr, 1);
		if(n==4) bpolice->BBlitTxt("press key weapon up", 200, 200, *scr, 1);
		if(n==5) bpolice->BBlitTxt("press key weapon down", 200, 200, *scr, 1);
		
		
		while (console.key())
        {
			Key key = console.read();
		
			if(n==0) pkd.Up       = key.code();
			if(n==1) pkd.Left     = key.code();
			if(n==2) pkd.Right    = key.code();
			if(n==3) pkd.Fire     = key.code();
			if(n==4) pkd.UpWeap   = key.code();
			if(n==5) pkd.DownWeap = key.code();
			
			FSOUND_PlaySound(FSOUND_FREE, smenu);
                
			n++;		
		}

		if(n==6) mquit=1;

		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();
}




void Bots_Menu()
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		
		for(i=0 ; i<6 ; i++)
		{
			if(Bbots[i]!=-1)
				if(sel!=i)
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 40, 55+52*i, *scr, 0);
				else
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 40, 55+52*i, *scr, 1);
			else
				if(sel!=i)
					bpolice->BBlitTxt("empty", 40, 55+52*i, *scr, 0);
				else
					bpolice->BBlitTxt("empty", 40, 55+52*i, *scr, 1);
		}
		for(i=6 ; i<12 ; i++)
		{
			if(Bbots[i]!=-1)
				if(sel!=i)
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 250, 55+52*(i-6), *scr, 0);
				else
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 250, 55+52*(i-6), *scr, 1);
			else
				if(sel!=i)
					bpolice->BBlitTxt("empty", 250, 55+52*(i-6), *scr, 0);
				else
					bpolice->BBlitTxt("empty", 250, 55+52*(i-6), *scr, 1);
		}
		for(i=12 ; i<18 ; i++)
		{
			if(Bbots[i]!=-1)
				if(sel!=i)
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 450, 55+52*(i-12), *scr, 0);
				else
					bpolice->BBlitTxt(bskins->skins[Bbots[i]].name, 450, 55+52*(i-12), *scr, 1);
			else
				if(sel!=i)
					bpolice->BBlitTxt("empty", 450, 55+52*(i-12), *scr, 0);
				else
					bpolice->BBlitTxt("empty", 450, 55+52*(i-12), *scr, 1);
		}


		if(sel==18) bpolice->BBlitTxt("back", 40, 370, *scr, 1);
		else bpolice->BBlitTxt("back", 40, 370, *scr, 0);

		if(sel==19) bpolice->BBlitTxt("accept", 300, 370, *scr, 1);
		else bpolice->BBlitTxt("accept", 300, 370, *scr, 0);


		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::UP:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(sel>0) sel--;
					else sel=19;
                }
				break;
				case Key::DOWN:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(sel<19) sel++;
					else sel=0;
                }
				break;
				case Key::SPACE:
                {
					if(sel<18)
					{
						if(Bbots[sel]>-1)
							Bbots[sel]=Choose_Skin(Bbots[sel]);
						else
							Bbots[sel]=Choose_Skin(0);
					}

					if(sel==18) mquit=1;

					if(sel==19)
					{
						mapsel = Choose_Map(mapsel);
						Run_Game();
					}
				}
				break;
			}
		}

		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();
}




int Choose_Map(int n)
{
	Buf *scr;
	Buf *back;
	int	i, j;
	int t;
	int u;
	int sel;
	int mquit=0;
	int ns = n;

	scr = new Buf(640, 400);
	back = new Buf(640, 400, "base/gfx/menu/main.bmp");
	t=0;

	sel = 0;

	while(mquit==0)
	{
		for(j=0 ; j<400 ; j++)
		for(i=0 ; i<640 ; i++)
		{
			u = i+t;
			if(u<0) u+=640;
			if(u>639) u-=640;
			scr->dat[Smu640[Sln640[j]+i]+RED] = (back->dat[Smu640[Sln640[j]+i]+RED] + back->dat[Smu640[Sln640[j]+u]+RED])/2;
			scr->dat[Smu640[Sln640[j]+i]+GREEN] = (back->dat[Smu640[Sln640[j]+i]+GREEN] + back->dat[Smu640[Sln640[j]+u]+GREEN])/2;
			scr->dat[Smu640[Sln640[j]+i]+BLUE] = (back->dat[Smu640[Sln640[j]+i]+BLUE] + back->dat[Smu640[Sln640[j]+u]+BLUE])/2;
		}
		
		
		bpolice->BBlitTxt(bmaps->bmap[ns].name, 250, 100, *scr, 0);
		bmaps->bmap[ns].screen->xs = 250;
		bmaps->bmap[ns].screen->ys = 250;
		bmaps->bmap[ns].screen->BShow(*scr, 1);
		
		while (console.key())
        {
			Key key = console.read();

            switch (key.code())
            {
				case Key::LEFT:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(ns<bmaps->num-1) ns++;
					else ns=0;
				}
				break;
				case Key::RIGHT:
                {
					FSOUND_PlaySound(FSOUND_FREE, smenu);
                	if(ns>0) ns--;
					else ns=bmaps->num-1;
				}
				break;
				case Key::SPACE:
                {
					mquit=1;
				}
				break;
			}
		}

		scr->Blit();
		
		if(t<638) t+=3;
		else t=0;
	}
	
	scr->~Buf();
	back->~Buf();

	return ns;
}





void Run_Game()
{
	Exit_Console();

	Init_World(bmaps->bmap[mapsel].spath);
	
	BSounds = new Sounds();

	Stop_Mp3();
	
	if(EMUSIC==1)
		Play_Mp3("base/sounds/zik.mp3");

	Player = new Entity(bskins->skins[p1skin].spath);
		
	if(dplayer==1) 
		Player2 = new Entity(bskins->skins[p2skin].spath);
	
	bots = new Bots();
	
	for(int i=0 ; i<20 ; i++)
		if(Bbots[i]>-1)
			bots->Add(bskins->skins[Bbots[i]].spath);


	if(dplayer==0)
	{
		WIDTH  = 320;
		HEIGHT = 200;
	}
	else
	{
		WIDTH  = 640;
		HEIGHT = 400;
	}
	
	Init_Console();

	Game();

	Exit_Console();

	if(EMUSIC==1)
		Stop_Mp3();
	
	Play_Mp3("base/sounds/intro.mp3");
	BSounds->~Sounds();

	bots->Remove();
	bots->~Bots();
	Player->~Entity();
	if(dplayer==1) Player2->~Entity();
	Exit_World();

	WIDTH  = 640;
	HEIGHT = 400;
	Init_Console();
}



