#include "ptc.h"
#include "gfx/head/buf.h"
#include "gfx/head/video.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/weapon.h"
#include "world/head/entity.h"
#include "world/head/blood.h"


Blood *blood;



Blood::Blood()
{
	num = 0;
	gibs = new Gib[20000];
}


Blood::~Blood()
{
	delete[] gibs;
}


Blood::Add(int x, int y, int size, int strength)
{
	for(int k=0 ; k<strength*EBblood ; k++)
	{
		if(num<20000)
		{
			gibs[num].xg = (double)(x);
			gibs[num].yg = (double)(y);
			gibs[num].ax = (double)(size*50-rnd(size*100))/100.;
			gibs[num].ay = (double)(rnd(size*100))/100.;
			gibs[num].r = rnd(10)+245;
			num++;
		}
	}
}


Blood::Del(int n)
{
	num--;
	for(int k=n ; k<num ; k++)
		gibs[k] = gibs[k+1];
}



Blood::Show()
{
	int xj,yj;
	int po;

	for(int b=0 ; b<num ; b++)
	{
		
		if(EBblood!=0)
		if(rnd(200)>196)
		{
			if(gibs[b].xg>=0 && gibs[b].xg<512*3)
			if(gibs[b].yg>=0 && gibs[b].yg<384*3)
			{
				po = ((int)(gibs[b].yg)*512*3+(int)(gibs[b].xg))*3;
				if(map->bufm->dat[po+RED]+map->bufm->dat[po+GREEN]+map->bufm->dat[po+BLUE]<100)
				{
					map->bufm->dat[po+RED]=rnd(99); 
					map->bufm->dat[po+GREEN]=0; 
					map->bufm->dat[po+BLUE]=0; 
				}	
			}
		}

		xj = (int)(gibs[b].xg-map->xm);
		yj = (int)(gibs[b].yg-map->ym);
		
		if(xj>=0 && xj<320)
		if(yj>=0 && yj<200)
		{
			if(screen->dat[Smu[Sln[yj]+xj]+RED]+gibs[b].r<255)
				screen->dat[Smu[Sln[yj]+xj]+RED]+=gibs[b].r;
			else screen->dat[Smu[Sln[yj]+xj]+RED]=255;
		}
	}
}



Blood::Update()
{
	int po;
	for(int b=0 ; b<num ; b++)
	{
		gibs[b].xg+=gibs[b].ax*world_speed;
		gibs[b].yg-=gibs[b].ay*world_speed;
		gibs[b].ay-=.1*world_speed;
		gibs[b].r-=(int)(4. * world_speed);
		
		if((int)(gibs[b].xg)>0 && (int)(gibs[b].xg)<512*3 && (int)(gibs[b].yg)>0 && (int)(gibs[b].yg)<384*3) 
		{
			po = ((int)(gibs[b].yg)*512*3+(int)(gibs[b].xg))*3;
				
			if(gibs[b].r<=0 || map->bufm->dat[po+RED]+map->bufm->dat[po+GREEN]+map->bufm->dat[po+BLUE]>100)
			{
				Del(b);
				b--;
			}
		}
		else
		{
			Del(b);
			b--;
		}
	}
}


