#include "ptc.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/entity.h"
#include "world/head/player.h"


Player_Keys *PK1;
Player_Keys *PK2;
	

Player_Keys::Player_Keys()
{
	Up       = VK_NUMPAD8;
	Left     = VK_NUMPAD4;
	Right    = VK_NUMPAD6;
	UpWeap   = VK_HOME;
	DownWeap = VK_END;
	Fire     = VK_INSERT;
}


void Impulse(Entity & Ent,  Player_Keys & PKeys)
{
	Ent.state->up = 0;
	Ent.state->right = 0;
	Ent.state->fire = 0;
	
	if((GetAsyncKeyState(PKeys.Up)&0x8000)==0x8000)
			Ent.state->up=1;
	
	if((GetAsyncKeyState(PKeys.Left)&0x8000)==0x8000)
			Ent.state->right=-1;

	if((GetAsyncKeyState(PKeys.Right)&0x8000)==0x8000)
			Ent.state->right=1;
	
	if((GetAsyncKeyState(PKeys.UpWeap)&0x8000)==0x8000)
	{
		if(Ent.state->weap_ud==0)
			Ent.state->weap_ud = 1;
		else Ent.state->weap_ud = 3;
	}
	else if((GetAsyncKeyState(PKeys.DownWeap)&0x8000)==0x8000)
	{
	 		if(Ent.state->weap_ud==0)
				Ent.state->weap_ud = 2;
	     	else Ent.state->weap_ud = 3;
		}
		else Ent.state->weap_ud = 0;

	if((GetAsyncKeyState(PKeys.Fire)&0x8000)==0x8000)
			Ent.state->fire = 1;
}	
