#include "kexplo.h"
#include "float.h"	



inline void xchg(long *o1, long *o2)
{
 long o3 = *o1;
 *o1 = *o2;
 *o2 = o3;
}


//===================================================================
//		Maths addict for collision detection and more...
//===================================================================

CVertex Vector(CVertex vPoint1, CVertex vPoint2)
{
	CVertex vVector;							

	vVector.x = vPoint1.x - vPoint2.x;				
	vVector.y = vPoint1.y - vPoint2.y;				
	vVector.z = vPoint1.z - vPoint2.z;				

	return vVector;									
}


float Absolute(float num)
{
	if(num < 0)	return (0 - num);
	return num;
}
												
CVertex Cross(CVertex vVector1, CVertex vVector2)
{
	CVertex VCross;
	ASMCrossProduct(vVector1, vVector2, VCross);
	return VCross;
	//return ((vVector1 * vVector2) - (vVector1 * vVector2));
}

float Magnitude(CVertex vNormal)
{
	return (float)sqrt( (vNormal.x * vNormal.x) + (vNormal.y * vNormal.y) + (vNormal.z * vNormal.z) );
}


CVertex Normalize(CVertex vNormal)
{
	if(Magnitude(vNormal)!=0.0f)
		return vNormal / Magnitude(vNormal);	
	else return 0.0f;
}


CVertex Normal(CVertex vTriangle[])					
{
	return Normalize(Cross(vTriangle[2] - vTriangle[0], vTriangle[1] - vTriangle[0]));					
}

									
float PlaneDistance(CVertex Normal, CVertex Point)
{	
	return  -((Normal.x * Point.x) + (Normal.y * Point.y) + (Normal.z * Point.z));
}


float Distance(CVertex vPoint1, CVertex vPoint2)
{
	return (float)( sqrt( (vPoint2.x - vPoint1.x) * (vPoint2.x - vPoint1.x) +
				  	    (vPoint2.y - vPoint1.y) * (vPoint2.y - vPoint1.y) +
						(vPoint2.z - vPoint1.z) * (vPoint2.z - vPoint1.z) ));
}


CVertex ClosestPointOnLine(CVertex vA, CVertex vB, CVertex vPoint)
{
	CVertex vVector2 = Normalize(vB - vA);
	float d = Distance(vA, vB);
	float t = Dot(vVector2, vPoint - vA);

	if (t <= 0) return vA;
    if (t >= d) return vB;
 
    return vA + vVector2 * t;
}



//===================================================================
//		Intersection Detection
//===================================================================

bool IntersectedPlane(CVertex vPoly[], CVertex vLine[], CVertex &vNormal, float &originDistance)
{
	float distance1=0, distance2=0;						
	vNormal = Normal(vPoly);							
	originDistance = PlaneDistance(vNormal, vPoly[0]);

	distance1 = ((vNormal.x * vLine[0].x) + (vNormal.y * vLine[0].y) + (vNormal.z * vLine[0].z)) + originDistance;
	if(distance1==0) return false;
	
	distance2 = ((vNormal.x * vLine[1].x) + (vNormal.y * vLine[1].y) + (vNormal.z * vLine[1].z)) + originDistance;
	if(distance1 * distance2 >= 0) return false;						
					
	return true;							
}


bool IntersectedPlane2(CVertex vPoly[], CVertex vLine[])
{
	float distance1=0, distance2=0;						
	CVertex vNormal;
	float originDistance;
	
	vNormal = Normal(vPoly);							

	originDistance = PlaneDistance(vNormal, vPoly[0]);

	distance1 = ((vNormal.x * vLine[0].x) + (vNormal.y * vLine[0].y) + (vNormal.z * vLine[0].z)) + originDistance;
	if(distance1==0) return false;

	distance2 = ((vNormal.x * vLine[1].x) + (vNormal.y * vLine[1].y) + (vNormal.z * vLine[1].z)) + originDistance;
	if(distance1 * distance2 >= 0) return false;						
					
	return true;							
}


float Dot(CVertex vVector1, CVertex vVector2) 
{
	return ASMDotProduct(vVector1, vVector2);
}


double AngleBetweenVectors(CVertex Vector1, CVertex Vector2)
{							
	float dotProduct = Dot(Vector1, Vector2);				

	float vectorsMagnitude = Magnitude(Vector1) * Magnitude(Vector2) ;

	double angle;

	if(vectorsMagnitude!=0.0f)
		 angle = acos( dotProduct / vectorsMagnitude );
	else
		 angle = 3.14 / 2.;

	if(_isnan(angle))
		return 0;
	
	return( angle );
}


										
CVertex IntersectionPoint(CVertex vNormal, CVertex vLine[], double distance)
{
	CVertex vPoint, vLineDir;		
	double Numerator, Denominator, dist;

	vLineDir = Vector(vLine[1], vLine[0]);		
	vLineDir = Normalize(vLineDir);				


	Numerator = - (vNormal.x * vLine[0].x +		
				   vNormal.y * vLine[0].y +
				   vNormal.z * vLine[0].z + distance);

	Denominator = Dot(vNormal, vLineDir);		
				  

	if( Denominator == 0.0)						
		return vLine[0];						


	dist = Numerator / Denominator;				
	

	vPoint.x = (float)(vLine[0].x + (vLineDir.x * dist));
	vPoint.y = (float)(vLine[0].y + (vLineDir.y * dist));
	vPoint.z = (float)(vLine[0].z + (vLineDir.z * dist));

	return vPoint;		
}



bool InsidePolygon(CVertex vIntersection, CVertex Poly[], long verticeCount)
{
	const double MATCH_FACTOR = 0.9999;		
	double Angle = 0.0;					
	CVertex vA, vB;						
	

	for (int i = 0; i < verticeCount; i++)		
	{	
		vA = Vector(Poly[i], vIntersection);
												
		vB = Vector(Poly[(i + 1) % verticeCount], vIntersection);
												
		Angle += AngleBetweenVectors(vA, vB);
	}
												
	if(Angle >= (MATCH_FACTOR * (2.0 * PI)) )	
		return TRUE;							
		
	return FALSE;	
}



bool IntersectedPolygon(CVertex vPoly[], CVertex vLine[], int verticeCount)
{
	CVertex vNormal;
	float originDistance;

	if(!IntersectedPlane(vPoly, vLine,   vNormal,   originDistance))
		return false;

	CVertex vIntersection = IntersectionPoint(vNormal, vLine, originDistance);
	
	if(InsidePolygon(vIntersection, vPoly, verticeCount))
		return true;							

	return false;	

}


CVertex IntersectedPolygonV(CVertex vPoly[], CVertex vLine[], int verticeCount)
{
	CVertex vNormal;
	float originDistance;

	IntersectedPlane(vPoly, vLine,   vNormal,   originDistance);
	return IntersectionPoint(vNormal, vLine, originDistance);
}

