#ifndef _3DMATH_H
#define _3DMATH_H

#define PI 3.1415926535897932

#define BEHIND		0
#define INTERSECTS	1
#define FRONT		2


extern inline void xchg(long *o1, long *o2);


// Retourne la valeur absolue
float Absolute(float num);


//	This returns a perpendicular vector from 2 given vectors by taking the cross product.
CVertex Cross(CVertex vVector1, CVertex vVector2);

//	This returns the magnitude of a normal (or any other vector)
float Magnitude(CVertex vNormal);

//	This returns a normalize vector (A vector exactly of length 1)
CVertex Normalize(CVertex vNormal);

//	This returns the normal of a polygon (The direction the polygon is facing)
CVertex Normal(CVertex vTriangle[]);

// This returns the distance the plane is from the origin (0, 0, 0)
// It takes the normal to the plane, along with ANY point that lies on the plane (any corner)
float PlaneDistance(CVertex Normal, CVertex Point);

// retourne la distance entre 2 points 3d
float Distance(CVertex vPoint1, CVertex vPoint2);

// This takes a triangle (plane) and line and returns true if they intersected
bool IntersectedPlane(CVertex vPoly[], CVertex vLine[], CVertex &vNormal, float &originDistance);
bool IntersectedPlane2(CVertex vPoly[], CVertex vLine[]);

//	This returns the point on the line vA_vB that is closest to the point vPoint
CVertex ClosestPointOnLine(CVertex vA, CVertex vB, CVertex vPoint);


// This returns the dot product between 2 vectors
float Dot(CVertex vVector1, CVertex vVector2);

// This returns the angle between 2 vectors
double AngleBetweenVectors(CVertex Vector1, CVertex Vector2);

// This returns an intersection point of a polygon and a line (assuming intersects the plane)
CVertex IntersectionPoint(CVertex vNormal, CVertex vLine[], double distance);

// This returns true if the intersection point is inside of the polygon
bool InsidePolygon(CVertex vIntersection, CVertex Poly[], long verticeCount);

// Use this function to test collision between a line and polygon
bool IntersectedPolygon(CVertex vPoly[], CVertex vLine[], int verticeCount);
CVertex IntersectedPolygonV(CVertex vPoly[], CVertex vLine[], int verticeCount);





#endif 

