#include "kexplo.h"


GLuint bigfont;

GLuint basefont;
//GLYPHMETRICSFLOAT gmfont[256];
GLuint textFont[2];



GLvoid Init_Font(GLvoid)							
{
	float	cx;											// Holds Our X Character Coord
	float	cy;											// Holds Our Y Character Coord
	int loop;

	CreateTexture(textFont, "data/font.jpg", 0);

	basefont=glGenLists(256);								// Creating 256 Display Lists
	glBindTexture(GL_TEXTURE_2D, textFont[0]);			// Select Our Font Texture
	for (loop=0; loop<256; loop++)						// Loop Through All 256 Lists
	{
		cx=float(loop%16)/16.0f;						// X Position Of Current Character
		cy=float(loop/16)/16.0f;						// Y Position Of Current Character

		glNewList(basefont+loop,GL_COMPILE);				// Start Building A List
			glBegin(GL_QUADS);							// Use A Quad For Each Character
				glTexCoord2f(cx,1-cy-0.0625f);			// Texture Coord (Bottom Left)
				glVertex2f(0,0);						// Vertex Coord (Bottom Left)
				glTexCoord2f(cx+0.0625f,1-cy-0.0625f);	// Texture Coord (Bottom Right)
				glVertex2f(0.7,0);						// Vertex Coord (Bottom Right)
				glTexCoord2f(cx+0.0625f,1-cy);			// Texture Coord (Top Right)
				glVertex2f(0.7,0.7);						// Vertex Coord (Top Right)
				glTexCoord2f(cx,1-cy);					// Texture Coord (Top Left)
				glVertex2f(0,0.7);						// Vertex Coord (Top Left)
			glEnd();									// Done Building Our Quad (Character)
			glTranslated(0.4,0,0);						// Move To The Right Of The Character
		glEndList();									// Done Building The Display List
	}													// Loop Until All 256 Are Built


	bigfont=glGenLists(256);								// Creating 256 Display Lists
	glBindTexture(GL_TEXTURE_2D, textFont[0]);			// Select Our Font Texture
	for (loop=0; loop<256; loop++)						// Loop Through All 256 Lists
	{
		cx=float(loop%16)/16.0f;						// X Position Of Current Character
		cy=float(loop/16)/16.0f;						// Y Position Of Current Character

		glNewList(bigfont+loop,GL_COMPILE);				// Start Building A List
			glBegin(GL_QUADS);							// Use A Quad For Each Character
				glTexCoord2f(cx,1-cy-0.0625f);			// Texture Coord (Bottom Left)
				glVertex2f(0,0);						// Vertex Coord (Bottom Left)
				glTexCoord2f(cx+0.0625f,1-cy-0.0625f);	// Texture Coord (Bottom Right)
				glVertex2f(4,0);						// Vertex Coord (Bottom Right)
				glTexCoord2f(cx+0.0625f,1-cy);			// Texture Coord (Top Right)
				glVertex2f(4,6);						// Vertex Coord (Top Right)
				glTexCoord2f(cx,1-cy);					// Texture Coord (Top Left)
				glVertex2f(0,6);						// Vertex Coord (Top Left)
			glEnd();									// Done Building Our Quad (Character)
			glTranslated(3,0,0);						// Move To The Right Of The Character
		glEndList();									// Done Building The Display List
	}													// Loop Until All 256 Are Built

}



GLvoid Exit_Font(GLvoid)								
{
	glDeleteLists(basefont, 256);						
	glDeleteLists(bigfont, 256);						
}


GLvoid _print(float x, float y, float z, float c, const char *fmt, ...)					
{
	float		length=0;								
	char		text[256];								
	va_list		ap;										
	float wh;
	unsigned int loop, k;

	if (fmt == NULL)									
		return;										

	va_start(ap, fmt);									
	    vsprintf(text, fmt, ap);						
	va_end(ap);											

	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textFont[0]);			// Select Our Font Texture

	if(text[0]=='\0') return;

	glShadeModel(GL_SMOOTH);
			
	glDisable(GL_DEPTH_TEST);

	glLoadIdentity();

	glTranslatef(-x,y,z);					

	glListBase(basefont-32);
			
	glColor3f(c, c, c);
		
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
		
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
}



GLvoid glPrint(float x, float y, float z, float c, float r, const char *fmt, ...)					
{
	float		length=0;								
	char		text[256];								
	va_list		ap;										
	float wh;
	unsigned int loop, k;

	if (fmt == NULL)									
		return;										

	va_start(ap, fmt);									
	    vsprintf(text, fmt, ap);						
	va_end(ap);											

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textFont[0]);			// Select Our Font Texture

	if(text[0]=='\0') return;

	glShadeModel(GL_SMOOTH);
			
	glDisable(GL_DEPTH_TEST);

	glTranslatef(-x,y,z);					
	glRotatef(r, 0, 1, 0);

	glListBase(basefont-32);
			
	glColor3f(c, c, c);
		
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
		
		
	glLoadIdentity();
	cam->Look();
			
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
}






GLvoid glPrint_B(float x, float y, float z, float c, float r, const char *fmt, ...)					
{
	float		length=0;								
	char		text[256];								
	va_list		ap;										
	float wh;
	unsigned int loop, k;

	if (fmt == NULL)									
		return;										

	va_start(ap, fmt);									
	    vsprintf(text, fmt, ap);						
	va_end(ap);											

	length = strlen(text);

	glDisable(GL_DEPTH_TEST);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textFont[0]);			// Select Our Font Texture

	if(text[0]=='\0') return;

	glShadeModel(GL_SMOOTH);
			
	glTranslatef(-x,y,z);					
	glRotatef(r, 0, 1, 0);
	glTranslatef(-length*3./2.,0.0f,0.0f);

	glListBase(bigfont-32);
			
	glColor3f(c, c, c);
		
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
		
		
	glLoadIdentity();
	cam->Look();
			
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
}





