#include "string.h"

CString::CString( void )
{
    Buffer = NULL;
    SetLength( 0 );
}

CString::CString( char c )
{
    Buffer = NULL;
    SetLength( 0 );
    operator=( c );
}

CString::CString( const CString & text )
{
    Buffer = NULL;
    SetLength( 0 );
    operator=( text );
}

CString::CString( const char * text, ... )
{
    Buffer = NULL;
    SetLength( 0 );

    va_list va_array;
    char line[ 256 ];

    va_start( va_array, text );
        vsprintf( line, text, va_array );
    va_end( va_array );

    operator=( line );
}

CString::~CString( void )
{
    free( Buffer );
}

char CString::operator[]( uint32 char_index ) const
{
    return *( GetBuffer() + char_index );
}

char & CString::operator[]( uint32 char_index )
{
    return *( GetBuffer() + char_index );
}

void CString::operator=( char c )
{
    SetLength( 1 );
    GetBuffer()[ 0 ] = c;
}

void CString::operator=( const char * text )
{
    SetLength( ( uint32 ) strlen( text ) );
    memcpy( GetBuffer(), text, GetLength() );
}

void CString::operator=( const CString & text )
{
    SetLength( text.GetLength() );
    memcpy( GetBuffer(), text.GetBuffer(), GetLength() );
}

CString CString::operator+( char c ) const
{
    CString string( *this );
    string += c;

    return string;
}

CString CString::operator+( const char * text ) const
{
    CString string( *this );
    string += text;

    return string;
}

CString CString::operator+( const CString & text ) const
{
    CString string( *this );
    string += text;

    return string;
}

void CString::operator+=( char c )
{
    SetLength( GetLength() + 1 );
    GetBuffer()[ GetLength() - 1 ] = c;
}

void CString::operator+=( const char * text )
{
    uint32 length = ( uint32 ) strlen( text );
    uint32 old_length = GetLength();
    SetLength( GetLength() + length );
    memcpy( GetBuffer() + old_length, text, length );
}

void CString::operator+=( const CString & text )
{
    ulong length = GetLength();
    SetLength( GetLength() + text.GetLength() );
    memcpy( GetBuffer() + length, text.GetBuffer(), text.GetLength() );
}

void CString::operator--( void )
{
    operator-=( 1 );
}

void CString::operator-=( uint32 remove_count )
{
    if( remove_count > GetLength() )
        remove_count = GetLength();

    SetLength( GetLength() - remove_count );
}

bool CString::operator==( char c ) const
{
    return ( GetLength() == 1 && GetBuffer()[ 0 ] == c );
}

bool CString::operator==( const char * text ) const
{
    if( GetLength() != strlen( text ) )
        return false;

    for( uint32 index = 0 ; index < GetLength() ; index ++ )
        if( GetBuffer()[ index ] != text[ index ] )
            return false;

    return true;
}

bool CString::operator==( const CString & text ) const
{
    if( GetLength() != text.GetLength() )
        return false;

    for( uint32 index = 0 ; index < GetLength() ; index ++ )
        if( GetBuffer()[ index ] != text.GetBuffer()[ index ] )
            return false;

    return true;
}

bool CString::operator!=( char c ) const
{
    return !operator==( c );
}

bool CString::operator!=( const char * text ) const
{
    return !operator==( text );
}

bool CString::operator!=( const CString & text ) const
{
    return !operator==( text );
}

bool CString::IsContaining( char c ) const
{
    for( uint32 index = 0 ; index < GetLength() ; index ++ )
        if( GetBuffer()[ index ] == c )
            return true;

    return false;
}

bool CString::IsContaining( const char * text ) const
{
    uint32 length = ( uint32 ) strlen( text );

    if( GetLength() < length || length == 0 )
        return false;

    uint32 index_found = 0;
    bool found = false;

    for( uint32 index = 0 ; index < GetLength() ; index ++ )
    {
        if( found )
        {
            if( GetBuffer()[ index ] != text[ index - index_found ] )
                found = false;
            else if( index - index_found == length - 1 )
                return true;
        }
        else
        {
            if( GetBuffer()[ index ] == text[ 0 ] )
            {
                found = true;
                index_found = index;

                if( length == 1 )
                    return true;
            }
        }
    }

    return false;
}

bool CString::IsContaining( const CString & text ) const
{
    if( GetLength() < text.GetLength() || text.GetLength() == 0 )
        return false;

    uint32 index_found = 0;
    bool found = false;;

    for( uint32 index = 0 ; index < GetLength() ; index ++ )
    {
        if( found )
        {
            if( GetBuffer()[ index ] != text.GetBuffer()[ index - index_found ] )
                found = false;
            else if( index - index_found == text.GetLength() - 1 )
                return true;
        }
        else
        {
            if( GetBuffer()[ index ] == text.GetBuffer()[ 0 ] )
            {
                found = true;
                index_found = index;

                if( text.GetLength() == 1 )
                    return true;
            }
        }
    }

    return false;
}

bool CString::IsSuffixed( const char * suffix ) const
{
    uint32 suffix_length;

    suffix_length = ( uint32 ) strlen( suffix );

    if( suffix_length > GetLength() )
        return false;

    for( uint32 index = 0 ; index < suffix_length ; index ++ )
        if( suffix[ index ] != Buffer[ GetLength() - suffix_length + index ] )
            return false;

    return true;
}

bool CString::IsSuffixed( const CString & suffix ) const
{
    if( suffix.GetLength() > GetLength() )
        return false;

    for( uint32 index = 0 ; index < suffix.GetLength() ; index ++ )
        if( suffix[ index ] != Buffer[ GetLength() - suffix.GetLength() + index ] )
            return false;

    return true;
}

bool CString::IsPrefixed( const char * prefix ) const
{
    uint32 prefix_length;

    prefix_length = ( uint32 ) strlen( prefix );

    if( prefix_length > GetLength() )
        return false;

    for( uint32 index = 0 ; index < prefix_length ; index ++ )
        if( prefix[ index ] != Buffer[ index ] )
            return false;

    return true;
}

bool CString::IsPrefixed( const CString & prefix ) const
{
    if( prefix.GetLength() > GetLength() )
        return false;

    for( uint32 index = 0 ; index < prefix.GetLength() ; index ++ )
        if( prefix[ index ] != Buffer[ index ] )
            return false;

    return true;
}

uint32 CString::GetOccurencesCount( char c ) const
{
    uint32 occurences_count = 0;

    for( uint32 index = 0 ; index < GetLength() ; index ++ )
    {
        if( GetBuffer()[ index ] == c )
            occurences_count ++;
    }

    return occurences_count;
}

uint32 CString::GetInteger( void ) const
{
    return ( uint32 ) atoi( Buffer );   
}

real CString::GetReal( void ) const
{
    return ( real ) atof( Buffer );
}

const char * CString::GetBuffer( void ) const
{
    return Buffer;
}

char * CString::GetBuffer( void )
{
    return Buffer;
}

uint32 CString::GetLength( void ) const
{
    return Length;
}

void CString::Set( const char * text, ... )
{
    SetLength( 0 );

    va_list va_array;
    char line[ 256 ];

    va_start( va_array, text );
    vsprintf( line, text, va_array );
    va_end( va_array );

    operator=( line );
}

bool CString::GetNextWord( CString & word, int32 & last_index ) const
{
    word = "";

    if( last_index != NONE && Buffer[ last_index ] == NULL_CHAR )
        return false;

    while( 1 )
    {
        last_index ++;

        if( Buffer[ last_index ] == NULL_CHAR )
            return true;

        if( Buffer[ last_index ] == ' ' || Buffer[ last_index ] == '\t' || Buffer[ last_index ] == '\n' )
        {
            while( Buffer[ last_index + 1 ] == ' ' || Buffer[ last_index + 1 ] == '\t' || Buffer[ last_index + 1 ] == '\n' )
            {
                last_index ++;

                if( Buffer[ last_index ] == NULL_CHAR )
                    return true;
            }
            
            break;
        }

        word += Buffer[ last_index ];
    }

    return true;
}   

void CString::RemoveFirstWord( void )
{
    CString first_word;
    int32 word_index( NONE );

    if( GetNextWord( first_word, word_index ) )
    {
        char * buffer;

        buffer = ( char * ) malloc( RealLength - first_word.GetLength() - 1 );

        memcpy( buffer, Buffer + first_word.GetLength() + 1, RealLength - first_word.GetLength() - 1 );
        
        *this = buffer;

        free( buffer );
    }
}

void CString::Remove( uint32 character_index )
{
    char * buffer;
    
    buffer = ( char * ) malloc( RealLength - 1 );

    memcpy( buffer, Buffer, character_index );
    memcpy( buffer + character_index, Buffer + character_index + 1, RealLength - character_index - 1 );

    *this = buffer;

    free( buffer );
}

void CString::Insert( CString text, uint32 character_index )
{
    char * buffer;
    
    if( text.GetLength() == 0 )
        return;

    buffer = ( char * ) malloc( RealLength + text.GetLength() );

    memcpy( buffer, Buffer, character_index );
    memcpy( buffer + character_index, text.GetBuffer(), text.GetLength() );
    memcpy( buffer + character_index + text.GetLength(), Buffer + character_index, RealLength - character_index );

    *this = buffer;

    free( buffer );
}

void CString::SetLength( uint32 length )
{
    Length = length;
    RealLength = length + 1;

    if( Buffer == NULL )
        Buffer = ( char * ) malloc( RealLength );
    else
        Buffer = ( char * ) realloc( Buffer, RealLength );

    Buffer[ Length ] = NULL_CHAR;
}

