#ifndef _KONSOLE_TEXT_H_
    #define _KONSOLE_TEXT_H_

    #include "konsole_defs.h"
    #include "list\list.h"
    #include "string\string.h"
    
    class CText
    {
    public:            

        CText( void );
        CText( const CText & text );
        ~CText( void );            

        const CString & operator []( ulong index ) const;
        CString & operator []( ulong index );
        const CText & operator =( const CText & text );
        const CText & operator +=( const CText & text );
        CText operator +( const CText & text ) const;
     
        ulong GetLinesCount( void ) const;
        const CString & GetLine( ulong line_index ) const;
        CString & GetLine( ulong line_index );

        int32 FindLineBeginningWithWord( CString word ) const;
        bool GetNextWord( CString & word, int32 & line_index, int32 & word_index ) const;

        void AddLine( const CString & line );
        void SetEmpty( void );
        void SetFromTextBuffer( const char * text_buffer );
        char * GetTextBuffer( void ) const;
        void RemoveFirstLine( void );
        void RemoveLine( ulong index );
        
    private:           

        CList< CString * > LineArray;
    };
#endif
