#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/unistd.h>
#include <pspkernel.h>
#include <pspctrl.h>
#include <pspdebug.h>
#include <pspdisplay.h>
#include <pspiofilemgr.h>
#include <psptypes.h>
#include <pspsdk.h> 
#include <stdlib.h>

#include "systemctrl_se.h"
#include "pspmodulemgr_kernel.h"
#include "systemctrl.h"
#include "apihook.h"

PSP_MODULE_INFO( "Konsole_Boot", 0x1000, 1, 1 );
PSP_MAIN_THREAD_ATTR( 0 );

void execEboot(char *target)
{	
    struct SceKernelLoadExecVSHParam param;

    memset(&param, 0, sizeof(param));

    param.key = "game";
    param.size = sizeof(param);
    param.args = strlen(target)+1;
    param.argp = target;

    sctrlKernelLoadExecVSHMs2(target, &param);	

}

SceUID executeAsModule( char * elf_path )
{
    SceKernelLMOption option;
    SceUID mpid;
    SceUID module;
    int result, status;

    //mpid = 1;   // kernel
    mpid = 2;   // user

    memset( &option, 0, sizeof( option ) );
    option.size = sizeof( option );
    option.mpidtext = mpid;
    option.mpiddata = mpid;
    option.position = 0;
    option.access = 1;

    module = sceKernelLoadModule( elf_path, 0, &option );

    if( module < 0 )
        return 0;

    result = sceKernelStartModule( module, 0, NULL, &status, NULL );

    if( result < 0 )
    {
        Kprintf( "sceKernelStartModule() failed with %x\n", result );

        return 0;
    }

    return module;
}

void exit_to_mypspmenu( void )
{
    //execEboot( "ms0:/PSP/GAME150/KONSOLE/EBOOT.PBP" );
}

int main_thread( SceSize args, void * argp )
{
    SceModule * mod;
    SceUID uid = 0;

    sceKernelDelayThread( 10 * 100000 );

    while( ( mod = sceKernelFindModuleByName( "konsole" ) ) )
    {
        sceKernelStopModule( mod->modid, 0, NULL, NULL, NULL );
        sceKernelUnloadModule( mod->modid );
    }

    uid = executeAsModule( "ms0:/PSP/GAME150/Konsole/VERTICAL.ELF" );

    if( uid < 0 )
    {
        Kprintf( "Error %08X starting module", uid );
    }
    else
    { 
        mod = sceKernelFindModuleByName( "sceLoadExec" );

        if( mod )
            apiHookByName( mod->modid, "LoadExecForUser", "sceKernelExitGame", exit_to_mypspmenu );
    }

    return sceKernelExitDeleteThread( 0 );
}

int module_start( SceSize args, void *argp )
{
    int thid;

    thid = sceKernelCreateThread( "hook_thread", main_thread, 8, 64 * 1024, 0, NULL );
    
    if( thid >= 0 )
    {
        sceKernelStartThread( thid, args, argp );
    }

    return 0;
}

int module_stop( void )
{
    sceKernelExitDeleteThread( 0 );

    return 0;
}



/*




void reloadMain( void )
{
    executeEboot( "ms0:/PSP/GAME150/Konsole/EBOOT.PBP" );
}

int main_thread( SceSize args, void * argp )
{
    SceModule * mod;
    SceUID uid = 0;

    while( ( mod = sceKernelFindModuleByName( "konsole" ) ) )
    {
        sceKernelStopModule( mod->modid, 0, NULL, NULL, NULL );
        sceKernelUnloadModule( mod->modid );
    }

    mod = sceKernelFindModuleByName( "sceLoadExec" );

    if( mod )
        apiHookByName( mod->modid, "LoadExecForUser", "sceKernelExitGame", ( void * ) reloadMain );

    if( strstr( ( char * ) argp, ".PBP" ) )
    {
        uid = executeAsModule( ( char * ) argp );
    }

    uid = executeAsModule( "ms0:/PSP/GAME150/Konsole/VERTICAL.ELF" );

    if( uid < 0 )
    {
        Kprintf( "Error %08X starting module", uid );
    }

    return sceKernelExitDeleteThread( 0 );
}

int module_start( SceSize args, void * argp )
{
    SceUID th = sceKernelCreateThread( "main_thread", main_thread, 8, 16 * 1024, 0, NULL );

    if( th >= 0 )
    {
        sceKernelStartThread( th, args, argp );
    }

    return 0;
}

int module_stop( SceSize args, void * argp )
{
    return 0;
}
*/