#include "font.h"

CFont::CFont( void ) :
    Height( 0 ),
    FirstCharacterCode( 0 ),
    LastCharacterCode( 0 )
{
}

CFont::~CFont( void )
{
    Destroy();
}

uint16 CFont::GetHeight( void ) const
{
    return Height;
}

const CFontGlyph * CFont::GetGlyph( uint32 character_code ) const
{
    if( character_code < FirstCharacterCode || character_code > LastCharacterCode )
        return NULL;

    return *GlyphArray[ ( ulong )( character_code - FirstCharacterCode ) ];
}

CFontGlyph * CFont::GetGlyph( uint32 character_code )
{
    if( character_code < FirstCharacterCode || character_code > LastCharacterCode )
        return NULL;

    return *GlyphArray[ ( ulong )( character_code - FirstCharacterCode ) ];
}

uint32 CFont::GetGlyphCount( void ) const
{
    return ( uint32 ) GlyphArray.GetSize();
}

bool CFont::Create( CString font_file_path )
{
    FILE * file;
    ulong glyph_index;
    uint32 * character_parameter_array;
    uint32 glyph_count;
    uint16 max_width;

    file = fopen( font_file_path.GetBuffer(), "rb" );

    if( file == NULL )
        return false;

    fseek( file, 88, SEEK_SET );
    fread( &Height, sizeof( uint16 ), 1, file );

    fseek( file, 95, SEEK_SET );
    fread( &FirstCharacterCode, sizeof( uint8 ), 1, file );

    fseek( file, 96, SEEK_SET );
    fread( &LastCharacterCode, sizeof( uint8 ), 1, file );

    fseek( file, 93, SEEK_SET );
    fread( &max_width, sizeof( uint16 ), 1, file );

    WidthBytes = max_width / 8 + 2;

    glyph_count = LastCharacterCode - FirstCharacterCode + 1;

    fseek( file, 118, SEEK_SET );
    character_parameter_array = ( uint32 * ) malloc( sizeof( uint32 ) * glyph_count );
    fread( character_parameter_array, sizeof( uint32 ), glyph_count, file );

    for( glyph_index = 0 ; glyph_index < glyph_count ; glyph_index ++ )
    {
        CFontGlyph * glyph;
        uint16 width;
        uint16 offset;

        width = *( ( ( uint16 * ) character_parameter_array ) + glyph_index * 2 + 0 );
        offset = *( ( ( uint16 * ) character_parameter_array ) + glyph_index * 2 + 1 );

        glyph = new CFontGlyph();
        glyph->Create( width, Height, WidthBytes );

        fseek( file, offset, SEEK_SET );
        fread( glyph->GetBitmap(), sizeof( uint8 ), WidthBytes * Height, file );

        GlyphArray.Add( glyph );
    }

    fclose( file );

    return true;
}

void CFont::Destroy( void )
{
    ulong glyph_index;

    for( glyph_index = 0 ; glyph_index < GlyphArray.GetSize() ; glyph_index ++ )
    {
        delete *GlyphArray[ glyph_index ];
        *GlyphArray[ glyph_index ] = NULL;
    }

    GlyphArray.Erase();
}

