#ifndef _LIBS_FONT_H_
    #define _LIBS_FONT_H_

    #include "libs_defs.h"
    #include "list\list.h"
    #include "string\string.h"
    #include "font_glyph.h"

    class CFont
    {      
    public:

        CFont( void );
        ~CFont( void );

        uint16 GetHeight( void ) const;
        const CFontGlyph * GetGlyph( uint32 character_code ) const;
        CFontGlyph * GetGlyph( uint32 character_code );
        uint32 GetGlyphCount( void ) const;

        bool Create( CString font_file_path );
        void Destroy( void );

    private:

        CList< CFontGlyph * > GlyphArray;
        uint16 Height;
        uint16 WidthBytes;
        uint8 FirstCharacterCode;
        uint8 LastCharacterCode;
    };
#endif

