#ifndef _LIBS_LIST_H_
    #define _LIBS_LIST_H_    

    #include "libs_defs.h"
    #include "array/array.h"

    template< class type > \
    class CList : public CArray
    {      
  
    public:

        CList( void );
        ~CList( void );            

        type * operator []( ulong index ) const;
        
        void Resize( ulong size );
        void Reserve( ulong size );
        ulong Add( type item );
        ulong Insert( type item, ulong index );
        void Remove( ulong index );
        void RemoveItem( type item );
        void Erase( void );
        void RemoveAll( void );
    };

    #include "list.hpp"
#endif
