#ifndef _FRAMEBUFFER_H_
    #define _FRAMEBUFFER_H_

    #include "libs.h"
    
    class CFramebuffer
    {      
    public:

        CFramebuffer( void );
        ~CFramebuffer( void );

        uint32 GetTextModeWidth( void ) const;
        uint32 GetTextModeHeight( void ) const;

        void Print( CString text, uint32 position_x, uint32 position_y );

        bool Initialize( void );
        void Finalize( void );
        void Update( void );

    private:

        void Clear( void );

    private:

        uint32 Width;
        uint32 Height;
        uint32 TextModeWidth;
        uint32 TextModeHeight;
        CFont * Font;

        char * FirstBuffer;
        char * SecondBuffer;
        char * CurrentBuffer;
    };

#endif
